/**
* @file RobotControlMainFrame.h
*
* Declaration of the CRobotControlMainFrame class, 
* a class for the Robot Control main window.
*
* @author Martin Ltzsch
*/ 
#ifndef __RobotControlMainFrame_h_
#define __RobotControlMainFrame_h_

#include "StdAfx.h"
#include <map>

#include "MfcTools/IEStyleToolBars/FrameWndEx.h"
#include "RobotControlDialogBar.h"
#include "RobotControlToolBar.h"
#include "RobotControlMenu.h"
#include "Visualization/DebugDrawingManager/DebugDrawingManager.h"
#include "Dialogs/SplashScreenDlg.h"

/**
* @class CRobotControlMainFrame 
*
* The RobotControl main window. 
* Embeds the dialogs and toolbars. 
* Hosts the debug drawing manager.
*
* @author Martin Ltzsch
*/
class CRobotControlMainFrame : public CMDIFrameWndEx
{
  DECLARE_DYNAMIC(CRobotControlMainFrame);
public:

  /** Constructor */
  CRobotControlMainFrame();
  
  /** Deconstructor */
  virtual ~CRobotControlMainFrame();
  
  /** 
  * Sends a message to a dialog bar
  * @param dialogID The id of the dialog bar (from resource.h)
  * @param message The message
  * @return If the message was handled
  */
  bool handleMessageInDialog(UINT dialogID,InMessage& message);

  /** Should be called for idle processings */
  void OnIdle();
  
  /** 
  * Creates the dialogs and toolbars. This is not done in OnCreate but later.
  * @param splashScreen A reference to the splash screen to display progress messages.
  */
  void createDialogBarsAndToolBars(CSplashScreenDlg& splashScreen);
  
  /** Handles WM_COMMAND control notifications */
  virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
  
  /** Custom message routing */
  virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
  
  /** 
  * Is called when a configuration is loaded. 
  * @param sectionName The registry section for the current configuration
  */
  void OnConfigurationLoad(CString sectionName);
  
  /** 
  * Is called when a configuration is saved. 
  * @param sectionName The registry section for the current configuration
  */
  void OnConfigurationSave(CString sectionName);
  
  /** The DebugDrawingManager */
  DebugDrawingManager debugDrawingManager;
  
protected:

  /** Allows to access the dialog bars by their id */
  std::map<UINT,CRobotControlDialogBar*> dialogBarMap;
  
  /** Allows to access the dialog bars by number */
  CArray<CRobotControlDialogBar*,CRobotControlDialogBar*> dialogBarArray;
  
  /** Only used to delete the dialog bars in the end */
  CArray<CDynamicBarT<CRobotControlDialogBar>*,CDynamicBarT<CRobotControlDialogBar>*> dynamicBarArray;

  /** Allows to access the tool bars by their id */
  std::map<UINT,CRobotControlToolBar*> toolBarMap;

  /** Allows to access the tool bars by number */
  CArray<CRobotControlToolBar*,CRobotControlToolBar*> toolBarArray;

  /** The status bar */
  CStatusBar m_wndStatusBar;

  /** Handles the entries of the main menu */
  CRobotControlMenu menu;

  //{{AFX_MSG(CRobotControlMainFrame)
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
  afx_msg void OnClose();
  afx_msg void OnDropDown(NMHDR* pNotifyStruct,LRESULT* pResult);
  afx_msg void OnDestroy();
  afx_msg void OnViewToolBar(UINT nID);
  afx_msg void OnUpdateViewBar(CCmdUI* pCmdUI);
  afx_msg void OnUpdateCmdUI(CCmdUI* pCmdUI );
  afx_msg void OnAppAbout();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP();
};


//{{AFX_INSERT_LOCATION}}


#endif // __RobotControlMainFrame_h_

/*
* Change log :
* 
* $Log: RobotControlMainFrame.h,v $
* Revision 1.1.1.1  2004/05/22 17:26:39  cvsadm
* created new repository GT2004_WM
*
* Revision 1.10  2004/02/13 13:29:05  loetzsch
* added class CRobotControlMenu
*
* Revision 1.9  2003/12/15 13:05:04  loetzsch
* RobotControl now displays a splash screen at the beginning
*
* Revision 1.8  2003/12/14 22:45:18  loetzsch
* renamed CRobotControlMainFrame::createDialogs to
* createDialogBarsAndToolBars.
*
* Revision 1.7  2003/12/06 16:44:45  loetzsch
* improved message handling
*
* Revision 1.6  2003/12/06 06:31:19  loetzsch
* no message
*
* Revision 1.5  2003/12/02 18:27:20  dueffert
* first working not yet calibrated version of UDWalkingEngine added
*
* Revision 1.4  2003/11/30 01:53:19  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.3  2003/11/18 10:21:01  lohmann
* Worldstate_Analysis_Dlg_Bar added!
*
* Revision 1.2  2003/11/17 14:56:04  urban
* added SensorBehaviorControl-solution "AlLx RemotePresence" and RobotControl-dialogbar "AlLx Joystick"
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/26 15:28:24  juengel
* Renamed DataTypes to representations.
*
* Revision 1.2  2003/08/25 17:24:27  juengel
* Added HistogramDialogBar
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.29  2003/05/11 23:51:02  dueffert
* Depend now works with RobotControl too
*
* Revision 1.28  2003/04/16 14:14:38  loetzsch
* removed Xabsl 1 from GT2003
*
* Revision 1.27  2003/03/26 11:23:22  tim
* Added potentialfield viewer
*
* Revision 1.26  2003/03/25 11:46:53  dueffert
* team wlan support improved
*
* Revision 1.25  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.24  2003/03/22 16:39:33  loetzsch
* continued GUI for simulated robots
*
* Revision 1.23  2003/03/20 20:36:22  loetzsch
* renamed SimulatorToolbar to Simulated Robots toolbar
* added class CRobotControlSimulatedRobots
* started implementing the GUI for 8 simulated robots
*
* Revision 1.22  2003/03/19 09:11:04  dueffert
* team wlan support improved
*
* Revision 1.21  2003/03/13 16:39:47  dueffert
* wlan toolbar can handle teams now
*
* Revision 1.20  2003/03/05 11:08:35  loetzsch
* added class GlobalGameControlData
* the Game Toolbar now sents GlobalGameControlData
* removed Playerstoolbar
*
* Revision 1.19  2003/03/04 14:51:02  juengel
* Added GridImageProcessor2DlgBar
*
* Revision 1.18  2003/02/27 15:30:47  loetzsch
* added the value history dialog
*
* Revision 1.17  2003/02/11 21:14:16  ding
* Comments for ObjectRecognitionDlgBar removed
*
* Revision 1.16  2003/02/11 18:20:16  osterhues
* Temporarily disabled ObjectRecognitionDlgBar support
*
* Revision 1.15  2003/02/11 10:14:04  dasmuli
* Introduction of the object recognition user interface.
*
* Revision 1.14  2003/01/31 13:40:50  osterhues
* Added TSL color table tool
*
* Revision 1.13  2003/01/22 12:21:18  dueffert
* doxygen docu corrected
*
* Revision 1.12  2003/01/19 13:04:11  loetzsch
* the settings of the simulator field view are now also stored in the registry for
* each configuration
*
* Revision 1.11  2003/01/09 14:07:39  jhoffman
* added 3d field view
*
* Revision 1.10  2002/12/06 11:30:13  juengel
* Added Xabsl2Dlg.
*
* Revision 1.9  2002/12/03 15:03:04  cesarz
* InvKinParametersDlgBar added.
*
* Revision 1.8  2002/11/19 12:57:55  dueffert
* queuefillrequest added, debugkey toolbar extended, memorystick toolbar removed
*
* Revision 1.7  2002/11/18 17:30:31  loetzsch
* Sound requests generated from BehaviorControl are now automatically sent
* to RobotControl and played there.
*
* Revision 1.6  2002/10/10 13:09:49  loetzsch
* First experiments with the PSD Sensor
* - SensorDataProcessor now calculates PSDPercept
* - Added the PerceptBehaviorControl solution PSDTest
* - Added the RadarViewer3D to RobotControl, which can display the Points3D structure
*
* Revision 1.5  2002/09/20 23:28:33  juengel
* Moved instance of DebugDrawingManager to RobotControlMainFrame.
*
* Revision 1.4  2002/09/19 12:46:24  loetzsch
* removed Viewers toolbar
*
* Revision 1.3  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.2  2002/09/11 20:02:54  loetzsch
* removed AutoColor Dialog related files
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.15  2002/09/01 19:04:24  loetzsch
* removed a few dialogs
*
* Revision 1.14  2002/09/01 18:48:38  loetzsch
* removed a few dialogs
*
* Revision 1.13  2002/09/01 17:20:34  loetzsch
* tidied up the MfcTools/ directory. Created directories
* MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
*
* Revision 1.12  2002/08/30 17:12:50  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.11  2002/08/30 14:06:43  juengel
* Renamed BlobViewer to LargeImageViewer
*
* Revision 1.10  2002/08/21 11:50:44  cesarz
* GT2001PlayersPerceptor, BerlinSelfLocator, GT2001WalkingEngine,
* DoWalkingEngine, FuzzyBehaviorControl, BremenGOBehaviorControl,
* FuzzyBehaviortesterdlgbar and Behaviortesterdlgbar removed.
*
* Revision 1.9  2002/08/13 12:57:41  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
* - Renamed CLayoutToolBar to CConfigurationToolBar
* - Added CRobotControlConfigurationManager
* - Removed CToolsToolBar
*
* Revision 1.8  2002/08/08 16:40:30  loetzsch
* added class LogPlayer and redesigned RobotControl's Logplayer GUI
*
* Revision 1.7  2002/08/07 10:50:21  loetzsch
* - removed direct access to the dialogs
* - faster starting of RobotControl application and main window
* - general clean up
*
* Revision 1.6  2002/07/23 13:44:48  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - new debug message handling
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.5  2002/06/20 23:38:48  dueffert
* player toolbar & wlan toolbar completed
*
* Revision 1.4  2002/06/04 14:47:39  loetzsch
* several bug fixes
*
* Revision 1.3  2002/06/04 00:15:37  loetzsch
* RobotControl now can simulate four robots.
*
* Revision 1.2  2002/05/16 22:36:12  roefer
* Team communication and GTMath bugs fixed
*
* Revision 1.1.1.1  2002/05/10 12:40:19  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.64  2002/05/05 22:12:42  loetzsch
* GameControlData can now be sent from the Game toolbar to BehaviorControl
*
* Revision 1.63  2002/05/05 18:53:02  loetzsch
* removed Modules toolbar
* added Game toolbar
*
* Revision 1.62  2002/04/30 09:04:38  khuebner
* AutoColor Dialog included
*
* Revision 1.61  2002/04/24 14:45:41  dueffert
* WLANToolbar saves actual setting in registry
*
* Revision 1.60  2002/04/23 17:45:17  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.59  2002/04/17 09:52:04  dueffert
* PlayersToolbar enhancements
*
* Revision 1.58  2002/04/16 16:09:14  dueffert
* PlayersToolbar & WlanNewDialog synchronized
*
* Revision 1.57  2002/04/08 13:34:14  dueffert
* PlayersToolBar added
*
* Revision 1.56  2002/04/04 15:24:16  fischer
* Added Fuzzy Behavior Tester Dialog (without functionality).
*
* Revision 1.55  2002/04/04 11:04:00  risler
* added DebugMessageGenerator
*
* Revision 1.54  2002/03/29 09:32:42  roefer
* Buttons for switches and crash in simulator toolbar are now working
*
* Revision 1.53  2002/03/26 19:03:42  loetzsch
* added xabsl toolbar
*
* Revision 1.51  2002/03/25 09:29:03  rentmeister
* Behavior Dialog
*
* Revision 1.50  2002/03/12 14:07:58  jhoffman
* added open gl viewer dialog
*
* Revision 1.49  2002/03/04 11:54:13  dueffert
* JoystickMotionTester added
*
* Revision 1.48  2002/02/28 11:54:58  jhoffman
* added ScoreBoard Dialog Bar
*
* Revision 1.47  2002/02/25 09:58:50  rentmeister
* Evolver verndert
*
* Revision 1.46  2002/02/24 10:02:21  juengel
* TimeDiagramDlgBar completed.
*
* Revision 1.45  2002/02/23 18:35:18  loetzsch
* added "clear debug queue to robot" to the "Extras" menu
*
* Revision 1.44  2002/02/18 14:08:00  juengel
* SettingsDlgBar added.
*
* Revision 1.43  2002/02/12 16:34:49  risler
* finished MofTester
*
* Revision 1.42  2002/02/12 01:02:23  risler
* added MofTester
*
* Revision 1.41  2002/02/09 15:13:37  juengel
* ColorSpaceDlgBar added.
*
* Revision 1.40  2002/02/08 13:28:08  loetzsch
* Visualization of PerceptCollection and RadarViewer started
* (not implemented yet)
*
* Revision 1.39  2002/02/07 16:28:11  loetzsch
* improved toolbars
*
* Revision 1.38  2002/02/04 11:39:47  juengel
* ImageProcessorTester dialog added.
*
* Revision 1.37  2002/01/30 17:33:22  loetzsch
* Joint Viewer vorerst fertig
*
* Revision 1.36  2002/01/26 18:50:36  juengel
* DebugDrawingManager umstrukturiert.
*
* Revision 1.35  2002/01/26 18:09:20  juengel
* DebugDrawingManager umstrukturiert.
*
* Revision 1.34  2002/01/25 18:02:26  roefer
* SYNCs reduced
*
* Revision 1.33  2002/01/25 16:54:56  loetzsch
* Messages from OVirtualRobotComm are sent now in a synchronized way
*
* Revision 1.32  2002/01/24 22:57:22  risler
* finished WLAN Toolbar
*
* Revision 1.31  2002/01/24 18:19:19  loetzsch
* JointViewer added
*
* Revision 1.30  2002/01/24 11:44:35  risler
* added WLAN Toolbar
*
* Revision 1.29  2002/01/23 15:54:34  udo
* Das Dortmunder Motion-Evolve-Tool
*
* Revision 1.28  2002/01/22 14:48:52  juengel
* TestDataGenerator eingefhrt
*
* Revision 1.27  2002/01/19 21:36:24  risler
* added HeadMotionTester, HeadControlSelector
*
* Revision 1.26  2002/01/18 23:30:08  loetzsch
* Distribution of HeadControlModes, HeadMotionRequests and SolutionRequests added
*
* Revision 1.25  2002/01/18 02:17:39  loetzsch
* MotionTester dialog and distribution of MotionRequests
* to the processes programmed.
*
* Revision 1.24  2002/01/17 14:35:48  risler
* SolutionRequest added
*
* Revision 1.23  2002/01/15 23:54:15  loetzsch
* SolutionRequest introduced
*
* Revision 1.22  2002/01/14 22:43:01  loetzsch
* SimRobot / RobotControl integration started
*
* Revision 1.21  2002/01/13 14:12:02  kspiess
* HSIColorTableTool-Dialog in RobotControl eingebaut; Implementierung der Funktionalitaet kommt bald
*
* Revision 1.20  2001/12/20 19:23:19  juengel
* Neue Klasse CRobotControlDlg gebaut.
*
* Revision 1.19  2001/12/17 16:40:38  loetzsch
* Removed old "OnOpen...Dlg()" functions
*
* Revision 1.18  2001/12/15 19:26:13  juengel
* ColorTable, ColorTable64, ColorTable64DlgBar hinzugefgt.
*
* Revision 1.17  2001/12/14 12:26:11  loetzsch
* CameraParameters Toolbar weitergemacht
*
* Revision 1.16  2001/12/13 15:28:45  bach
* Toolbar for Camera Parameters added (very premature looking)
*
* Revision 1.15  2001/12/13 15:03:02  loetzsch
* DebugKeyToolBar fertig
*
* Revision 1.14  2001/12/13 12:58:16  loetzsch
* MemoryStick ToolBar hinzugefgt und an anderen Toolbars herumgebastelt
*
* Revision 1.13  2001/12/12 15:21:08  juengel
* CDebugKeyToolBar in eigenes .cpp und .h File verlagert.
*
* Revision 1.12  2001/12/11 15:14:24  juengel
* CLogPlayerToolBar in eigenes .cpp und .h File verlagert. Abspielfunktionalitt des LogPlayers implementiert.
*
* Revision 1.11  2001/12/10 17:47:09  risler
* change log added
*
*/
