/**
* @file RobotControlMainFrame.cpp
*
* Implementation of the CRobotControlMainFrame class, a class for the Robot Control main window.
*
* @author Martin Ltzsch
*/

#include "StdAfx.h"

#include "RobotControlMainFrame.h"
#include "RobotControlConfigurationManager.h"
#include "RobotControlPhysicalRobots.h"

// include the header files of all dialogs and toolbars here (alphabetically).
#include "Bars/CameraParametersToolBar.h"
#include "Bars/ColorSpaceDlgBar.h"
#include "Bars/ColorTable64DlgBar.h"
#include "Bars/DebugKeysToolBar.h"
#include "Bars/DebugMessageGeneratorDlgBar.h"
#include "Bars/GameToolBar.h"
#include "Bars/HSIColorTableToolDlgBar.h"
#include "Bars/HeadMotionTesterDlgBar.h"
#include "Bars/HistogramDlgBar.h"
#include "Bars/ImageViewerDlgBar.h"
#include "Bars/InvKinParametersDlgBar.h"
#include "Bars/JointViewerDlgBar.h"
#include "Bars/JoystickMotionTesterDlgBar.h"
#include "Bars/KickEditorDlgBar.h"
#include "Bars/LargeImageViewerDlgBar.h"
#include "Bars/LogPlayerToolBar.h"
#include "Bars/MessageViewerDlgBar.h"
#include "Bars/MofTesterDlgBar.h"
#include "Bars/MotionTesterDlgBar.h"
#include "Bars/PotentialFieldViewerDlgBar.h"
#include "Bars/RadarViewer3DDlgBar.h"
#include "Bars/RadarViewerDlgBar.h"
#include "Bars/SettingsDlgBar.h"
#include "Bars/SimulatedRobotsToolBar.h"
#include "Bars/SimulatorObjectViewerDlgBar.h"
#include "Bars/TSLColorTableToolDlgBar.h"
#include "Bars/TestDataGeneratorDlgBar.h"
#include "Bars/TimeDiagramDlgBar.h"
#include "Bars/UDParameterSetDlgBar.h"
#include "Bars/ValueHistoryDlgBar.h"
#include "Bars/WLANToolBar.h"
#include "Bars/Xabsl2DlgBar.h"
#include "Bars/XABSL2ProfilerDlgBar.h"
#include "Bars/KalmanSettingsDlgBar.h"

#include "Dialogs/AboutDlg.h"


IMPLEMENT_DYNAMIC(CRobotControlMainFrame, CMDIFrameWndEx)

BEGIN_MESSAGE_MAP(CRobotControlMainFrame, CMDIFrameWndEx)
//{{AFX_MSG_MAP(CRobotControlMainFrame)
ON_WM_CREATE()
ON_WM_CLOSE()
ON_COMMAND_RANGE(IDD_DIALOG_BAR_FIRST,IDD_DIALOG_BAR_LAST,OnViewToolBar)
ON_UPDATE_COMMAND_UI_RANGE(IDD_DIALOG_BAR_FIRST,IDD_DIALOG_BAR_LAST,OnUpdateViewBar)
ON_UPDATE_COMMAND_UI_RANGE(1000,6000,OnUpdateCmdUI)
ON_NOTIFY(TBN_DROPDOWN,ID_TOOLBAR_SIMULATED_ROBOTS,OnDropDown)
ON_WM_DESTROY()
ON_WM_PAINT()
ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CRobotControlMainFrame::createDialogBarsAndToolBars(CSplashScreenDlg& splashScreen)
{
  m_wndStatusBar.Create(this);
  m_wndStatusBar.ShowWindow(SW_HIDE);

  // create toolbars here (in alphabetical order).
  CREATE_TOOLBAR(CCameraParametersToolBar,ID_TOOLBAR_CAMERAPARAMETERS,"Camera","&Camera");
  CREATE_TOOLBAR(CDebugKeysToolBar,ID_TOOLBAR_DEBUGKEYS,"Debug Keys","&Debug Keys");
  CREATE_TOOLBAR(CGameToolBar,ID_TOOLBAR_GAME,"Game","&Game");
  CREATE_TOOLBAR(CLogPlayerToolBar,ID_TOOLBAR_LOGPLAYER,"Log Player","&Log Player");
  CREATE_TOOLBAR(CSimulatedRobotsToolBar,ID_TOOLBAR_SIMULATED_ROBOTS,"Simulator", "&Simulator");
  CREATE_TOOLBAR(CWLANToolBar,ID_TOOLBAR_WLAN,"WLAN","&WLAN");

  EnableDocking(CBRS_ALIGN_ANY);
  
  // create dialogs here (in alphabetical order).
  CREATE_DIALOG_BAR(CColorSpaceDlgBar,"3D color space visualizer",IDD_DIALOG_BAR_COLOR_SPACE);
  CREATE_DIALOG_BAR(CColorTable64DlgBar,"ColorTable64 tool",IDD_DIALOG_BAR_COLORTABLE64);
  CREATE_DIALOG_BAR(CDebugMessageGeneratorDlgBar,"Debug message generator",IDD_DIALOG_BAR_DEBUGMESSAGEGENERATOR);
  CREATE_DIALOG_BAR(CHSIColorTableToolDlgBar,"HSI color table tool",IDD_DIALOG_BAR_HSICOLORTABLETOOL);
  CREATE_DIALOG_BAR(CHeadMotionTesterDlgBar,"Head motion tester",IDD_DIALOG_BAR_HEADMOTIONTESTER);
  CREATE_DIALOG_BAR(CHistogramDlgBar,"Histogram",IDD_DIALOG_BAR_HISTOGRAM);
  CREATE_DIALOG_BAR(CImageViewerDlgBar,"Image viewer",IDD_DIALOG_BAR_IMAGEVIEWER);
  CREATE_DIALOG_BAR(CInvKinParametersDlgBar,"Inv. kin. walking parameters",IDD_DIALOG_BAR_INVKINPARAMETERS);
  CREATE_DIALOG_BAR(CJointViewerDlgBar,"Joint angles viewer",IDD_DIALOG_BAR_JOINT_VIEWER);
  CREATE_DIALOG_BAR(CJoystickMotionTesterDlgBar,"Joystick remote control",IDD_DIALOG_BAR_JOYSTICKMOTIONTESTER);
  CREATE_DIALOG_BAR(CKickEditorDlgBar,"Kick Editor",IDD_DIALOG_BAR_KICK_EDITOR);
  CREATE_DIALOG_BAR(CLargeImageViewerDlgBar,"Large image viewer",IDD_DIALOG_BAR_LARGEIMAGEVIEWER);
  CREATE_DIALOG_BAR(CMessageViewerDlgBar,"Message console",IDD_DIALOG_BAR_MESSAGEVIEWER);
  CREATE_DIALOG_BAR(CMofTesterDlgBar,"MOF tester",IDD_DIALOG_BAR_MOFTESTER);
  CREATE_DIALOG_BAR(CMotionTesterDlgBar,"Motion tester",IDD_DIALOG_BAR_MOTIONTESTER);
  CREATE_DIALOG_BAR(CPotentialFieldViewerDlgBar,"Potential Field Viewer",IDD_DIALOG_BAR_POTENTIAL_FIELD_VIEWER);
  CREATE_DIALOG_BAR(CRadarViewer3DDlgBar,"3D radar viewer",IDD_DIALOG_BAR_RADAR_VIEWER_3D);
  CREATE_DIALOG_BAR(CRadarViewerDlgBar,"Radar viewer",IDD_DIALOG_BAR_RADAR_VIEWER);
  CREATE_DIALOG_BAR(CSettingsDlgBar,"Module settings",IDD_DIALOG_BAR_SETTINGS);
  CREATE_DIALOG_BAR(CSimulatorObjectViewerDlgBar,"Simulator field view",IDD_DIALOG_BAR_SIMULATOR_OBJECT_VIEWER);
  CREATE_DIALOG_BAR(CTSLColorTableToolDlgBar,"TSL color table tool",IDD_DIALOG_BAR_TSLCOLORTABLETOOL);
  CREATE_DIALOG_BAR(CTestDataGeneratorDlgBar,"Test data generator",IDD_DIALOG_BAR_TEST_DATA_GENERATOR);
  CREATE_DIALOG_BAR(CTimeDiagramDlgBar,"Runtime Analyzer",IDD_DIALOG_BAR_TIME_DIAGRAM);
  CREATE_DIALOG_BAR(CUDParameterSetDlgBar,"UDParameterSet",IDD_DIALOG_BAR_UDPARAMETERSET);
  CREATE_DIALOG_BAR(CValueHistoryDlgBar,"Value history dialog",IDD_DIALOG_BAR_VALUE_HISTORY);
  CREATE_DIALOG_BAR(CXabsl2DlgBar,"Xabsl2 monitor and tester",IDD_DIALOG_BAR_XABSL2);
  CREATE_DIALOG_BAR(CXABSL2ProfilerDlgBar,"Xabsl2Profiler",IDD_DIALOG_BAR_XABSL2PROFILER);
  CREATE_DIALOG_BAR(CKalmanSettingsDlgBar,"Kalman settings",IDD_DIALOG_BAR_KALMAN_SETTINGS);
  
  UINT statusBarIndicators[] =
  {
    ID_SEPARATOR,           // status line indicator
      IDC_STATUS_BAR_SIMULATION_STEPS,
      IDC_STATUS_BAR_LOGPLAYER_MESSAGE,
      IDC_STATUS_BAR_LOGPLAYER_MESSAGE_ID,
      IDC_STATUS_BAR_LOGPLAYER_FILENAME
  };
  m_wndStatusBar.SetIndicators(statusBarIndicators,sizeof(statusBarIndicators)/sizeof(UINT));
  m_wndStatusBar.SetPaneInfo(1,statusBarIndicators[1],0,40);
  m_wndStatusBar.SetPaneInfo(2,statusBarIndicators[2],0,40);
  m_wndStatusBar.SetPaneInfo(3,statusBarIndicators[3],0,60);
  m_wndStatusBar.SetPaneInfo(4,statusBarIndicators[4],0,130);

  splashScreen.setMessage("Loading the last configuration and displaying RobotControl ...");

  menu.init();

  getConfigurationManager().loadConfiguration();

  m_wndStatusBar.ShowWindow(SW_NORMAL);
  m_wndReBar.ShowWindow(SW_NORMAL);

}

void CRobotControlMainFrame::OnUpdateCmdUI(CCmdUI* pCmdUI)
{
  if (pCmdUI->m_nID >= 5000)
  {
    menu.updateUI(pCmdUI);
  }
  else
  {
    switch(pCmdUI->m_nID)
    {
    case IDC_LOGPLAYER_NEW:
    case IDC_LOGPLAYER_OPEN:
    case IDC_LOGPLAYER_PLAY:
    case IDC_LOGPLAYER_STOP:
    case IDC_LOGPLAYER_PAUSE:
    case IDC_LOGPLAYER_STEP_FORWARD:
    case IDC_LOGPLAYER_STEP_BACKWARD:
    case IDC_LOGPLAYER_STEP_REPEAT:
    case IDC_LOGPLAYER_JUMP_FRAME:
    case IDC_LOGPLAYER_RECORD:
    case IDC_LOGPLAYER_SAVE:
    case IDC_LOGPLAYER_SMOOTH:
    case IDC_STATUS_BAR_LOGPLAYER_MESSAGE:
    case IDC_STATUS_BAR_LOGPLAYER_MESSAGE_ID:
    case IDC_STATUS_BAR_LOGPLAYER_FILENAME:
      toolBarMap[ID_TOOLBAR_LOGPLAYER]->updateUI(pCmdUI);
      break;
    case IDC_WLAN_COMBO:
    case IDC_WLAN_ADD:
    case IDC_WLAN_EDIT:
    case IDC_WLAN_DELETE:
    case IDC_WLAN_CONNECT:
    case IDC_WLAN_DISCONNECT:
    case IDC_WLAN_RED1:
    case IDC_WLAN_RED2:
    case IDC_WLAN_RED3:
    case IDC_WLAN_RED4:
    case IDC_WLAN_BLUE1:
    case IDC_WLAN_BLUE2:
    case IDC_WLAN_BLUE3:
    case IDC_WLAN_BLUE4:
      toolBarMap[ID_TOOLBAR_WLAN]->updateUI(pCmdUI);
      break;
    case IDC_SIMROBOT_DETAIL_LEVEL:
    case IDC_SIMROBOT_ZOOM:
    case IDC_SIMROBOT_VIEW_HIDDEN_LINES:
    case IDC_SIMROBOT_ZOOM0:
    case IDC_SIMROBOT_ZOOM1:
    case IDC_SIMROBOT_ZOOM2:
    case IDC_SIMROBOT_ZOOM3:
    case IDC_SIMROBOT_ZOOM4:
    case IDC_SIMROBOT_ZOOM5:
    case IDC_SIMROBOT_ZOOM6:
    case IDC_SIMROBOT_ZOOM7:
    case IDC_SIMROBOT_ZOOM8:
    case IDC_SIMROBOT_ZOOM9:
    case IDC_SIMROBOT_DETAIL_LEVEL0:
    case IDC_SIMROBOT_DETAIL_LEVEL1:
    case IDC_SIMROBOT_DETAIL_LEVEL2:
    case IDC_SIMROBOT_DETAIL_LEVEL3:
    case IDC_SIMROBOT_DETAIL_LEVEL4:
    case IDC_SIMROBOT_DETAIL_LEVEL5:
    case IDC_SIMROBOT_DETAIL_LEVEL6:
    case IDC_SIMROBOT_DETAIL_LEVEL7:
    case IDC_SIMROBOT_DETAIL_LEVEL8:
    case IDC_SIMROBOT_DETAIL_LEVEL9:
    case IDC_SIMROBOT_DISTORTION0:
    case IDC_SIMROBOT_DIST0RTION1:
    case IDC_SIMROBOT_DIST0RTION2:
    case IDC_SIMROBOT_DISTORTION3:
    case IDC_SIMROBOT_DIST0RTION4:
    case IDC_SIMROBOT_DIST0RTION5:
      dialogBarMap[IDD_DIALOG_BAR_SIMULATOR_OBJECT_VIEWER]->updateUI(pCmdUI);
      break;
    case IDC_SIMROBOT_START:
    case IDC_SIMROBOT_STEP:
    case IDC_SIMROBOT_RESET:
    case IDC_SIMROBOT_SEND_ORACLED_WORLD_STATE_LOCAL:
    case IDC_SIMULATED_ROBOT1:
    case IDC_SIMULATED_ROBOT2:
    case IDC_SIMULATED_ROBOT3:
    case IDC_SIMULATED_ROBOT4:
    case IDC_SIMULATED_ROBOT5:
    case IDC_SIMULATED_ROBOT6:
    case IDC_SIMULATED_ROBOT7:
    case IDC_SIMULATED_ROBOT8:
    case IDC_STATUS_BAR_SIMULATION_STEPS:
    case IDC_SIMROBOT_CRASHED:
    case IDC_SIMROBOT_BACK_PRESSED:
    case IDC_SIMROBOT_HIND_HEAD_PRESSED:
    case IDC_SIMROBOT_FORE_HEAD_PRESSED:
    case IDC_DISABLE_SIMULATED_ROBOTS:
      toolBarMap[ID_TOOLBAR_SIMULATED_ROBOTS]->updateUI(pCmdUI);
      break;
    case IDC_MOFTESTER_EXECUTE_BUTTON:
    case IDC_MOFTESTER_LOOP:
      dialogBarMap[IDD_DIALOG_BAR_MOFTESTER]->updateUI(pCmdUI);
      break;
    case IDC_JOINT_VIEWER_HSCROLL:
      dialogBarMap[IDD_DIALOG_BAR_JOINT_VIEWER]->updateUI(pCmdUI);
      break;
    case IDC_XABSL2PROFILER_FRAMENUMBER_EDIT : 
      dialogBarMap[IDD_DIALOG_BAR_XABSL2PROFILER]->updateUI(pCmdUI);
      break;
    case IDC_XABSL2_PARAM_EDIT1:
    case IDC_XABSL2_PARAM_EDIT2:
    case IDC_XABSL2_PARAM_EDIT3:
    case IDC_XABSL2_PARAM_EDIT4:
    case IDC_XABSL2_PARAM_EDIT5:
      dialogBarMap[IDD_DIALOG_BAR_XABSL2]->updateUI(pCmdUI);
      break;
    case IDC_TDG_DESCRIPTION_A_EDIT:
    case IDC_TDG_DESCRIPTION_B_EDIT:
    case IDC_TDG_DESCRIPTION_C_EDIT:
    case IDC_TDG_DESCRIPTION_D_EDIT:
    case IDC_TDG_DESCRIPTION_E_EDIT:
    case IDC_TDG_DESCRIPTION_F_EDIT:
    case IDC_TDG_DESCRIPTION_G_EDIT:
    case IDC_TDG_DESCRIPTION_H_EDIT:
    case IDC_TDG_DESCRIPTION_I_EDIT:
    case IDC_TDG_DESCRIPTION_J_EDIT:
      dialogBarMap[IDD_DIALOG_BAR_TEST_DATA_GENERATOR]->updateUI(pCmdUI);
      break;
    case IDC_DEBUGKEY_EDIT_FOR_ROBOT:
    case IDC_DEBUGKEY_EDIT_FOR_LOCAL:
    case IDC_DEBUGKEY_DISABLED_RADIO:
    case IDC_DEBUGKEY_ALWAYS_RADIO:
    case IDC_DEBUGKEY_NTIMES_RADIO:
    case IDC_DEBUGKEY_EVERYNTIMES_RADIO:
    case IDC_DEBUGKEY_EVERYNMS_RADIO:
    case IDC_DEBUGKEY_N_EDIT:
    case IDC_DEBUGKEY_IMMEDIATE_RADIO:
    case IDC_DEBUGKEY_REALTIME_RADIO:
    case IDC_DEBUGKEY_WLAN_N_RADIO:
    case IDC_DEBUGKEY_STICK_N_RADIO:
    case IDC_DEBUGKEY_STICK_IMMEDIATE_RADIO:
    case IDC_DEBUGKEY_REJECT_RADIO:
    case IDC_DEBUGKEY_SECONDS_EDIT:
      toolBarMap[ID_TOOLBAR_DEBUGKEYS]->updateUI(pCmdUI);
      break;
    case IDC_INVKINPAR_BUTTON_SEND:
    case IDC_INVKINPAR_BUTTON_MUTATE:
    case IDC_INVKINPAR_RADIO_PARENT:
    case IDC_INVKINPAR_RADIO_OFFSPRING:
      dialogBarMap[IDD_DIALOG_BAR_INVKINPARAMETERS]->updateUI(pCmdUI);
      break;
    case IDC_GAME_READY:
    case IDC_GAME_PLAYING:
    case IDC_GAME_FINISHED:
    case IDC_GAME_INITIAL:
    case IDC_GAME_SET:
    case IDC_GAME_PENALIZED:
    case IDC_GAME_KICKOFF_RED:
    case IDC_GAME_KICKOFF_BLUE:
    case IDC_GAME_BLUE_GOAL:
    case IDC_GAME_RED_GOAL:
      toolBarMap[ID_TOOLBAR_GAME]->updateUI(pCmdUI);
      break;
    default:
      pCmdUI->Enable(true);
    }
  }
}


CRobotControlMainFrame::CRobotControlMainFrame()
{
}

CRobotControlMainFrame::~CRobotControlMainFrame()
{
  int i;

  for (i=0;i<toolBarArray.GetSize();i++)
    delete toolBarArray[i]; // delete all tool bars

  for (i=0;i<dialogBarArray.GetSize();i++)
    delete dynamicBarArray[i]; // delete all dialog bars
}


BOOL CRobotControlMainFrame::OnCmdMsg(UINT nID, int nCode,
                                      void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
  int handled = 0;
  int i;
  switch(nCode)
  {
  case WM_COMMAND:
    if (OnCommand(nID,nCode)) return true;
    break;
  case CBN_SELCHANGE:
    for (i=0;i<toolBarArray.GetSize();i++)
      if (toolBarArray[i]->handleSelChange(nID)) return true;
    break;
  case EN_CHANGE:
    for (i=0;i<toolBarArray.GetSize();i++)
      if (toolBarArray[i]->handleEditChange(nID))  return true;
    break;
  }
  if (handled) return 1;
  
  return CMDIFrameWndEx::OnCmdMsg(nID,nCode,pExtra,pHandlerInfo);
}

BOOL CRobotControlMainFrame::OnCommand(WPARAM wParam, LPARAM lParam)
{
  int i;
  for (i=0;i<toolBarArray.GetSize();i++)
    if (toolBarArray[i]->handleCommand(wParam)) return true;

  for (i=0;i<dialogBarArray.GetSize();i++)
    if (dialogBarArray[i]->handleCommand(wParam)) return true;

  if ((wParam >= 5000) && (wParam < 6000)) return menu.handleCommand(wParam);
  else return CMDIFrameWndEx::OnCommand(wParam,lParam);
}

int CRobotControlMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
  if (CMDIFrameWndEx::OnCreate(lpCreateStruct) == -1)
    return -1;
  
  // load the drawings to be shown from the registry
  debugDrawingManager.loadProperties();
  
  m_wndReBar.ShowWindow(SW_HIDE);
  
  return 0;
}

bool CRobotControlMainFrame::handleMessageInDialog(UINT dialogID,InMessage& message)
{
  return dialogBarMap[dialogID]->handleMessage(message);
}

void CRobotControlMainFrame::OnDropDown(NMHDR* pNotifyStruct,LRESULT* pResult)
{
  int i;

  for (i=0;i<toolBarArray.GetSize();i++)
    if (toolBarArray[i]->handleDropDown(pNotifyStruct)) return;

  *pResult = TBDDRET_DEFAULT;
}

void CRobotControlMainFrame::OnClose()
{
  getPhysicalRobots().disconnect();
  Sleep(1200);
  debugDrawingManager.saveProperties();
  
  CMDIFrameWndEx::OnClose();
}

void CRobotControlMainFrame::OnViewToolBar(UINT nID)
{
  POSITION pos = m_listControlBars.GetHeadPosition();
  while (pos != NULL)
  {
    CControlBar* pBar = (CControlBar*)m_listControlBars.GetNext(pos);
    
    if (pBar->GetDlgCtrlID() == nID)
    {
      ShowControlBar( pBar, !pBar->IsVisible(), FALSE );
    }
  }
  
}

void CRobotControlMainFrame::OnUpdateViewBar(CCmdUI* pCmdUI)
{
  POSITION pos = m_listControlBars.GetHeadPosition();
  while (pos != NULL)
  {
    CControlBar* pBar = (CControlBar*)m_listControlBars.GetNext(pos);
    
    if (pBar->GetDlgCtrlID() == (int)pCmdUI->m_nID)
    {
      pCmdUI->Enable();
      pCmdUI->SetCheck( pBar->IsVisible() ? 1 : 0 );
    }
  }
}


void CRobotControlMainFrame::OnDestroy()
{
  CMDIFrameWndEx::OnDestroy();
}

void CRobotControlMainFrame::OnAppAbout()
{
  CAboutDlg dlg;
  dlg.DoModal();
}

void CRobotControlMainFrame::OnConfigurationLoad(CString sectionName)
{
  int i;
  for (i=0; i<dialogBarArray.GetSize(); i++)
  {
    dialogBarArray[i]->OnConfigurationLoad(sectionName);
  }
}

void CRobotControlMainFrame::OnConfigurationSave(CString sectionName)
{
  int i;
  for (i=0; i<dialogBarArray.GetSize(); i++)
  {
    dialogBarArray[i]->OnConfigurationSave(sectionName);
  }
}

void CRobotControlMainFrame::OnIdle()
{
  int i;
  for (i=0; i<dialogBarArray.GetSize(); i++)
    dialogBarArray[i]->OnIdle();

  for (i=0; i<toolBarArray.GetSize(); i++)
    toolBarArray[i]->OnIdle();
} 

/*
* Change log :
*
* $Log: RobotControlMainFrame.cpp,v $
* Revision 1.9  2004/06/17 09:18:49  dueffert
* update bug fixed
*
* Revision 1.8  2004/06/16 21:05:49  dueffert
* new queue fill request button
*
* Revision 1.7  2004/05/25 14:40:04  loetzsch
* beautified
*
* Revision 1.6  2004/05/24 13:45:10  tim
* added potential field viewer again
*
* Revision 1.5  2004/05/24 13:19:53  spranger
* added xabsl2profilerdlg and ressources
*
* Revision 1.4  2004/05/22 22:52:05  juengel
* Renamed ballP_osition to ballModel.
*
* Revision 1.3  2004/05/22 19:40:00  loetzsch
* removed grid image processor2 dlg bar
*
* Revision 1.2  2004/05/22 19:21:39  loetzsch
* RobotControl cleanup
*
* Revision 1.1.1.1  2004/05/22 17:26:31  cvsadm
* created new repository GT2004_WM
*
* Revision 1.62  2004/05/03 15:16:06  roefer
* Includes corrected/removed
*
* Revision 1.61  2004/05/03 14:55:26  spranger
* added xabsl2profilerdlg
*
* Revision 1.60  2004/03/26 16:33:58  thomas
* added field in logplayer to jump directly to a given frame-number
*
* Revision 1.59  2004/03/25 17:37:05  loetzsch
* adopted game toolbar to new game controller
*
* Revision 1.58  2004/03/24 12:55:43  risler
* added logplayer repeat button
*
* Revision 1.57  2004/03/22 10:19:31  tim
* added potential field viewer
*
* Revision 1.56  2004/03/17 16:18:50  thomas
* added preversion of motion optimisation with behaviour, selflocator, headcontrol and robotcontrol dialog
*
* Revision 1.55  2004/03/16 14:00:22  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.2  2004/03/07 23:39:25  juengel
* Added the KickEditorDlgBar.
*
* Revision 1.54  2004/03/11 14:27:31  uhrig
* KalmanBallLocator was added
*
* Revision 1.53  2004/02/27 16:40:55  dueffert
* UDEvolutionRequest introduced
*
* Revision 1.52  2004/02/26 16:32:01  loetzsch
* removed configuration toolbar
*
* Revision 1.51  2004/02/26 11:28:53  jhoffman
* configuration toolbar readded
*
* Revision 1.50  2004/02/26 10:28:18  jhoffman
* configuration toolbar removed
*
* Revision 1.49  2004/02/23 21:35:23  jhoffman
* - message handling bug removed
* - added camera toolbar functionality to menu
*
* Revision 1.48  2004/02/23 13:27:25  jhoffman
* - changes to Main-menu are shown ... this currently results in one additional menu (!) somebody please fix this!
* - added GenericModalBinary-dialog: can be used to create a modal dialog where you can specify the button labels and the descriptive text (like APX...ModalDialog but you can specify what is written on the buttons)
* - CameraToolBar: mode, shutter, gain extracted from dropdown
* - ToolBarEx: added AddString method to write const. strings on a toolbar
*
* Revision 1.47  2004/02/18 10:09:15  jhoffman
* removed combo-select bug
*
* Revision 1.46  2004/02/16 12:26:40  nistico
* Added noise reduction functionality for jpeg images in log file player
*
* Revision 1.45  2004/02/13 13:29:04  loetzsch
* added class CRobotControlMenu
*
* Revision 1.44  2004/01/29 12:03:24  jhoffman
* UI changes:
* - Main menu entries renamed, reordered, added some new icons
* - delete-confirmation in settings and WLAN dialog
* - settings dialog uses icons, radio buttons added
* - WLAN dialog restructured
* - motion tester and head motion tested layout improved, stop button added
* - check boxes replaced by radio buttons where appropriate
*
* Revision 1.43  2004/01/17 20:56:22  loetzsch
* changed the CREATE_TOOLBAR macro
*
* Revision 1.42  2004/01/04 01:00:47  kerdels
* TacticDesigner hinzugefgt
*
* Revision 1.41  2003/12/28 19:03:29  kerdels
* option rating dialog added
*
* Revision 1.40  2003/12/19 17:36:31  loetzsch
* beautified the mof tester
*
* Revision 1.39  2003/12/19 11:09:28  hamerla
* Logplayer extension  Seek
*
* Revision 1.38  2003/12/17 13:52:36  loetzsch
* undo of last two changes
*
* Revision 1.37  2003/12/16 21:46:13  loetzsch
* possibly fixed a problem on Marten Richerts computer.
*
* Revision 1.36  2003/12/16 19:49:20  loetzsch
* possibly fixed a problem
*
* Revision 1.35  2003/12/16 19:02:46  loetzsch
* The motion net file Config/spec_act.dat can be sent through WLAN to a robot.
*
* Revision 1.34  2003/12/15 13:05:04  loetzsch
* RobotControl now displays a splash screen at the beginning
*
* Revision 1.33  2003/12/14 22:45:18  loetzsch
* renamed CRobotControlMainFrame::createDialogs to
* createDialogBarsAndToolBars.
*
* Revision 1.32  2003/12/12 20:54:40  loetzsch
* The simulator window is now also opened through the main menu instead
* of a button in the simulated robots toolbar.
*
* Revision 1.31  2003/12/12 17:12:22  loetzsch
* With the button "Disable simulated robots" all simulated robots can be
* disabled. But this does not deactivate any simulated robots.
*
* If the simulated robots are disabled, messages from physical robots or a
* log file are directly sent to the queue "toGUI". (One does not need to
* deactivate all simulated robots anymore if one wants to view images from a log file
* without sending them to the selected simulated robot.)
*
* Revision 1.30  2003/12/11 17:33:16  hamerla
* *** empty log message ***
*
* Revision 1.29  2003/12/09 20:14:18  hamerla
* *** empty log message ***
*
* Revision 1.28  2003/12/09 18:16:36  loetzsch
* added dialog bar "multiple fields",
* removed unused resources
*
* Revision 1.27  2003/12/06 16:44:45  loetzsch
* improved message handling
*
* Revision 1.26  2003/12/06 14:26:52  hamerla
* *** empty log message ***
*
* Revision 1.25  2003/12/06 06:31:19  loetzsch
* no message
*
* Revision 1.24  2003/12/05 12:22:28  dueffert
* merge bug fixed
*
* Revision 1.23  2003/12/05 12:01:04  dueffert
* UDParameterSetDlg added again, beautified, AlLx icon added
*
* Revision 1.22  2003/12/05 11:11:34  hamerla
* no message
*
* Revision 1.21  2003/12/04 10:30:18  hamerla
* no message
*
* Revision 1.19  2003/12/02 11:25:39  hamerla
* Memory leaks WorldstatePlayer
*
* Revision 1.18  2003/12/02 10:41:42  lohmann
* WorldstatePlayer Dialog changes
*
* Revision 1.17  2003/11/30 01:53:19  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.16  2003/11/26 11:26:14  neubach
* WorldStatePlayer changed
*
* Revision 1.15  2003/11/18 13:24:42  goehring
* Different BallDistance measures notified
*
* Revision 1.14  2003/11/18 10:21:01  lohmann
* Worldstate_Analysis_Dlg_Bar added!
*
* Revision 1.13  2003/11/17 14:56:04  urban
* added SensorBehaviorControl-solution "AlLx RemotePresence" and RobotControl-dialogbar "AlLx Joystick"
*
* Revision 1.12  2003/11/17 12:31:41  goehring
* changed ballPercept.angle notification to degrees
*
* Revision 1.11  2003/11/16 14:47:25  goehring
* new ballPercept structure adapted
*
* Revision 1.10  2003/11/15 17:12:55  juengel
* changed BallPercept
*
* Revision 1.9  2003/11/14 19:02:26  goehring
* frameNumber added
*
* Revision 1.8  2003/11/13 17:39:03  goehring
* frameNumber added
*
* Revision 1.7  2003/11/10 13:31:23  dueffert
* special percept visualization added
*
* Revision 1.6  2003/11/06 16:42:26  goehring
* Frames instead of time added
*
* Revision 1.5  2003/11/05 13:41:25  goehring
* JointStates removed
*
* Revision 1.4  2003/11/03 20:24:26  juengel
* color class images can be sent from robot now
*
* Revision 1.3  2003/10/23 07:32:24  juengel
* Renamed ColorTableAuto to ColorTableReferenceColor.
*
* Revision 1.2  2003/10/21 14:40:17  goehring
* BallPerceptX and Y coord notified
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.12  2003/09/26 21:23:20  loetzsch
* renamed class JointState to CollisionPercept
*
* Revision 1.11  2003/09/26 15:28:24  juengel
* Renamed DataTypes to representations.
*
* Revision 1.10  2003/09/26 11:40:12  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.9  2003/09/11 15:55:56  juengel
* RadarViewer3DDialog gets jointData and SensorData.
*
* Revision 1.8  2003/09/11 15:20:59  dueffert
* passing of InvKinParameters added
*
* Revision 1.7  2003/09/05 17:37:01  loetzsch
* bug fix
*
* Revision 1.6  2003/09/01 10:23:14  juengel
* DebugDrawings clean-up 2
* DebugImages clean-up
* MessageIDs clean-up
* Stopwatch clean-up
*
* Revision 1.5  2003/08/30 10:16:42  juengel
* DebugDrawings clean-up 1
*
* Revision 1.4  2003/08/25 17:24:27  juengel
* Added HistogramDialogBar
*
* Revision 1.3  2003/08/22 17:03:29  roefer
* General JPEGImage to Image conversion added
*
* Revision 1.2  2003/08/18 11:49:35  juengel
* ColorSpaceDlgBar handles idColorTableReferenceColor messsages.
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.84  2003/06/26 12:36:00  juengel
* Visualization of ObstaclesModel.
*
* Revision 1.83  2003/06/13 14:52:55  juengel
* Added paintJointStateForFieldView.
*
* Revision 1.82  2003/06/04 14:42:39  goehring
* Debug
*
* Revision 1.81  2003/06/03 09:26:41  goehring
* Review for CollisionDetectorValues
*
* Revision 1.80  2003/06/02 09:39:34  goehring
* Added JointState to SEND_PERCEPTS and RECEIVE_PERCEPTS.
*
* Revision 1.79  2003/05/26 08:13:40  juengel
* Added cameraMatrix to worldState.
*
* Revision 1.78  2003/05/16 14:07:48  risler
* added radar view obstacles drawing
*
* Revision 1.77  2003/05/14 19:54:42  risler
* PSDPercept contains all points from one frame
*
* Revision 1.76  2003/05/11 23:51:02  dueffert
* Depend now works with RobotControl too
*
* Revision 1.75  2003/05/05 12:18:46  juengel
* Changes in GIP2Parameters.
*
* Revision 1.74  2003/05/01 17:09:09  loetzsch
* Redesign of ball modeling:
* - Modularized class BallP_osition
* - splitted up module "BallLocator" into "BallLocator" for modeling of percepts
*   and "TeamBallLocator" for modelling communicated positions
* - Removed solution JumpingBallLocator
* - Splitted Solution DefaultBallLocator into DefaultBallLocator and DefaultTeamBallLocator
* - Renamed SensorFusionBallLocator to GaussBellTeamBallLocator
*
* Revision 1.73  2003/04/23 16:15:21  juengel
* specialPercept is sent to RadarViewer3D.
*
* Revision 1.72  2003/04/17 17:00:08  loetzsch
* bug fix
*
* Revision 1.71  2003/04/16 14:14:38  loetzsch
* removed Xabsl 1 from GT2003
*
* Revision 1.70  2003/04/14 16:16:42  loetzsch
* ATH after GermanOpen CVS merge
* workaround for empty queueToPhysicalRobot when saving that to the stick
*
* Revision 1.2  2003/04/10 12:04:55  juengel
* Work around for save queue.
*
* Revision 1.1.1.1  2003/04/09 14:22:41  loetzsch
* started Aibo Team Humboldt's GermanOpen CVS
*
* Revision 1.69  2003/04/06 20:34:22  juengel
* CameraMatrix.isValid is displayed in ValueHistoryDlgBar.
*
* Revision 1.68  2003/04/06 16:40:03  juengel
* Added PSDPercept.tooFarAway to ValueHistoryDlgBar.
*
* Revision 1.67  2003/04/05 16:47:54  juengel
* Added specialPercept to DrawingMethods.
*
* Revision 1.66  2003/04/01 14:01:09  juengel
* Added visualization for color tables.
*
* Revision 1.65  2003/03/30 15:30:31  tim
* Changed potentialfield viewer
*
* Revision 1.64  2003/03/29 21:11:10  juengel
* Added paintObstaclesAndPSDPerceptForImageView.
*
* Revision 1.63  2003/03/28 14:28:57  juengel
* Added PSDPercept to SEND_PERCEPTS and RECEIVE_PERCEPTS.
*
* Revision 1.62  2003/03/28 14:04:19  dueffert
* team wlan support improved
*
* Revision 1.61  2003/03/26 11:23:22  tim
* Added potentialfield viewer
*
* Revision 1.60  2003/03/25 11:46:53  dueffert
* team wlan support improved
*
* Revision 1.59  2003/03/25 08:47:11  dasmuli
* Added simple segmentation and the 180/360 memory. Dialog was changed in order to display segemented data.
*
* Revision 1.58  2003/03/23 19:14:21  loetzsch
* finished GUI for 8 simulated robots
* - added the passive state
* - added the state[8] variable to CRobotControlSimulatedRobots
* - Repaint of object viewer after reset
* - Resend debug key table after reset
* - don't stop simulation when selected robot changes
*
* Revision 1.57  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.56  2003/03/22 16:39:33  loetzsch
* continued GUI for simulated robots
*
* Revision 1.55  2003/03/20 23:42:17  loetzsch
* changed cast of AfxGetApp() to CRobotControlApp*
* to getRobotControlApp()
*
* Revision 1.54  2003/03/20 20:36:22  loetzsch
* renamed SimulatorToolbar to Simulated Robots toolbar
* added class CRobotControlSimulatedRobots
* started implementing the GUI for 8 simulated robots
*
* Revision 1.53  2003/03/19 09:11:04  dueffert
* team wlan support improved
*
* Revision 1.52  2003/03/13 16:39:47  dueffert
* wlan toolbar can handle teams now
*
* Revision 1.51  2003/03/11 12:06:46  dueffert
* QueueFillMode rejectAll added
*
* Revision 1.50  2003/03/11 11:25:26  juengel
* Added obstaclesPercept to drawingMethods.
*
* Revision 1.49  2003/03/10 14:00:52  juengel
* Added ObstaclesLocator
*
* Revision 1.48  2003/03/07 19:04:33  juengel
* Added messageID executedMotionRequest
*
* Revision 1.47  2003/03/06 18:19:34  dueffert
* reduced amount of warnings drastically by ifdefing global functions
*
* Revision 1.46  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.45  2003/03/05 11:08:35  loetzsch
* added class GlobalGameControlData
* the Game Toolbar now sents GlobalGameControlData
* removed Playerstoolbar
*
* Revision 1.44  2003/03/04 14:51:02  juengel
* Added GridImageProcessor2DlgBar
*
* Revision 1.43  2003/03/03 23:08:01  loetzsch
* first working version of the value history dialog bar
*
* Revision 1.42  2003/02/27 15:30:47  loetzsch
* added the value history dialog
*
* Revision 1.41  2003/02/27 12:57:26  juengel
* Added handleMessage for idGridImageProcessor2ColorCubes.
*
* Revision 1.40  2003/02/11 21:14:16  ding
* Comments for ObjectRecognitionDlgBar removed
*
* Revision 1.39  2003/02/11 18:20:16  osterhues
* Temporarily disabled ObjectRecognitionDlgBar support
*
* Revision 1.38  2003/02/11 10:14:04  dasmuli
* Introduction of the object recognition user interface.
*
* Revision 1.37  2003/02/10 23:33:02  cesarz
* some small bugfixes and changes.
*
* Revision 1.36  2003/01/31 13:40:37  osterhues
* Added TSL color table tool
*
* Revision 1.35  2003/01/30 22:30:53  juengel
* UpdateCmdUI for TestDataGeneratorDlg
*
* Revision 1.34  2003/01/28 17:18:40  loetzsch
* encapsulated the WLan thread into an own class
*
* Revision 1.33  2003/01/23 14:24:21  cesarz
* added logfile support and some improvements.
*
* Revision 1.32  2003/01/19 13:04:11  loetzsch
* the settings of the simulator field view are now also stored in the registry for
* each configuration
*
* Revision 1.31  2003/01/15 12:22:27  dueffert
* disconnect on close
*
* Revision 1.30  2003/01/10 15:51:32  juengel
* Added OptionsCombo to Xabsl2DialogBar
*
* Revision 1.29  2003/01/09 13:39:20  jhoffman
* added 3dfieldview
*
* Revision 1.28  2002/12/17 16:44:48  dueffert
* local JPEGImages are not useful. Remote ones work without this removed hack.
*
* Revision 1.27  2002/12/17 15:15:05  juengel
* #define HAVE_BOOLEAN eingefgt
*
* Revision 1.26  2002/12/17 13:36:34  dueffert
* JPEGImage support added
*
* Revision 1.25  2002/12/14 17:56:08  roefer
* Names of drawing functions changed
*
* Revision 1.24  2002/12/08 16:14:32  juengel
* Added variable "messageID" in CMessageHandlerForQueueToGUI::handleMessage(InMessage& message).
*
* Revision 1.23  2002/12/06 11:30:13  juengel
* Added Xabsl2Dlg.
*
* Revision 1.22  2002/12/03 15:03:04  cesarz
* InvKinParametersDlgBar added.
*
* Revision 1.21  2002/11/26 19:19:23  loetzsch
* JPEG images are put into local processes
*
* Revision 1.20  2002/11/22 14:38:02  juengel
* no message
*
* Revision 1.19  2002/11/19 12:57:54  dueffert
* queuefillrequest added, debugkey toolbar extended, memorystick toolbar removed
*
* Revision 1.18  2002/11/18 17:30:31  loetzsch
* Sound requests generated from BehaviorControl are now automatically sent
* to RobotControl and played there.
*
* Revision 1.17  2002/11/18 17:21:17  dueffert
* RobotControl should be startable in any path now
*
* Revision 1.16  2002/11/12 16:08:10  loetzsch
* Added (char) and (int) casts to DebugDrawing Macros
*
* Revision 1.15  2002/11/12 10:49:01  juengel
* New debug drawing macros - second step
* -moved /Tools/Debugging/PaintMethods.h and . cpp
*  to /Visualization/DrawingMethods.h and .cpp
* -moved DebugDrawing.h and .cpp from /Tools/Debugging/
*  to /Visualization
*
* Revision 1.14  2002/11/11 11:27:10  juengel
* First Step: New debug drawing macros.
*
* Revision 1.13  2002/10/13 15:51:04  juengel
* second debug drawing clean up
*
* Revision 1.12  2002/10/11 13:54:43  roefer
* JPEGImage added
*
* Revision 1.11  2002/10/11 13:46:35  juengel
* Percepts are sent to the RadarViewer3DDlg.
*
* Revision 1.10  2002/10/10 13:09:49  loetzsch
* First experiments with the PSD Sensor
* - SensorDataProcessor now calculates PSDPercept
* - Added the PerceptBehaviorControl solution PSDTest
* - Added the RadarViewer3D to RobotControl, which can display the Points3D structure
*
* Revision 1.9  2002/10/04 10:22:41  loetzsch
* Invalidate and RedrawWindow are only called in the handleMessage
* function when the dialog is visible
*
* Revision 1.8  2002/10/02 15:52:53  juengel
* The status bar shows the type of the current message in the LogPlayer tool bar.
*
* Revision 1.7  2002/09/20 23:28:33  juengel
* Moved instance of DebugDrawingManager to RobotControlMainFrame.
*
* Revision 1.6  2002/09/19 23:38:54  juengel
* Changed debug image mechanisms.
*
* Revision 1.5  2002/09/19 12:46:24  loetzsch
* removed Viewers toolbar
*
* Revision 1.4  2002/09/18 16:35:12  loetzsch
* made GT2003 compilable,
* rechanged message ids
*
* Revision 1.3  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.2  2002/09/11 20:02:54  loetzsch
* removed AutoColor Dialog related files
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.21  2002/09/01 19:04:24  loetzsch
* removed a few dialogs
*
* Revision 1.20  2002/09/01 18:48:38  loetzsch
* removed a few dialogs
*
* Revision 1.19  2002/09/01 17:20:34  loetzsch
* tidied up the MfcTools/ directory. Created directories
* MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
*
* Revision 1.18  2002/08/30 17:33:03  dueffert
* include bug fixed
*
* Revision 1.17  2002/08/30 17:27:48  dueffert
* include bug fixed
*
* Revision 1.16  2002/08/30 14:06:43  juengel
* Renamed BlobViewer to LargeImageViewer
*
* Revision 1.15  2002/08/29 14:00:46  dueffert
* includes in correct case, system includes in <>
*
* Revision 1.14  2002/08/21 11:50:44  cesarz
* GT2001PlayersPerceptor, BerlinSelfLocator, GT2001WalkingEngine,
* DoWalkingEngine, FuzzyBehaviorControl, BremenGOBehaviorControl,
* FuzzyBehaviortesterdlgbar and Behaviortesterdlgbar removed.
*
* Revision 1.13  2002/08/13 12:57:41  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
* - Renamed CLayoutToolBar to CConfigurationToolBar
* - Added CRobotControlConfigurationManager
* - Removed CToolsToolBar
*
* Revision 1.12  2002/08/08 16:40:30  loetzsch
* added class LogPlayer and redesigned RobotControl's Logplayer GUI
*
* Revision 1.11  2002/08/07 10:50:21  loetzsch
* - removed direct access to the dialogs
* - faster starting of RobotControl application and main window
* - general clean up
*
* Revision 1.10  2002/07/23 20:44:43  roefer
* MessageQueue -> HSITool crash removed
*
* Revision 1.9  2002/07/23 13:44:48  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - new debug message handling
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.8  2002/06/21 02:30:32  dueffert
* result of copyfiles is shown now
*
* Revision 1.7  2002/06/20 23:38:48  dueffert
* player toolbar & wlan toolbar completed
*
* Revision 1.6  2002/06/04 23:27:02  loetzsch
* 4-robots-in-RobotControl related bug fixes and improvements
*
* Revision 1.5  2002/06/04 14:47:39  loetzsch
* several bug fixes
*
* Revision 1.4  2002/06/04 00:15:36  loetzsch
* RobotControl now can simulate four robots.
*
* Revision 1.3  2002/05/16 22:36:12  roefer
* Team communication and GTMath bugs fixed
*
* Revision 1.2  2002/05/10 14:46:51  juengel
* Removed calls of AutoColorDlg
*
* Revision 1.1.1.1  2002/05/10 12:40:19  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.86  2002/05/05 22:12:42  loetzsch
* GameControlData can now be sent from the Game toolbar to BehaviorControl
*
* Revision 1.85  2002/05/05 18:53:01  loetzsch
* removed Modules toolbar
* added Game toolbar
*
* Revision 1.84  2002/04/30 09:04:38  khuebner
* AutoColor Dialog included
*
* Revision 1.83  2002/04/25 12:23:07  jhoffman
* nothing much...
*
* Revision 1.82  2002/04/24 14:49:50  dueffert
* WLANToolbar saves actual setting in registry
*
* Revision 1.81  2002/04/23 17:45:17  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.80  2002/04/20 15:52:21  roefer
* Project simpified, WATCH and WATCH_PART added
*
* Revision 1.79  2002/04/17 09:52:03  dueffert
* PlayersToolbar enhancements
*
* Revision 1.78  2002/04/16 16:09:31  dueffert
* PlayersToolbar & WlanNewDialog synchronized
*
* Revision 1.77  2002/04/08 13:34:14  dueffert
* PlayersToolBar added
*
* Revision 1.76  2002/04/04 15:24:16  fischer
* Added Fuzzy Behavior Tester Dialog (without functionality).
*
* Revision 1.75  2002/04/04 11:04:00  risler
* added DebugMessageGenerator
*
* Revision 1.74  2002/04/02 15:05:38  loetzsch
* XabslDlgBar can now test skills
*
* Revision 1.73  2002/03/29 10:35:54  loetzsch
* changed checking of the crash button in the simulator toolbar wieder rckgngig
*
* Revision 1.72  2002/03/29 10:14:56  loetzsch
* changed checking of the crash button in the simulator toolbar
*
* Revision 1.71  2002/03/29 09:32:42  roefer
* Buttons for switches and crash in simulator toolbar are now working
*
* Revision 1.70  2002/03/28 17:43:13  loetzsch
* continued XABSL Behavior Tester
*
* Revision 1.69  2002/03/26 19:03:42  loetzsch
* added xabsl toolbar
*
* Revision 1.67  2002/03/25 09:29:03  rentmeister
* Behavior Dialog
*
* Revision 1.66  2002/03/14 12:52:33  dueffert
* pictures added
*
* Revision 1.65  2002/03/12 14:07:58  jhoffman
* added open gl viewer dialog
*
* Revision 1.64  2002/03/04 11:54:13  dueffert
* JoystickMotionTester added
*
* Revision 1.63  2002/02/28 11:54:58  jhoffman
* added ScoreBoard Dialog Bar
*
* Revision 1.62  2002/02/25 09:58:49  rentmeister
* Evolver verndert
*
* Revision 1.61  2002/02/24 10:02:21  juengel
* TimeDiagramDlgBar completed.
*
* Revision 1.60  2002/02/23 18:35:18  loetzsch
* added "clear debug queue to robot" to the "Extras" menu
*
* Revision 1.59  2002/02/20 16:08:12  dueffert
* direct wlan connection added, not fully functional yet
*
* Revision 1.58  2002/02/18 18:51:31  loetzsch
* added a menu item for the settings dialog
*
* Revision 1.57  2002/02/18 14:08:00  juengel
* SettingsDlgBar added.
*
* Revision 1.56  2002/02/16 20:11:56  dueffert
* direct wlan communication (without Router) added, integration not yet completed
*
* Revision 1.55  2002/02/12 16:34:49  risler
* finished MofTester
*
* Revision 1.54  2002/02/12 01:02:23  risler
* added MofTester
*
* Revision 1.53  2002/02/09 15:13:37  juengel
* ColorSpaceDlgBar added.
*
* Revision 1.52  2002/02/08 13:28:08  loetzsch
* Visualization of PerceptCollection and RadarViewer started
* (not implemented yet)
*
* Revision 1.51  2002/02/07 23:25:59  loetzsch
* Changed registry access
*
* Revision 1.50  2002/02/07 16:28:11  loetzsch
* improved toolbars
*
* Revision 1.49  2002/02/05 21:09:18  loetzsch
* RobotControl StatusBar now displayes simulation step,
* team color, player role and log player play time
*
* Revision 1.48  2002/02/05 03:54:44  loetzsch
* added the "send oracled world states to local processes" menu item
*
* Revision 1.47  2002/02/04 11:39:47  juengel
* ImageProcessorTester dialog added.
*
* Revision 1.46  2002/01/30 17:33:22  loetzsch
* Joint Viewer vorerst fertig
*
* Revision 1.45  2002/01/27 21:15:06  loetzsch
* JointViewer now displays SensorData
*
* Revision 1.44  2002/01/25 16:54:56  loetzsch
* Messages from OVirtualRobotComm are sent now in a synchronized way
*
* Revision 1.43  2002/01/25 14:52:42  risler
* wlan disconnect on error
*
* Revision 1.42  2002/01/24 22:57:22  risler
* finished WLAN Toolbar
*
* Revision 1.41  2002/01/24 18:19:18  loetzsch
* JointViewer added
*
* Revision 1.40  2002/01/24 11:44:35  risler
* added WLAN Toolbar
*
* Revision 1.39  2002/01/23 15:54:34  udo
* Das Dortmunder Motion-Evolve-Tool
*
* Revision 1.38  2002/01/22 14:48:53  juengel
* TestDataGenerator eingefhrt
*
* Revision 1.37  2002/01/19 21:36:24  risler
* added HeadMotionTester, HeadControlSelector
*
* Revision 1.36  2002/01/18 23:30:07  loetzsch
* Distribution of HeadControlModes, HeadMotionRequests and SolutionRequests added
*
* Revision 1.35  2002/01/18 02:17:39  loetzsch
* MotionTester dialog and distribution of MotionRequests
* to the processes programmed.
*
* Revision 1.34  2002/01/17 14:35:48  risler
* SolutionRequest added
*
* Revision 1.33  2002/01/16 14:06:03  loetzsch
* OnIdle() Bug fixed
*
* Revision 1.32  2002/01/16 01:45:21  loetzsch
* SimRobot / RobotControl integration continued
*
* Revision 1.31  2002/01/15 23:54:15  loetzsch
* SolutionRequest introduced
*
* Revision 1.30  2002/01/14 22:43:01  loetzsch
* SimRobot / RobotControl integration started
*
* Revision 1.29  2002/01/13 14:12:02  kspiess
* HSIColorTableTool-Dialog in RobotControl eingebaut; Implementierung der Funktionalitaet kommt bald
*
* Revision 1.28  2002/01/04 14:33:41  juengel
* no message
*
* Revision 1.27  2001/12/20 19:23:19  juengel
* Neue Klasse CRobotControlDlg gebaut.
*
* Revision 1.26  2001/12/17 16:40:38  loetzsch
* Removed old "OnOpen...Dlg()" functions
*
* Revision 1.25  2001/12/16 17:18:55  loetzsch
* DebugKeyToolBar wieder groe Member Funktionsnamen eingebaut, Technote zu Toolbars
*
* Revision 1.24  2001/12/15 19:26:13  juengel
* ColorTable, ColorTable64, ColorTable64DlgBar hinzugefgt.
*
* Revision 1.23  2001/12/14 17:05:15  loetzsch
* CameraParameters Toolbar fertig
*
* Revision 1.22  2001/12/14 12:26:11  loetzsch
* CameraParameters Toolbar weitergemacht
*
* Revision 1.21  2001/12/13 17:20:39  loetzsch
* CameraParameters Toolbar weitergemacht
*
* Revision 1.20  2001/12/13 15:28:45  bach
* Toolbar for Camera Parameters added (very premature looking)
*
* Revision 1.19  2001/12/13 15:03:02  loetzsch
* DebugKeyToolBar fertig
*
* Revision 1.18  2001/12/13 12:58:16  loetzsch
* MemoryStick ToolBar hinzugefgt und an anderen Toolbars herumgebastelt
*
* Revision 1.17  2001/12/12 15:21:08  juengel
* CDebugKeyToolBar in eigenes .cpp und .h File verlagert.
*
* Revision 1.16  2001/12/11 15:14:23  juengel
* CLogPlayerToolBar in eigenes .cpp und .h File verlagert. Abspielfunktionalitt des LogPlayers implementiert.
*
* Revision 1.15  2001/12/10 17:47:09  risler
* change log added
*
*/

