/**
* @file RobotControlDebugKeyTables.h
*
* Declaration of class CRobotControlDebugKeyTables and access functions.
*
* @author Martin Ltzsch
*/

#ifndef __RobotControlDebugKeyTables_h_
#define __RobotControlDebugKeyTables_h_

#include "Tools/Debugging/DebugKeyTable.h"

/**
* @class CRobotControlDebugKeyTables
*
* The debug key tables of the RobotControl application to be used in the GUI.
*
* @author Martin Ltzsch
*/
class CRobotControlDebugKeyTables
{
public:
  /** A debug key table for the physical robots */
  DebugKeyTable forPhysicalRobots;
  
  /** A debug key table for the simulated robots */
  DebugKeyTable forSimulatedRobots;
  
  /** sends the debug key table forPhysicalRobots to the physical robots */
  void sendForPhysicalRobots();

  /** sends the debug key table forSimulatedRobots to the simulated robots */
  void sendForSimulatedRobots();
};

/**
* Returns a reference to the RobotControl debug key tables interface.
* Use that function only inside the thread of the RobotControl GUI !!!
*/
CRobotControlDebugKeyTables& getDebugKeyTables();


#endif //__RobotControlDebugKeyTables_h_

/*
* Change Log:
*
* $Log: RobotControlDebugKeyTables.h,v $
* Revision 1.1.1.1  2004/05/22 17:26:29  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.1  2002/07/23 13:45:14  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - new debug message handling
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
*/
