/**
* @file RobotControlDebugKeyTables.cpp
*
* Implementation of class CRobotControlDebugKeyTables and access functions.
*
* @author Martin Ltzsch
*/

#include "StdAfx.h"
#include "RobotControl.h"
#include "RobotControlDebugKeyTables.h"
#include "RobotControlQueues.h"

  
void CRobotControlDebugKeyTables::sendForPhysicalRobots()
{
  getQueues().toPhysical.allRobots.out.bin << forPhysicalRobots;
  getQueues().toPhysical.allRobots.out.finishMessage(idDebugKeyTable);
}


void CRobotControlDebugKeyTables::sendForSimulatedRobots()
{
  getQueues().toSimulated.allRobots.out.bin << forSimulatedRobots;
  getQueues().toSimulated.allRobots.out.finishMessage(idDebugKeyTable);
}

CRobotControlDebugKeyTables& getDebugKeyTables()
{
  return getRobotControlApp().debugKeyTables;
}

/*
* Change Log:
*
* $Log: RobotControlDebugKeyTables.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:26:29  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2003/12/09 19:49:24  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2003/05/11 23:51:02  dueffert
* Depend now works with RobotControl too
*
* Revision 1.3  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.2  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.3  2002/08/22 15:20:10  loetzsch
* debug messages to the local processes are now sent in a better synchronized way.
*
* Revision 1.2  2002/08/08 20:48:52  roefer
* One synchronization problem fixed (there are still many others)
*
* Revision 1.1  2002/07/23 13:45:14  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - new debug message handling
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
*/
