/**
* @file RobotControlDebugConnection 
*
* Definition of class CRobotControlDebugConnection
*
* @author Michael Wachter
*/

#ifndef __RobotControlDebugConnection_h_
#define __RobotControlDebugConnection_h_

#include "StdAfx.h"
#include "Tools/MessageQueue/MessageQueue.h"


/** 
* @class CRobotControlDebugConnection
*
* Handles a tcp connection to send and receive MessageQueues from and to a physical robot
*
* @author Michael Wachter
*/

class CRobotControlDebugConnection : public CAsyncSocket
{
  public:
	  CRobotControlDebugConnection(MessageQueue &queueFromRobot, MessageQueue &queueToRobot, MessageQueue &error);
	  ~CRobotControlDebugConnection();

      bool wLanIsConnected(); /**< Returns true if the connection is established */
	  void wLanConnect(const unsigned long remoteIP, int remotePort); /**< connects to the robot */
	  void wLanDisconnect(); /**< closes the connection */
	  void sendMessageQueue(); /**< sends all the Messages in the queueToRobot to the robot and clears the queue after that*/

	  /* Methods overrided from CAsyncSocket */
	  virtual void OnConnect(int nErrorCode);
	  virtual void OnReceive(int nErrorCode);
	  virtual void OnSend(int nErrorCode);
	  virtual void OnClose(int nErrorCode);

   private:

      void resetBuffers();
	  MessageQueue &error;  /**< MessageQueue where error-messages are send to */
	  MessageQueue &queueToRobot; /**< MessageQueue for messages to the robot */
	  MessageQueue &queueFromRobot; /**< MessageQueue where messages from the robot arrive */
      bool connected;

	  /* Buffers for sending and receiving */
	  int sendBufferSize; 
	  int sendPosition;
	  char* sendBuffer;
	  int receiveBufferSize;
	  int receivePosition;
	  int receiveBufferForSize;
	  char* receiveBuffer;
	  bool receivingData;
	  bool socketCreated;
	  
	  char ipAddr[32];
	  


};

#endif //__RobotControlDebugConnection_h_

/*
* Change Log:
*
* $Log: RobotControlDebugConnection.h,v $
* Revision 1.1  2004/06/08 11:55:07  wachter
* Robot control now uses asyncrhonous communication with CAsyncSocket instead of wlan-threds now.
*
*
*/
