/**
* @file RobotControlConfigurationManager.h
*
* Definition of class CRobotControlConfigurationManager
*
* @author Martin Ltzsch
*/

#ifndef __RobotControlConfigurationManager_h_
#define __RobotControlConfigurationManager_h_

#include "StdAfx.h"

/**
* @class CRobotControlConfigurationManager
*
* Manages configurations for the RobotControl application. 
* A configuration contains window layout, dialog settings and other informations. 
* Configurations are stored in the registry.
*
* @author Martin Ltzsch
*/
class CRobotControlConfigurationManager
{
public:
  /** Loads the names of all available configurations from the registry.*/
  void init();

  /** Destructor. Saves available configuration names to the registry */
  ~CRobotControlConfigurationManager();

  /** the name of the current configuration */
  CString currentConfigurationName;

  /** the names of all configurations in the registry */
  CArray<CString,CString> configurations;

  /** Loads and applies the current configuration using currentConfigurationName */
  void loadConfiguration();
  
  /** Saves the current configuration using currentConfigurationName */
  void saveConfiguration();

  /** Saves the current configuration using currentConfigurationName */
  void deleteConfiguration();
};

/** Returns a reference to the instance of CRobotControlConfigurationManager in CRobotControlApp */
CRobotControlConfigurationManager& getConfigurationManager();

#endif //__RobotControlConfigurationManager_h_

/*
* Change Log:
*
* $Log: RobotControlConfigurationManager.h,v $
* Revision 1.1.1.1  2004/05/22 17:26:29  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/02/23 21:35:23  jhoffman
* - message handling bug removed
* - added camera toolbar functionality to menu
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2003/05/11 23:51:02  dueffert
* Depend now works with RobotControl too
*
* Revision 1.3  2002/11/28 14:07:37  dueffert
* docu improved
*
* Revision 1.2  2002/11/19 13:41:34  dueffert
* bugs in configuration toolbar identified or fixed
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.1  2002/08/13 12:58:08  loetzsch
* - Added CRobotControlConfigurationManager
*
*/
