/**
* @file RobotControl.cpp
*
* Implementation of class RobotControlApp
*
* @author Martin Ltzsch
*/

#include "StdAfx.h"
#include "resource.h"
#include "RobotControl.h"
#include "RobotControlFieldView.h"

#include "RobotControlQueues.h"
#include "RobotControlMessageHandler.h"
#include "Platform/Win32/ForRobotControl/OVirtualRobotComm.h"


/** the only instance of the application */
CRobotControlApp theApp;

CRobotControlApp& getRobotControlApp()
{ 
  return theApp; 
}

BEGIN_MESSAGE_MAP(CRobotControlApp, CWinAppEx)
//{{AFX_MSG_MAP(CRobotControlApp)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CRobotControlApp::CRobotControlApp()
{
}

BOOL CRobotControlApp::InitInstance()
{
  if (!AfxSocketInit()) {
    AfxMessageBox("failed to initialize Afx sockets");
    return FALSE; }
  AfxEnableControlContainer();
//  Enable3dControls();			
  
  //check for the correct version of ComCtl32.dll
  DWORD dwComCtlVer = GetComCtlVersion();
  if ( dwComCtlVer < MAKELONG( 81, 5) )
  {
    CString strMsg;
    strMsg.Format( _T("RobotControl requires ComCtl32.dll version 5.81 or higher!\nInstalled version: %d.%02d"),
      HIWORD( dwComCtlVer ), LOWORD( dwComCtlVer ) );
    AfxMessageBox( strMsg );
  }
  
  // the registry key, where Window positions, toolbar positions etc are stored.
  // the full key is HKEY_CURRENT_USER\Software\GermanTeam\RobotControl
  SetRegistryKey(_T("GermanTeam"));

  // create and show the splash screen
  CSplashScreenDlg splashScreen;
  splashScreen.Create(IDD_DIALOG_SPLASH_SCREEN);
  splashScreen.ShowWindow(SW_SHOWNOACTIVATE);
  splashScreen.SetActiveWindow();
  splashScreen.SetWindowText("Starting RobotControl ...");
  splashScreen.setMessage("Creating the main window");


  // read the selected configuration from the registry
  configurationManager.init();
  
  // create main MDI Frame window
  pMainFrame = new CRobotControlMainFrame();
  if (!pMainFrame->LoadFrame(IDR_ROBOTCONTROL,WS_OVERLAPPEDWINDOW)) return FALSE;
  m_pMainWnd = pMainFrame;
  
  // embed the child window
  pChildWnd = pMainFrame->CreateNewChild(
    RUNTIME_CLASS(CRobotControlFieldView), IDR_ROBOTCONTROL, NULL, NULL);
  pChildWnd->ShowWindow(SW_SHOWMAXIMIZED);
  
  // Create the simulated robots 
  splashScreen.setMessage("Creating the simulated robots ...");
  simulatedRobots.create();  
  
  pMainFrame->SetWindowText(CString("RobotControl ") + CString(LAYOUT));
  
  // at last, the dialog bars and tool bars are created.
  pMainFrame->createDialogBarsAndToolBars(splashScreen);
  
  // Ensures that the OnIdle() function is called often enough when there are no
  // user messages and the simulator is not running.
  SetTimer(NULL,0,500,NULL);
  
  // close the splash screen
  splashScreen.DestroyWindow();

  return TRUE;
}

CRobotControlApp::~CRobotControlApp()
{
}

BOOL CRobotControlApp::OnIdle(LONG lCount)
{
  simulatedRobots.onIdle();
  physicalRobots.onIdle();
  {
    SYNC; // now no other threads can access the handled queues
    
    // the logplayer can put new messages into the queueFromPhysicalRobot
    queues.logPlayer.onIdle(); 
    
    // idle processing in the GUI
    pMainFrame->OnIdle();
    
    // the messages from the physical robots are routed to the selected 
    // simulated robot or to the queue
    queues.fromPhysicalRobots.handleAllMessages(CMessageHandlerForQueueFromPhysicalRobots());
    queues.fromPhysicalRobots.clear();
    
    queues.fromSimulatedRobots.handleAllMessages(CMessageHandlerForQueueFromSimulatedRobots());
    queues.fromSimulatedRobots.clear();
    
    queues.toGUI.handleAllMessages(CMessageHandlerForQueueToGUI(*pMainFrame));
    queues.toGUI.clear();
  }
  
  return CWinAppEx::OnIdle(lCount);
}

/*
* Change log :
* 
* $Log: RobotControl.cpp,v $
* Revision 1.3  2004/06/15 12:41:21  loetzsch
* changed XABSL version from 2.1 to 2.2 on the occasion of a new XABSL release
*
* Revision 1.2  2004/05/22 22:52:05  juengel
* Renamed ballP_osition to ballModel.
*
* Revision 1.1.1.1  2004/05/22 17:26:11  cvsadm
* created new repository GT2004_WM
*
* Revision 1.8  2003/12/15 15:31:10  loetzsch
* set a title for the splash screen window
*
* Revision 1.7  2003/12/15 13:05:03  loetzsch
* RobotControl now displays a splash screen at the beginning
*
* Revision 1.6  2003/12/14 22:45:18  loetzsch
* renamed CRobotControlMainFrame::createDialogs to
* createDialogBarsAndToolBars.
*
* Revision 1.5  2003/12/09 19:49:24  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.4  2003/12/07 19:01:12  loetzsch
* changed comment
*
* Revision 1.3  2003/12/06 06:31:19  loetzsch
* no message
*
* Revision 1.2  2003/11/30 01:53:19  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.1  2003/10/07 10:09:36  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/26 11:40:12  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.2  2003/09/22 13:59:47  loetzsch
* changed licence and acknowledgments
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.26  2003/05/11 23:51:02  dueffert
* Depend now works with RobotControl too
*
* Revision 1.25  2003/04/15 15:52:09  risler
* DDD GO 2003 code integrated
*
* Revision 1.25  2003/04/04 08:55:04  max
* odometrydata sent to simulated robots
*
* Revision 1.24  2003/03/28 14:04:46  dueffert
* team wlan support improved
*
* Revision 1.23  2003/03/25 11:46:53  dueffert
* team wlan support improved
*
* Revision 1.22  2003/03/24 16:47:38  loetzsch
* changed WLan Buttons
*
* Revision 1.21  2003/03/24 14:06:17  loetzsch
* added class CRobotControlPhysicalRobot
* moved the logPlayer instance from CRobotControlApp to CRobotControlQueues
*
* Revision 1.20  2003/03/23 19:11:32  loetzsch
* OUTPUT not allowed in the RobotControl thread anymore.
* Use getQueues().toGUI.out instead.
*
* Revision 1.19  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.18  2003/03/22 16:39:34  loetzsch
* continued GUI for simulated robots
*
* Revision 1.17  2003/03/20 20:36:21  loetzsch
* renamed SimulatorToolbar to Simulated Robots toolbar
* added class CRobotControlSimulatedRobots
* started implementing the GUI for 8 simulated robots
*
* Revision 1.16  2003/03/19 15:26:36  dueffert
* wlan team support improved
*
* Revision 1.15  2003/03/19 09:12:40  dueffert
* circle support added
*
* Revision 1.14  2003/03/06 13:56:07  loetzsch
* fixed a bug in the WLan connection to the physical robot
*
* Revision 1.13  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.12  2003/01/30 13:16:49  loetzsch
* Redesign of class BallP_osition
*
* Revision 1.11  2003/01/28 17:18:40  loetzsch
* encapsulated the WLan thread into an own class
*
* Revision 1.10  2003/01/21 15:13:12  loetzsch
* added queueToWLan
*
* Revision 1.9  2003/01/15 12:21:33  dueffert
* emptying queue on disconnect
*
* Revision 1.8  2002/12/14 15:17:33  roefer
* Hopefully, stability has been improved
*
* Revision 1.7  2002/12/08 19:29:15  loetzsch
* as in SimGT2003, JPG-Images are unpacked in the cognition process,
* not here anymore.
*
* Revision 1.6  2002/11/26 19:19:23  loetzsch
* JPEG images are put into local processes
*
* Revision 1.5  2002/11/18 17:30:31  loetzsch
* Sound requests generated from BehaviorControl are now automatically sent
* to RobotControl and played there.
*
* Revision 1.4  2002/11/18 17:21:17  dueffert
* RobotControl should be startable in any path now
*
* Revision 1.3  2002/09/18 16:35:12  loetzsch
* made GT2003 compilable,
* rechanged message ids
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.20  2002/09/07 13:36:55  loetzsch
* unified the vision modules into one module "ImageProcessor"
* - FloodFillRLEImageProcessor, BallPerceptor, LandmarksPerceptor
*   and PlayersPerceptor were are combined to the new solution
*   "BlobImageProcessor"
* - The GridImageProcessor and the SubPixelGradientCalculator became
*   a solution of "ImageProcessor"
*
* Revision 1.19  2002/09/01 17:20:34  loetzsch
* tidied up the MfcTools/ directory. Created directories
* MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
*
* Revision 1.18  2002/08/30 19:39:37  loetzsch
* added a SYNC statement
*
* Revision 1.17  2002/08/22 15:20:10  loetzsch
* debug messages to the local processes are now sent in a better synchronized way.
*
* Revision 1.16  2002/08/13 12:57:41  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
* - Renamed CLayoutToolBar to CConfigurationToolBar
* - Added CRobotControlConfigurationManager
* - Removed CToolsToolBar
*
* Revision 1.15  2002/08/08 17:09:03  roefer
* SimGT2002 scripting enhanced
*
* Revision 1.14  2002/08/08 16:40:30  loetzsch
* added class LogPlayer and redesigned RobotControl's Logplayer GUI
*
* Revision 1.13  2002/08/07 10:48:50  loetzsch
* - faster starting of RobotControl application and main window
* - general clean up
*
* Revision 1.12  2002/07/23 13:44:48  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - new debug message handling
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.11  2002/06/28 10:26:21  roefer
* OUTPUT is possible in constructors
*
* Revision 1.10  2002/06/20 02:53:30  risler
* removed crashing outputs in communicate
*
* Revision 1.9  2002/06/11 09:01:20  roefer
* Heartbeat reactivated
*
* Revision 1.8  2002/06/10 20:29:59  roefer
* Communication in a separate thread, new router is default
*
* Revision 1.7  2002/06/08 11:43:59  mkunz
* Special Percept on Field
*
* Revision 1.6  2002/06/04 23:27:02  loetzsch
* 4-robots-in-RobotControl related bug fixes and improvements
*
* Revision 1.5  2002/06/04 14:47:39  loetzsch
* several bug fixes
*
* Revision 1.4  2002/06/04 00:15:36  loetzsch
* RobotControl now can simulate four robots.
*
* Revision 1.3  2002/05/15 12:20:38  juengel
* DebugDrawing for Pattern Analysis Challenge added.
*
* Revision 1.2  2002/05/10 14:46:51  juengel
* Removed calls of AutoColorDlg
*
* Revision 1.1.1.1  2002/05/10 12:40:19  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.96  2002/05/04 17:43:54  loetzsch
* removed some dead code
*
* Revision 1.95  2002/05/04 12:22:55  juengel
* Moved global instance of the ColorTable64 for segmented image views from CRobotControlApp to DebugDrawingManager.cpp
*
* Revision 1.94  2002/05/02 17:04:09  roefer
* New router
*
* Revision 1.93  2002/04/30 09:04:39  khuebner
* AutoColor Dialog included
*
* Revision 1.92  2002/04/23 17:45:18  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.91  2002/04/23 15:09:30  jhoffman
* added some pre GO fourier stuff
*
* Revision 1.90  2002/04/23 00:01:38  roefer
* Redesign of Bremen process layout
*
* Revision 1.89  2002/04/20 19:35:48  roefer
* PerceptCollection in images, also for UB1
*
* Revision 1.88  2002/04/20 15:52:21  roefer
* Project simpified, WATCH and WATCH_PART added
*
* Revision 1.87  2002/04/10 11:08:53  piepenstock
* added platform dependable SerialComm-Files
*
* Revision 1.86  2002/04/09 16:46:01  risler
* added DarmstadtGOWalkingEngine
*
* Revision 1.85  2002/04/09 11:18:27  loetzsch
* now handles idPlayerConfig
*
* Revision 1.84  2002/04/08 19:53:13  juengel
* Drawing of percept collections in images added.
*
* Revision 1.83  2002/04/08 18:40:46  dueffert
* XabslInputData added
*
* Revision 1.82  2002/04/08 15:59:21  fischer
* Added functionality to Fuzzy Behavior Control Tester
*
* Revision 1.81  2002/04/08 13:34:13  dueffert
* PlayersToolBar added
*
* Revision 1.80  2002/04/08 12:14:19  roefer
* Visualization of UB1 PerceptCollection from Robot improved
*
* Revision 1.79  2002/04/06 09:55:52  roefer
* Image and SensorData path through DebugQueues changed
*
* Revision 1.78  2002/04/02 15:05:38  loetzsch
* XabslDlgBar can now test skills
*
* Revision 1.77  2002/03/27 12:56:47  piepenstock
* Added serial communication support
*
* Revision 1.76  2002/03/25 09:29:03  rentmeister
* Behavior Dialog
*
* Revision 1.75  2002/03/24 18:15:00  loetzsch
* continued change to blocking sensor data receivers
*
* Revision 1.74  2002/03/24 14:19:46  roefer
* Input now waits for SensorData
*
* Revision 1.73  2002/03/23 22:25:44  roefer
* LandmarksPercepts now in player coordinates
*
* Revision 1.72  2002/03/16 13:44:49  juengel
* GridImageProcessor created.
*
* Revision 1.71  2002/03/12 14:05:17  jhoffman
* added stuff necessary for the Fourier Walking Engine to work
*
* Revision 1.70  2002/03/07 14:04:23  matters
* Queueverarbeitung fr WorldState erweitert:
* bergabe des WorldState an den Evolver
* (fr richtige WorldStateID warten wir auf Newsgroup-Antwort)
*
* Revision 1.69  2002/03/06 10:20:55  juengel
* Drawing of field polygons depends on team color.
*
* Revision 1.68  2002/02/28 16:28:25  risler
* added GT2001WalkingParameters
*
* Revision 1.67  2002/02/27 19:52:49  loetzsch
* TimeDiagram dialog continued
*
* Revision 1.66  2002/02/18 14:08:00  juengel
* SettingsDlgBar added.
*
* Revision 1.65  2002/02/18 12:05:18  loetzsch
* Percept visualization continued
*
* Revision 1.64  2002/02/12 16:34:49  risler
* finished MofTester
*
* Revision 1.63  2002/02/11 00:55:38  loetzsch
* ::Paint Methoden in ::paint umbenannt,
* BallPerzept- Visualisierung fertig
*
* Revision 1.62  2002/02/10 12:45:14  loetzsch
* radar viewer and percept visualization continued
*
* Revision 1.61  2002/02/09 15:13:38  juengel
* ColorSpaceDlgBar added.
*
* Revision 1.60  2002/02/08 14:24:41  kspiess
* Funktionalitt fr das HSIColorTableTool eingebaut.
* Neuen Zoom-Dialog fr das HSIColorTableTool integriert.
*
* Revision 1.59  2002/02/07 16:28:11  loetzsch
* improved toolbars
*
* Revision 1.58  2002/02/06 01:15:41  loetzsch
* oracled world states are now first send through the local processes
* before they are painted. (for synchronization with the painting of the
* calculated world states)
*
* Revision 1.57  2002/02/05 20:02:15  risler
* handleDebugMessage now returns bool, added debug message handling to ImageProcessor
*
* Revision 1.56  2002/02/05 04:20:05  loetzsch
* changed CRobotControlDebugMessageHandler::handleDebugMessage()
*
* Revision 1.55  2002/02/04 11:39:47  juengel
* ImageProcessorTester dialog added.
*
* Revision 1.54  2002/01/30 17:31:06  loetzsch
* handleDebugMessage um Parameter timestamp erweitert
*
* Revision 1.53  2002/01/30 12:12:58  risler
* added OUTPUT for unhandled debug message
*
* Revision 1.52  2002/01/28 17:28:03  brunn
* wlanHeartbeat verbessert
*
* Revision 1.51  2002/01/28 15:07:52  loetzsch
* removed local references in CRobotControlDebugMessageHandler
*
* Revision 1.50  2002/01/28 14:00:33  loetzsch
* JointViewer continued
*
* Revision 1.49  2002/01/27 16:39:05  roefer
* Renamed RoboCup.scn to GT2002.scn for aesthetic reasons
*
* Revision 1.48  2002/01/26 18:09:20  juengel
* DebugDrawingManager umstrukturiert.
*
* Revision 1.47  2002/01/26 03:18:29  loetzsch
* call pMainFrame::OnIdle synchronized
*
* Revision 1.46  2002/01/26 03:11:27  loetzsch
* JointViewer continued
*
* Revision 1.45  2002/01/25 18:02:26  roefer
* SYNCs reduced
*
* Revision 1.44  2002/01/25 16:54:56  loetzsch
* Messages from OVirtualRobotComm are sent now in a synchronized way
*
* Revision 1.43  2002/01/25 15:01:42  risler
* removed ifdef WLAN
*
* Revision 1.42  2002/01/25 14:52:42  risler
* wlan disconnect on error
*
* Revision 1.41  2002/01/25 14:43:09  risler
* bugfix in wlanReceive
*
* Revision 1.40  2002/01/25 14:20:35  brunn
* Rckgabewerte WLan gendert
*
* Revision 1.39  2002/01/24 18:19:18  loetzsch
* JointViewer added
*
* Revision 1.38  2002/01/24 17:23:14  brunn
* WLan - simples Protokoll eingefhrt um fragmentierte Pakete zusammenzuklauben
*
* Revision 1.37  2002/01/24 11:44:35  risler
* added WLAN Toolbar
*
* Revision 1.36  2002/01/23 13:53:03  risler
* wlan send only with connection
*
* Revision 1.35  2002/01/23 12:35:37  juengel
* Repaint von DebugDrawings neu organisiert.
*
* Revision 1.34  2002/01/23 11:16:53  brunn
* WLAN im CVS nicht definieren solange kein Konfigurationsdialog existiert
*
* Revision 1.33  2002/01/23 07:51:15  loetzsch
* Behandlung von Nachrichten des Types idImageAndSensorDataAndOdometry eingebaut
*
* Revision 1.32  2002/01/22 22:27:46  loetzsch
* in OnIdle wlanSend and wlanReceive removed.
*
* Revision 1.31  2002/01/22 14:51:18  juengel
* TestDataGenerator eingefhrt
*
* Revision 1.30  2002/01/22 14:28:38  risler
* changed wlan port to 15095
*
* Revision 1.29  2002/01/21 16:05:46  brunn
* WLan Interface Debugging
*
* Revision 1.28  2002/01/21 14:30:42  brunn
* WLan Interface eingebaut - todo: Dialog fr Parameter und Connect/Disconnect
*
* Revision 1.27  2002/01/20 23:34:28  loetzsch
* Sending images and sensor data to processes running in RobotControl now possible
*
* Revision 1.26  2002/01/19 08:07:29  juengel
* stopwatch weiterentwickelt
*
* Revision 1.25  2002/01/18 23:30:07  loetzsch
* Distribution of HeadControlModes, HeadMotionRequests and SolutionRequests added
*
* Revision 1.24  2002/01/18 02:17:39  loetzsch
* MotionTester dialog and distribution of MotionRequests
* to the processes programmed.
*
* Revision 1.23  2002/01/17 13:35:13  loetzsch
* queueToProcesses introduced an connected to OVirtualRobotComm
*
* Revision 1.22  2002/01/16 16:34:10  juengel
* stopwatch eingebaut
*
* Revision 1.21  2002/01/16 14:06:03  loetzsch
* OnIdle() Bug fixed
*
* Revision 1.20  2002/01/16 01:45:21  loetzsch
* SimRobot / RobotControl integration continued
*
* Revision 1.19  2002/01/14 22:43:01  loetzsch
* SimRobot / RobotControl integration started
*
* Revision 1.18  2002/01/09 18:35:06  juengel
* Hack eingebaut, damit OUTPUT im RobotControl funktioniert.
*
* Revision 1.17  2002/01/08 15:51:47  juengel
* ModuleTester angelegt.
*
* Revision 1.16  2002/01/06 12:13:23  juengel
* Behandlung von DebugDrawings in den MessageHandler aufgenommen
*
* Revision 1.15  2001/12/20 19:22:42  juengel
* Message-Behandlung fr idColorTable eingebaut.
* SetSize der queueToRobot und queueToRobotControl vor
* das Erstellen des MainFrames gezogen.
*
* Revision 1.13  2001/12/20 14:37:10  juengel
* Methode zum zeichnen eines Farbverlaufs ergnzt
*
* Revision 1.12  2001/12/19 16:03:56  bach
* SystemDataTypes replaced by Sensors
*
* Revision 1.11  2001/12/18 16:41:50  loetzsch
* Memory Leaks beim Lesen von Text aus QueueToRobotContol ausgebaut
*
* Revision 1.10  2001/12/16 17:18:55  loetzsch
* DebugKeyToolBar wieder groe Member Funktionsnamen eingebaut, Technote zu Toolbars
*
* Revision 1.9  2001/12/15 19:26:13  juengel
* ColorTable, ColorTable64, ColorTable64DlgBar hinzugefgt.
*
* Revision 1.8  2001/12/12 18:08:56  loetzsch
* Streaming- Operatoren fr Bilder eingebaut, DebugKeyTable nicht- statisch gemacht, Debuggin Mechanismen weitergemacht, Bilder aus Logfiles in RobotControl anzeigen, Logfiles in HU1/Debug auf den Stick schreiben
*
* Revision 1.7  2001/12/10 17:47:09  risler
* change log added
*
*/

