/**
* @file ToolBarEx.h
* 
* interface for the CToolBarEx class.
*
* Copyright (c) 2001 by Nikolay Denisov. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Please email bug reports, bug fixes, enhancements, requests and
* comments to: nick@actor.ru
*/


#ifndef __TOOLBAREX_H__
#define __TOOLBAREX_H__

#include "StdAfx.h"

/** an extended toolbar button */
struct TBBUTTONEX
{
    TBBUTTON tbinfo;
    bool     bInitiallyVisible;
};

/** the size of a small button image */
const CSize szImageSmall( 16, 16 );

/** an extended toolbar */
class CToolBarEx : public CToolBar
{
    DECLARE_DYNAMIC( CToolBarEx );

    friend class CToolBarPopup;

// Construction
public:
    CToolBarEx();
    ~CToolBarEx();

    bool Create( CWnd* pParentWnd, UINT nID);
    bool SetBarText( LPCTSTR text );
// Attributes
public:
    void SetText();
    void SetIcons();
    void AddString(CStatic* pStatic, UINT nID, CString text, int width);
    void AddCombo(CComboBox* pComboBox, UINT nID, int width);
    void AddSlider(CSliderCtrl* pSlider, UINT nID, int width);
    void AddEdit(CEdit* pEdit, UINT nID, int width, CComboBox* pDummyCombo);
    void SetImage(UINT nID, int iImage);
// Operations
public:
    void SetBitmaps( UINT nIDButtons, UINT nIDButtonsCold, COLORREF clrMask = RGB( 255, 0, 255 ) );
    void SetButtons( int nNumButtons, TBBUTTONEX* lpButtons);

    void LoadState( LPCTSTR lpszProfileName );
    void SaveState( LPCTSTR lpszProfileName );

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CToolBarEx)
    protected:
    virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
    //}}AFX_VIRTUAL

    virtual LRESULT DoCustomDraw( NMHDR* pNMHDR, CWnd* pToolBar );

    virtual bool HasButtonText( UINT nID );
    virtual bool HasButtonTip( UINT nID );
    virtual void GetButtonText( UINT nID, CString& strText );
    virtual void GetButtonTip( UINT nID, CString& strTip );

public:
    virtual void Init();
    virtual bool IsTextOptionAvailable( ) const;
    virtual bool IsIconOptionAvailable( ) const;

// Implementation
protected:
    CReBarCtrl& GetParentReBarCtrl() const;
    int GetParentBandIndex() const;
    void ReloadButtons();
    void UpdateParentBandInfo();
    bool GetButtonInfo( UINT nID, TBBUTTON& tbinfo );

    static LRESULT CALLBACK CBTProc( int nCode, WPARAM wParam, LPARAM lParam );

// Implementation data
protected:
   // the used buttons
    CArray< TBBUTTONEX, TBBUTTONEX& > m_aButtons;
   // m.l.: the originally added buttons
    CArray< TBBUTTONEX, TBBUTTONEX& > m_aButtonsSaved;
    

    UINT            m_nIDSmallCold;
    UINT            m_nIDSmallHot;
    CImageList      m_imageListCold;
    CImageList      m_imageListHot;
    COLORREF        m_clrMask;

    static LPCTSTR              m_lpszStateInfoEntry;
    static CToolBarEx*          m_pToolBar;
    static HHOOK                m_hCBTHook;

// Generated message map functions
protected:
    //{{AFX_MSG(CToolBarEx)
    //}}AFX_MSG

    afx_msg LRESULT OnReBarChevronPushed( WPARAM wParam, LPARAM lParam );

    afx_msg void OnCustomDraw( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnGetInfoTip( NMHDR* pNMHDR, LRESULT* pResult );

    // Toolbar customization
    afx_msg void OnBeginAdjust( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnEndAdjust( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnQueryInsert( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnQueryDelete( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnGetButtonInfo( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnToolBarChange( NMHDR* pNMHDR, LRESULT* pResult );

    // Saving and restoring toolbar
    afx_msg void OnSave( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnRestore( NMHDR* pNMHDR, LRESULT* pResult );
    
    DECLARE_MESSAGE_MAP();
};

/** a class for popups on toolbars */
class CToolBarPopup : public CWnd
{
    DECLARE_DYNAMIC( CToolBarPopup );

// Construction
public:
    CToolBarPopup( CToolBarEx* pToolBar );
    ~CToolBarPopup();

// Operations
public:
    bool ShowPopup( UINT nFlags, CPoint pt, CRect& rcExclude );

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CToolBarPopup)
    protected:
    virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
    virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
    virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
    //}}AFX_VIRTUAL

// Implementation
protected:
    void SetPosition( UINT nFlags, CPoint pt, CRect& rcExclude );
    void Show( UINT nFlags, const CRect& rc );
    void OnKeyDown( UINT nChar );

    static LRESULT CALLBACK KeyboardProc( int code, WPARAM wParam, LPARAM lParam );

// Implementation data
protected:
    CToolBarEx*     m_pToolBar;
    CToolBarCtrl    m_tbCtrl;
    bool            m_bOverTbCtrl;
    bool            m_bTextLabels;

    static HHOOK            m_hKeyboardHook;
    static CToolBarPopup*   m_pPopup;

// Generated message map functions
protected:
    //{{AFX_MSG(CToolBarPopup)
    afx_msg void OnCaptureChanged(CWnd *pWnd);
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
    //}}AFX_MSG
    afx_msg void OnEndModalLoop();
    DECLARE_MESSAGE_MAP()
};

#endif  // !__MENUBAR_H__

/*
 * Change log :
 * 
 * $Log: ToolBarEx.h,v $
 * Revision 1.1.1.1  2004/05/22 17:29:05  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/02/23 13:27:25  jhoffman
 * - changes to Main-menu are shown ... this currently results in one additional menu (!) somebody please fix this!
 * - added GenericModalBinary-dialog: can be used to create a modal dialog where you can specify the button labels and the descriptive text (like APX...ModalDialog but you can specify what is written on the buttons)
 * - CameraToolBar: mode, shutter, gain extracted from dropdown
 * - ToolBarEx: added AddString method to write const. strings on a toolbar
 *
 * Revision 1.1  2003/10/07 10:10:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2003/05/11 23:29:26  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.3  2003/03/20 20:35:15  loetzsch
 * function setBitmap added
 *
 * Revision 1.2  2003/03/19 23:47:16  loetzsch
 * Added support for sliders on toolbars
 *
 * Revision 1.1  2002/09/10 15:49:10  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:20  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.1.1.1  2002/05/10 12:40:26  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2001/12/10 17:47:10  risler
 * change log added
 *
 */
