/**
* @file MenuBar.h
* 
* Interface for the CMenuBar class.
*
* Copyright (c) 2001 by Nikolay Denisov. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Please email bug reports, bug fixes, enhancements, requests and
* comments to: nick@actor.ru
*/

#ifndef __MENUBAR_H__
#define __MENUBAR_H__

#include "StdAfx.h"

// Tooltips
#define IDS_TOOLTIP_MINIMIZE            0xF200
#define IDS_TOOLTIP_RESTORE             0xF201
#define IDS_TOOLTIP_CLOSE               0xF202
#define IDS_TOOLTIP_MAXIMIZE            0xF203

/** A CMenuBar helper class */
class CMenuBarButton
{
// Construction
public:
    CMenuBarButton();

// Operations
public:
    void DrawButton( CDC* pDC );
    bool HitTest( CPoint pt ) const;
    void SetMDIChild( HWND hWndMDIChild );
    void SetMenuBarRect( LPCRECT lpRect );
    bool HideButton( bool bHide );
    bool PushButton( bool bPush );
    bool IsPushed() const;

    static CSize GetButtonSize();

// Overrides
public:
    virtual CRect GetButtonRect() const = 0;
    virtual UINT GetSysCommandID() const = 0;
    virtual bool IsEnabled() const;
    virtual bool IsVisible() const;

// Implementation
protected:
    DWORD GetMDIChildStyle() const;

// Implementation data
protected:
    HWND    m_hWndMDIChild;
    CRect   m_rcMenuBar;
    bool    m_bHidden;
    bool    m_bPushed;
};

/** A CMenuBar helper class */
class CMenuBarButtonMin : public CMenuBarButton
{
// Overrides
public:
    virtual CRect GetButtonRect() const;
    virtual UINT GetSysCommandID() const;
    virtual bool IsEnabled() const;
    virtual bool IsVisible() const;
};

/** A CMenuBar helper class */
class CMenuBarButtonMax : public CMenuBarButton
{
// Overrides
public:
    virtual CRect GetButtonRect() const;
    virtual UINT GetSysCommandID() const;
    virtual bool IsEnabled() const;
    virtual bool IsVisible() const;
};

/** A CMenuBar helper class */
class CMenuBarButtonClose : public CMenuBarButton
{
// Overrides
public:
    virtual CRect GetButtonRect() const;
    virtual UINT GetSysCommandID() const;
};


template < class TBase > class CFrameWndBase;

/** A class for holding menus in a floating bar */
class CMenuBar : public CToolBar
{
    DECLARE_DYNAMIC( CMenuBar );

    friend CFrameWndBase< CFrameWnd >;
    friend CFrameWndBase< CMDIFrameWnd >;

// Construction
public:
    CMenuBar();
    ~CMenuBar();

// Operations
public:
    bool SetMenu( HMENU hMenu );
    HMENU GetMenu() const;

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CMenuBar)
    //}}AFX_VIRTUAL

    virtual void OnUpdateCmdUI( CFrameWnd* pTarget, BOOL bDisableIfNoHndler );
    virtual int OnToolHitTest( CPoint point, TOOLINFO* pTI ) const;

// Implementation
protected:
    CReBarCtrl& GetParentReBarCtrl() const;
    int GetParentBandIndex() const;
    void SetButtonWidth( UINT nID, int nWidth );
    void UpdateMenuBar();
    void RepositionSysButtons( CRect rcMenuBar );
    void EnterTrackingMode( int nItem );
    void TrackChevronMenu( CRect& rcChevron, int nItem );
    void TrackPopupMenu();
    void ContinueTracking( bool bSelectFirst );
    void ExitTrackingMode();
    void ShowChevronMenu( int nItem );
    bool IsItemClipped( int nItem ) const;
    bool IsOverChevron( CPoint pt ) const;
    bool OnButtonDown( UINT nFlags, CPoint pt, bool bLeft );

// Implementation
protected:
    void HookMessageProc( UINT message, WPARAM wParam, LPARAM lParam );
    bool FrameOnSysCommand( UINT nID, LPARAM lParam );
    bool FrameOnMenuChar( UINT nChar, UINT nFlags, CMenu* pMenu );
    void FrameOnNcActivate( BOOL bActive );
    void FrameOnInitMenuPopup( CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu );
    void FrameOnMenuSelect( UINT nItemID, UINT nFlags, HMENU hSysMenu );

// Static members
protected:
    static HHOOK m_hMsgHook;
    static CMenuBar* m_pMenuBar;
    static LRESULT CALLBACK MessageProc( int code, WPARAM wParam, LPARAM lParam );

// Implementation data
protected:
    CFont   m_fontMenu;
    CPoint  m_ptMouseLast;

    HWND    m_hWndMDIChild;
    HWND    m_hWndOldFocus;
    HMENU   m_hMenu;
    HMENU   m_hMenuTracking;

    int     m_nItem;
    bool    m_bItemTracking;
    bool    m_bItemDropped;
    bool    m_bPrimaryMenu;
    bool    m_bSubmenuItem;
    bool    m_bEscape;
    bool    m_bContinue;
    bool    m_bSelectFirst;
    bool    m_bButtonCapture;
    bool    m_bFrameActive;

    CTypedPtrArray< CPtrArray, CMenuBarButton* > m_aMenuBarButtons;

// Generated message map functions
protected:
    //{{AFX_MSG(CMenuBar)
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
    afx_msg void OnCaptureChanged(CWnd *pWnd);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
    afx_msg UINT OnGetDlgCode();
    afx_msg void OnSettingChange(UINT uFlags, LPCTSTR lpszSection);
    //}}AFX_MSG

    afx_msg LRESULT OnShowPopupMenu( WPARAM wParam, LPARAM lParam );
    afx_msg LRESULT OnReBarChildSize( WPARAM wParam, LPARAM lParam );
    afx_msg LRESULT OnReBarChevronPushed( WPARAM wParam, LPARAM lParam );

    afx_msg void OnUpdateCommandUI( CCmdUI* pCmdUI );

    // Toolbar control notifications
    afx_msg void OnDropDown( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnHotItemChange( NMHDR* pNMHDR, LRESULT* pResult );
    afx_msg void OnCustomDraw( NMHDR* pNMHDR, LRESULT* pResult );
    DECLARE_MESSAGE_MAP();
};

#endif  // !__MENUBAR_H__

/*
 * Change log :
 * 
 * $Log: MenuBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:29:03  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:10:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/11 23:29:26  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.1  2002/09/10 15:49:10  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:20  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2001/12/10 17:47:10  risler
 * change log added
 *
 */
