/**
* @file SizingControlBarCF.h
*
* Declaration of class CSizingControlBarCF.
*
* Version 2.43
* 
* Created: Dec 21, 1998        Last Modified: August 03, 2000
*
* See the official site at www.datamekanix.com for documentation and
* the latest news.
*
* Copyright (C) 1998-2000 by Cristi Posea. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Send bug reports, bug fixes, enhancements, requests, flames, etc. to
* cristi@datamekanix.com or post them at the message board at the site.
*/

#ifndef __SizingControlBarCF_h_ 
#define __SizingControlBarCF_h_

#include "SizingControlBarG.h"

/** 
* @class CSizingControlBarCF
*
* An extended CSizingControlBarG class
*/
class CSizingControlBarCF : public CSizingControlBarG
{
    DECLARE_DYNAMIC(CSizingControlBarCF);

// Construction
public:
    CSizingControlBarCF();

// Overridables
    virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler);

// Implementation
protected:
    // implementation helpers
    virtual void NcPaintGripper(CDC* pDC, CRect rcClient);

protected:
    BOOL    m_bActive; // a child has focus
    CString m_sFontFace;

// Generated message map functions
protected:
    //{{AFX_MSG(CSizingControlBarCF)
    //}}AFX_MSG
    afx_msg LRESULT OnSetText(WPARAM wParam, LPARAM lParam);

    DECLARE_MESSAGE_MAP();
};

/////////////////////////////////////////////////////////////////////////

#endif // __SizingControlBarCF_h_

/*
 * Change log :
 * 
 * $Log: SizingControlBarCF.h,v $
 * Revision 1.1.1.1  2004/05/22 17:28:39  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:10:07  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:49:10  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:20  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.2  2002/08/30 17:22:46  dueffert
 * docu bugs fixed
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2001/12/10 17:47:10  risler
 * change log added
 *
 */
