/**
* @file DynamicWndEx.h
*
* Declaration of class CDynamicWndEx.
*
* Version 2.43
*
* Created: Jan 24, 1998        Last Modified: August 03, 2000
*
* See the official site at www.datamekanix.com for documentation and
* the latest news.
*
* Copyright (C) 1998-2000 by Cristi Posea. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Send bug reports, bug fixes, enhancements, requests, flames, etc. to
* cristi@datamekanix.com or post them at the message board at the site.
*/
#ifndef __DynamicWndEx_h_
#define __DynamicWndEx_h_


#include "DynamicWnd.h"

/**
 * @class CDynamicWndEx
 *
 * A class extended to offer some useful additions.
 */
class CDynamicWndEx : public CDynamicWnd
{
public:
	enum RestoreFlags
	{
		rflg_none			=	0,			// only load window position
		rflg_state			=	0x01,		// make window iconic/zoomed if been before
		rflg_visibility	=	0x02,		// hide/show window as been before
		rflg_all				=	rflg_state|rflg_visibility
	};

	enum ExFlags
	{
		flAutoPos	=	0x0100
	};

private:
	CString	m_strAutoPos;

public:
	CDynamicWndEx(Freedom fd, UINT nFlags) : CDynamicWnd(fd,nFlags) {}
	virtual ~CDynamicWndEx() {}

	//
	// utilities
	//

	bool StretchWindow(const CSize & szDelta);
	bool StretchWindow(int iAddPcnt);
	bool RestoreWindowPosition(LPCTSTR lpszProfile, UINT restoreFlags = rflg_all);
	bool StoreWindowPosition(LPCTSTR lpszProfile);

	//
	// feature one: auto-positioning :)
	// 

	void ActivateAutoPos(UINT nID) { m_strAutoPos.Format(_T("ID=0x%08lx"),nID); }
	void ActivateAutoPos(const CString & strID) { m_strAutoPos = strID; }
	void NoAutoPos() { m_strAutoPos.Empty(); }

	//
	// we need these
	//

protected:
	virtual void OnInitialized();
	virtual void OnDestroying();

public:
	static LPCTSTR	M_lpszAutoPosProfileSection;
};

#endif // __DynamicWndEx_h_

/*
 * Change log :
 * 
 * $Log: DynamicWndEx.h,v $
 * Revision 1.1.1.1  2004/05/22 17:28:37  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:10:07  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:49:10  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:20  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2001/12/10 17:47:10  risler
 * change log added
 *
 */
