/**
* @file DynamicDialog.cpp
* 
* Declaration of class CDynamicDialog and class CDynamicChildDialog
*
* Version 2.43
*
* Created: Jan 24, 1998        Last Modified: August 03, 2000
*
* See the official site at www.datamekanix.com for documentation and
* the latest news.
*
* Copyright (C) 1998-2000 by Cristi Posea. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Send bug reports, bug fixes, enhancements, requests, flames, etc. to
* cristi@datamekanix.com or post them at the message board at the site.
*/ 

#include "StdAfx.h"
#include "DynamicDialog.h"


/////////////////////////////////////////////////////////////////////////////
// CDynamicDialog dialog
/////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CDynamicDialog,CDialog);

/////////////////////////////////////////////////////////////////////////////
// message map
/////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CDynamicDialog, CDialog)
	//{{AFX_MSG_MAP(CDynamicDialog)
	ON_WM_GETMINMAXINFO()
	ON_WM_DESTROY()
	ON_WM_PARENTNOTIFY()
	ON_WM_SIZE()
	ON_WM_SIZING()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDynamicDialog message handlers: redirect stuff to my class :)=
/////////////////////////////////////////////////////////////////////////////

BOOL CDynamicDialog::OnInitDialog() 
{
	BOOL	bOK	=	CDialog::OnInitDialog();
	DoInitWindow(*this);

	return bOK;
}

BOOL CDynamicDialog::DestroyWindow()
{
	DoOnDestroy();
	return CDialog::DestroyWindow();
}

void CDynamicDialog::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	CDialog::OnGetMinMaxInfo(lpMMI);
	DoOnGetMinMaxInfo(lpMMI);
}

void CDynamicDialog::OnDestroy() 
{
	DoOnDestroy();
	CDialog::OnDestroy();
}

void CDynamicDialog::OnParentNotify(UINT message, LPARAM lParam) 
{
	CDialog::OnParentNotify(message, lParam);
	DoOnParentNotify(message, lParam);
}

void CDynamicDialog::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	DoOnSize(nType, cx, cy);
}

void CDynamicDialog::OnSizing(UINT fwSide, LPRECT pRect) 
{
	CDialog::OnSizing(fwSide, pRect);
	DoOnSizing(fwSide, pRect);
}

void CDynamicDialog::OnTimer(UINT idEvent)
{
	CDialog::OnTimer(idEvent);
	DoOnTimer(idEvent);
}


/////////////////////////////////////////////////////////////////////////////
// CDynamicChildDlg dialog
/////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CDynamicChildDlg,CDynamicDialog);

/////////////////////////////////////////////////////////////////////////////
// message map
/////////////////////////////////////////////////////////////////////////////


/*
 * Change log :
 * 
 * $Log: DynamicDialog.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:28:33  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:10:07  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/11 23:29:27  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.1  2002/09/10 15:49:09  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:19  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2001/12/10 17:47:09  risler
 * change log added
 *
 */
