/**
* @file DynamicBar.cpp
* 
* Implementation of class CDynamicBar and class CDynamicBarDlg 
*
* Version 2.43
*
* Created: Jan 24, 1998        Last Modified: August 03, 2000
*
* See the official site at www.datamekanix.com for documentation and
* the latest news.
*
* Copyright (C) 1998-2000 by Cristi Posea. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Send bug reports, bug fixes, enhancements, requests, flames, etc. to
* cristi@datamekanix.com or post them at the message board at the site.
*/

#include "StdAfx.h"
#include "DynamicBar.h"


/////////////////////////////////////////////////////////////////////////////
// CDynamicBarDlg dialog
/////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CDynamicBarDlg, CDynamicChildDlg);

/////////////////////////////////////////////////////////////////////////////
// CDynamicBarDlg dialog
/////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CDynamicBarDlg, CDynamicChildDlg)
	ON_WM_CLOSE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDynamicBarDlg functions
/////////////////////////////////////////////////////////////////////////////

bool CDynamicBarDlg::Create(CDynamicBar *pBar)
{
	return CDynamicChildDlg::Create(m_nID,(CWnd *)pBar) != FALSE;
}


/////////////////////////////////////////////////////////////////////////////
// CDynamicBar
/////////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CDynamicBar,CSizingControlBarCF);

/////////////////////////////////////////////////////////////////////////////
// construction
/////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CDynamicBar, CSizingControlBarCF)
	//{{AFX_MSG_MAP(CDynamicBar)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDynamicBar message handlers
/////////////////////////////////////////////////////////////////////////////

int CDynamicBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CSizingControlBarCF::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// set single child autosizing mode
	SetSCBStyle(GetSCBStyle() | SCBS_SIZECHILD);

	// create the child dialog
	if (!m_rDlg.Create(this))
		return -1;

	ASSERT(::IsWindow(m_hWnd));
	ASSERT(::IsWindow(m_rDlg.m_hWnd));

	// allow image caching when resizing controls (reduces flicker)
	m_rDlg.ModifyFlags(CDynamicWnd::flSWPCopyBits, 0);

	// set the initial&min sizes for the bar, based on child dialog size
	//   NcCalcClient() is called to compute the extra non-client space
	//   needed - r.Size() will be negative after each call
	CRect r;
	r.SetRectEmpty();
	NcCalcClient(&r, AFX_IDW_DOCKBAR_FLOAT);
    m_szMinFloat = m_szFloat = m_rDlg.m_szMin - r.Size();

	r.SetRectEmpty();
	NcCalcClient(&r, AFX_IDW_DOCKBAR_LEFT);
    m_szMinVert = m_szVert = m_rDlg.m_szMin - r.Size();

	r.SetRectEmpty();
	NcCalcClient(&r, AFX_IDW_DOCKBAR_TOP);
	m_szMinHorz = m_szHorz = m_rDlg.m_szMin - r.Size();

	return 0;
}

/*
 * route command UI updates to dialog
 */

void CDynamicBar::OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler)
{
	CSizingControlBarCF::OnUpdateCmdUI(pTarget,bDisableIfNoHndler);
	if(m_rDlg.IsWindow())
		m_rDlg.OnUpdateCmdUI(pTarget,bDisableIfNoHndler);
}

/*
 * route commands a long...
 */

BOOL CDynamicBar::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	if(m_rDlg.IsWindow() && m_rDlg.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;
	return CSizingControlBarCF::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

/*
 * route commands ...
 */

BOOL CDynamicBar::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if(m_rDlg.IsWindow() && m_rDlg.OnCommand(wParam, lParam))
		return TRUE;
	return CSizingControlBarCF::OnCommand(wParam, lParam);
}

/*
 * Change log :
 * 
 * $Log: DynamicBar.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:28:32  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:10:07  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/11 23:29:27  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.1  2002/09/10 15:49:09  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:19  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2001/12/10 17:47:09  risler
 * change log added
 *
 */
