/**
 *  @file HSIDataTypes.cpp
 *  Implementation of class HSIDataTypes.
 *  @author<A href="mailto:kspiess@informatik.uni-bremen.de">Kai Spiess</A>
 */

#include "HSIDataTypes.h"

void HSIColorTable::init()
{
  for(int i=0; i < NUMBER_OF_COLOR_CLASSES; i++)
  {
    colorClasses[i].H_max =   0;
    colorClasses[i].H_min =   0;
    colorClasses[i].S_max =   0;
    colorClasses[i].S_min =   0;
    colorClasses[i].I_max =   0;
    colorClasses[i].I_min =   0;
  }
}


//HSIColorRangeUndo
HSIColorRangeUndo::HSIColorRangeUndo()
{
  this->set = false;
}

void HSIColorRangeUndo::setHSIColorRangeUndo(HSIColorRange hsiColorRange, int colorClass)
{
  this->hsiColorRange.H_max = hsiColorRange.H_max;
  this->hsiColorRange.H_min = hsiColorRange.H_min;
  this->hsiColorRange.S_max = hsiColorRange.S_max;
  this->hsiColorRange.S_min = hsiColorRange.S_min;
  this->hsiColorRange.I_max = hsiColorRange.I_max;
  this->hsiColorRange.I_min = hsiColorRange.I_min;
  this->colorClass = colorClass;
  this->set = true;
}

/////////////////////////
//****** Streaming ******
/////////////////////////

//HSIColorRange
In& operator>>(In& stream,HSIColorRange& hsiColorRange)
{
  stream >> hsiColorRange.H_max >> hsiColorRange.H_min;
  stream >> hsiColorRange.S_max >> hsiColorRange.S_min;
  stream >> hsiColorRange.I_max >> hsiColorRange.I_min;
  return stream;
}

Out& operator<<(Out& stream, const HSIColorRange& hsiColorRange)
{
  stream << hsiColorRange.H_max << hsiColorRange.H_min;
  stream << hsiColorRange.S_max << hsiColorRange.S_min;
  stream << hsiColorRange.I_max << hsiColorRange.I_min;
  return stream;
}


//HSIColorTable
In& operator>>(In& stream,HSIColorTable& hsiColorTable)
{
  for(int i=0; i < NUMBER_OF_COLOR_CLASSES; i++)
  {
    stream.read(&hsiColorTable.colorClasses[i], sizeof(HSIColorRange));
  }
  return stream;
}
 
Out& operator<<(Out& stream, const HSIColorTable& hsiColorTable)
{
  for(int i=0; i < NUMBER_OF_COLOR_CLASSES; i++)
  {
    stream.write(&hsiColorTable.colorClasses[i], sizeof(HSIColorRange));
  }
  return stream;
}


//HSIColorRangeUndo
In& operator>>(In& stream,HSIColorRangeUndo& hsiColorRangeUndo)
{
  stream >> hsiColorRangeUndo.colorClass;
  stream.read(&hsiColorRangeUndo.hsiColorRange, sizeof(HSIColorRange));

  return stream;
}

Out& operator<<(Out& stream, const HSIColorRangeUndo& hsiColorRangeUndo)
{
  stream << hsiColorRangeUndo.colorClass;
  stream.write(&hsiColorRangeUndo.hsiColorRange, sizeof(HSIColorRange));

  return stream;
}


/*
 * Change log :
 * 
 * $Log: HSIDataTypes.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:28:27  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/05/12 20:38:14  roefer
 * Unused lines of code removed
 *
 * Revision 1.2  2004/01/17 17:07:41  roefer
 * HSI-Toolbar does not crash anymore, but image size is still 176x144
 *
 * Revision 1.1  2003/10/07 10:10:07  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:49:09  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2002/04/05 08:17:00  kspiess
 * gleichzeitiges Speichern von HSI und C64 Farbtabelle eingebaut;
 * Fehler beim Anklicken einzelner Pixel im Zoom-Dialog zur Verschiebung
 * der HSI-Grenzen behoben;
 * Fehler beim mehrstufigen Undo behoben
 *
 * Revision 1.2  2002/02/08 14:46:26  kspiess
 * Change log added
 *
 *
 */