/**
* @file WLANConfigurationDialog.cpp
* 
* Implementation of WLAN new connection dialog in the RobotControl project.
*
* @author Max Risler, Uwe Dffert, Thomas Kindler
*/

#include "StdAfx.h"

#include "WLANConfigurationDialog.h"
#include "RobotControl.h"
#include "Tools/Player.h"


CWLANConfigurationDialog::CWLANConfigurationDialog(CWnd* pParent /*=NULL*/)
: CDialog(CWLANConfigurationDialog::IDD, pParent),config(0)
{
  //{{AFX_DATA_INIT(CWLANConfigurationDialog)
  m_useRed1 = false;
  m_useRed2 = false;
  m_useRed3 = false;
  m_useRed4 = false;
  m_useBlue1 = false;
  m_useBlue2 = false;
  m_useBlue3 = false;
  m_useBlue4 = false;
  m_wepkeyBlueEdit = _T("");
  m_teamRedEdit = _T("");
  m_teamBlueEdit = _T("");
  //}}AFX_DATA_INIT
}


void CWLANConfigurationDialog::DoDataExchange(CDataExchange* pDX)
{

  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CWLANConfigurationDialog)
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_UPDATE_CHECK, m_updateCheck);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_REMOVE_CHECK, m_removeCheck);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_EJECT_CHECK, m_ejectCheck);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_UNSAFE_CHECK, m_unsafeCheck);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_TELNET_CHECK, m_telnetCheck);
  DDX_Text(pDX, IDC_WLAN_CONFIGURATION_NAME, m_nameEdit);
  DDV_MaxChars(pDX, m_nameEdit, 32);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RED_ROBOT1_IP, m_ipRed1);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RED_ROBOT2_IP, m_ipRed2);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RED_ROBOT3_IP, m_ipRed3);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RED_ROBOT4_IP, m_ipRed4);
  DDX_Check(pDX, IDC_WLAN_CONFIGURATION_RED_ROBOT1_USE, m_useRed1);
  DDX_Check(pDX, IDC_WLAN_CONFIGURATION_RED_ROBOT2_USE, m_useRed2);
  DDX_Check(pDX, IDC_WLAN_CONFIGURATION_RED_ROBOT3_USE, m_useRed3);
  DDX_Check(pDX, IDC_WLAN_CONFIGURATION_RED_ROBOT4_USE, m_useRed4);
  DDX_Text(pDX, IDC_WLAN_CONFIGURATION_RED_ESSID, m_essidRedEdit);
  DDV_MaxChars(pDX, m_essidRedEdit, 32);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RED_NETMASK, m_netmaskRed);
  DDX_Text(pDX, IDC_WLAN_CONFIGURATION_RED_WEPKEY, m_wepkeyRedEdit);
  DDV_MaxChars(pDX, m_wepkeyRedEdit, 16);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_BLUE_ROBOT1_IP, m_ipBlue1);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_BLUE_ROBOT2_IP, m_ipBlue2);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_BLUE_ROBOT3_IP, m_ipBlue3);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_BLUE_ROBOT4_IP, m_ipBlue4);
  DDX_Check(pDX, IDC_WLAN_CONFIGURATION_BLUE_ROBOT1_USE, m_useBlue1);
  DDX_Check(pDX, IDC_WLAN_CONFIGURATION_BLUE_ROBOT2_USE, m_useBlue2);
  DDX_Check(pDX, IDC_WLAN_CONFIGURATION_BLUE_ROBOT3_USE, m_useBlue3);
  DDX_Check(pDX, IDC_WLAN_CONFIGURATION_BLUE_ROBOT4_USE, m_useBlue4);
  DDX_Text(pDX, IDC_WLAN_CONFIGURATION_BLUE_ESSID, m_essidBlueEdit);
  DDV_MaxChars(pDX, m_essidBlueEdit, 32);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_BLUE_NETMASK, m_netmaskBlue);
  DDX_Text(pDX, IDC_WLAN_CONFIGURATION_BLUE_WEPKEY, m_wepkeyBlueEdit);
  DDV_MaxChars(pDX, m_wepkeyBlueEdit, 16);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RADIO_ERS210, m_isERS210);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RADIO_ERS7, m_isERS7);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_WHATROBOTTOCOPYFOR, m_whichToCopyTo);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RED_CHANNEL_COMBO, m_channelRedEdit);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_BLUE_CHANNEL_COMBO, m_channelBlueEdit);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_RED_APMODE_COMBO, m_apmodeRedEdit);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_BLUE_APMODE_COMBO, m_apmodeBlueEdit);
  DDX_Text(pDX, IDC_WLAN_CONFIGURATION_RED_TEAM, m_teamRedEdit);
  DDV_MaxChars(pDX, m_teamRedEdit, 16);
  DDX_Text(pDX, IDC_WLAN_CONFIGURATION_BLUE_TEAM, m_teamBlueEdit);
  DDV_MaxChars(pDX, m_teamBlueEdit, 16);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_COPYFILES, m_copyFiles);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_SELECTIONINDICATOR1, m_selectionIndicator[0]);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_SELECTIONINDICATOR2, m_selectionIndicator[1]);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_SELECTIONINDICATOR3, m_selectionIndicator[2]);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_SELECTIONINDICATOR4, m_selectionIndicator[3]);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_SELECTIONINDICATOR5, m_selectionIndicator[4]);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_SELECTIONINDICATOR6, m_selectionIndicator[5]);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_SELECTIONINDICATOR7, m_selectionIndicator[6]);
  DDX_Control(pDX, IDC_WLAN_CONFIGURATION_SELECTIONINDICATOR8, m_selectionIndicator[7]);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWLANConfigurationDialog, CDialog)
//{{AFX_MSG_MAP(CWLANConfigurationDialog)
ON_BN_CLICKED(IDC_WLAN_CONFIGURATION_COPYFILES, OnOneButtonCopy)
ON_CBN_SELCHANGE(IDC_WLAN_CONFIGURATION_WHATROBOTTOCOPYFOR, OnChangeCopyTarget)
ON_BN_CLICKED(IDC_WLAN_CONFIGURATION_UPDATE_CHECK, OnUpdate)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//ON_SELCHANGE(IDC_WLAN_CONFIGURATION_WHATROBOTTOCOPYFOR, OnChangeCopyTarget)

void CWLANConfigurationDialog::OnChangeCopyTarget()
{
  m_selectionIndicator[0].ShowWindow(SW_HIDE);
  m_selectionIndicator[1].ShowWindow(SW_HIDE);
  m_selectionIndicator[2].ShowWindow(SW_HIDE);
  m_selectionIndicator[3].ShowWindow(SW_HIDE);
  m_selectionIndicator[4].ShowWindow(SW_HIDE);
  m_selectionIndicator[5].ShowWindow(SW_HIDE);
  m_selectionIndicator[6].ShowWindow(SW_HIDE);
  m_selectionIndicator[7].ShowWindow(SW_HIDE);

  m_selectionIndicator[m_whichToCopyTo.GetCurSel()].ShowWindow(SW_SHOWNORMAL);
}


BOOL CWLANConfigurationDialog::OnInitDialog() 
{
  CDialog::OnInitDialog();
  CRobotControlWLANConfiguration temp;
  CRobotControlWLANConfiguration* conf=config;
  if (conf==0) conf = &temp;  //should never happen
  
  m_nameEdit=conf->name;

  
  // If no bitmap is defined for the button, define the bitmap to the
  // system close bitmap.
   
  m_copyFiles.SetIcon( (HICON)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_CREATENEW), IMAGE_BITMAP, 0, 0, LR_MONOCHROME | LR_LOADTRANSPARENT));

  // m_ipRedRouter.SetAddress(conf->ipRedRouter);
  // m_ipBlueRouter.SetAddress(conf->ipBlueRouter);
  // m_portRedRouterEdit=conf->portRedRouter;
  // m_portBlueRouterEdit=conf->portBlueRouter;
  // m_autostartRed=conf->autostartRed;
  // m_autostartBlue=conf->autostartBlue;
  
  m_ipRed1.SetAddress(conf->ipRed[0]);
  m_ipRed2.SetAddress(conf->ipRed[1]);
  m_ipRed3.SetAddress(conf->ipRed[2]);
  m_ipRed4.SetAddress(conf->ipRed[3]);
  m_useRed1=conf->useRed[0];
  m_useRed2=conf->useRed[1];
  m_useRed3=conf->useRed[2];
  m_useRed4=conf->useRed[3];
  m_ipBlue1.SetAddress(conf->ipBlue[0]);
  m_ipBlue2.SetAddress(conf->ipBlue[1]);
  m_ipBlue3.SetAddress(conf->ipBlue[2]);
  m_ipBlue4.SetAddress(conf->ipBlue[3]);
  m_useBlue1=conf->useBlue[0];
  m_useBlue2=conf->useBlue[1];
  m_useBlue3=conf->useBlue[2];
  m_useBlue4=conf->useBlue[3];
  
  m_essidRedEdit=conf->essidRed;
  m_essidBlueEdit=conf->essidBlue;
  m_netmaskRed.SetAddress(conf->netmaskRed);
  m_netmaskBlue.SetAddress(conf->netmaskBlue);

  m_apmodeRedEdit.SetCurSel(conf->apmodeRed);
  m_apmodeBlueEdit.SetCurSel(conf->apmodeBlue);
  
  m_channelRedEdit.SetCurSel(conf->channelRed-1);
  m_channelBlueEdit.SetCurSel(conf->channelBlue-1);
  m_wepkeyRedEdit=conf->wepkeyRed;
  m_wepkeyBlueEdit=conf->wepkeyBlue;
  m_teamBlueEdit = conf->teamIdentifierBlue;
  m_teamRedEdit = conf->teamIdentifierRed;

  m_whichToCopyTo.SetCurSel(3);
  m_whichToCopyTo.SetCurSel(AfxGetApp()->GetProfileInt("WLAN", "copyForThisRobot",1));
  m_updateCheck.SetCheck(AfxGetApp()->GetProfileInt("WLAN", "update", 1));
  m_removeCheck.SetCheck(AfxGetApp()->GetProfileInt("WLAN", "remove", 0));
  m_ejectCheck.SetCheck(AfxGetApp()->GetProfileInt("WLAN", "eject", 0));
  m_unsafeCheck.SetCheck(AfxGetApp()->GetProfileInt("WLAN", "unsafe", 0));
  m_telnetCheck.SetCheck(AfxGetApp()->GetProfileInt("WLAN", "telnet", 1));

  if (AfxGetApp()->GetProfileInt("WLAN", "ERS7", 1)) { 
    m_isERS7.SetCheck(1);
    m_isERS210.SetCheck(0);
  } else {
    m_isERS7.SetCheck(0);
    m_isERS210.SetCheck(1);
  }
  UpdateData(false);
  OnChangeCopyTarget();
  OnUpdate();

  return TRUE;
}

void CWLANConfigurationDialog::OnOK() 
{
  if (config)
  {
    UpdateData(true);
    strcpy(config->name,m_nameEdit.GetBuffer(64));
    
    // m_ipRedRouter.GetAddress(config->ipRedRouter);
    // m_ipBlueRouter.GetAddress(config->ipBlueRouter);
    // config->portRedRouter=m_portRedRouterEdit;
    // config->portBlueRouter=m_portBlueRouterEdit;
    // config->autostartRed=(m_autostartRed!=0);
    // config->autostartBlue=(m_autostartBlue!=0);    
    
    m_ipRed1.GetAddress(config->ipRed[0]);
    m_ipRed2.GetAddress(config->ipRed[1]);
    m_ipRed3.GetAddress(config->ipRed[2]);
    m_ipRed4.GetAddress(config->ipRed[3]);
    config->useRed[0]=(m_useRed1!=0);
    config->useRed[1]=(m_useRed2!=0);
    config->useRed[2]=(m_useRed3!=0);
    config->useRed[3]=(m_useRed4!=0);
    m_ipBlue1.GetAddress(config->ipBlue[0]);
    m_ipBlue2.GetAddress(config->ipBlue[1]);
    m_ipBlue3.GetAddress(config->ipBlue[2]);
    m_ipBlue4.GetAddress(config->ipBlue[3]);
    config->useBlue[0]=(m_useBlue1!=0);
    config->useBlue[1]=(m_useBlue2!=0);
    config->useBlue[2]=(m_useBlue3!=0);
    config->useBlue[3]=(m_useBlue4!=0);
    
    strcpy(config->essidRed,m_essidRedEdit.GetBuffer(16));
    strcpy(config->essidBlue,m_essidBlueEdit.GetBuffer(16));
    m_netmaskRed.GetAddress(config->netmaskRed);
    m_netmaskBlue.GetAddress(config->netmaskBlue);
    config->apmodeRed=m_apmodeRedEdit.GetCurSel();
    config->apmodeBlue=m_apmodeBlueEdit.GetCurSel();
    config->channelRed=m_channelRedEdit.GetCurSel() + 1;
    config->channelBlue=m_channelBlueEdit.GetCurSel() + 1;
    strcpy(config->wepkeyRed,m_wepkeyRedEdit.GetBuffer(16));
    strcpy(config->wepkeyBlue,m_wepkeyBlueEdit.GetBuffer(16));

    AfxGetApp()->WriteProfileInt("WLAN", "ERS7",(int)m_isERS7.GetCheck());
    AfxGetApp()->WriteProfileInt("WLAN", "copyForThisRobot",(int)m_whichToCopyTo.GetCurSel());
    AfxGetApp()->WriteProfileInt("WLAN", "update",(int)m_updateCheck.GetCheck());
    AfxGetApp()->WriteProfileInt("WLAN", "remove",(int)m_removeCheck.GetCheck());
    AfxGetApp()->WriteProfileInt("WLAN", "eject",(int)m_ejectCheck.GetCheck());
    AfxGetApp()->WriteProfileInt("WLAN", "unsafe",(int)m_unsafeCheck.GetCheck());
    AfxGetApp()->WriteProfileInt("WLAN", "telnet",(int)m_telnetCheck.GetCheck());
    strcpy(config->teamIdentifierBlue,m_teamBlueEdit.GetBuffer(16));
    strcpy(config->teamIdentifierRed,m_teamRedEdit.GetBuffer(16));
  }
  CDialog::OnOK();
}


void CWLANConfigurationDialog::OnUpdate()
{
  bool isUpdate = m_updateCheck.GetCheck() != 0;
  m_removeCheck.EnableWindow(!isUpdate);
  m_isERS7.EnableWindow(!isUpdate);
  m_isERS210.EnableWindow(!isUpdate);
  m_unsafeCheck.EnableWindow(!isUpdate);
  m_telnetCheck.EnableWindow(!isUpdate);
}


void CWLANConfigurationDialog::OnOneButtonCopy() 
{
  unsigned long ip; 

  switch(m_whichToCopyTo.GetCurSel())
  {
    case 0: m_ipRed1.GetAddress(ip); break;
    case 1: m_ipRed2.GetAddress(ip); break;
    case 2: m_ipRed3.GetAddress(ip); break;
    case 3: m_ipRed4.GetAddress(ip); break;
    case 4: m_ipBlue1.GetAddress(ip); break;
    case 5: m_ipBlue2.GetAddress(ip); break;
    case 6: m_ipBlue3.GetAddress(ip); break;
    case 7: m_ipBlue4.GetAddress(ip); break;
  }
  OnCopy(
     m_whichToCopyTo.GetCurSel() <= 3,
    (m_whichToCopyTo.GetCurSel()%4)+1,
    ip
  );
}
 

CString CWLANConfigurationDialog::IPToStr(unsigned long ip)
{
  CString s; s.Format(
    "%d.%d.%d.%d",
    (ip>>24), ((ip>>16)&0xff), ((ip>>8)&0xff), (ip&0xff)
  );
  return s;
}


void CWLANConfigurationDialog::OnCopy(bool red, int number, unsigned long ip)
{
  UpdateData();
  
  unsigned long netmask;
  CString channel, apmode, essid, wepkey;
  
  if (red) {
    m_channelRedEdit.GetLBText(m_channelRedEdit.GetCurSel(), channel);
    m_apmodeRedEdit.GetLBText(m_apmodeRedEdit.GetCurSel(), apmode);
    m_netmaskRed.GetAddress(netmask);
    essid  = m_essidRedEdit;
    wepkey = m_wepkeyRedEdit;
  } else {
    m_channelBlueEdit.GetLBText(m_channelBlueEdit.GetCurSel(), channel);
    m_apmodeBlueEdit.GetLBText(m_apmodeBlueEdit.GetCurSel(), apmode);
    m_netmaskBlue.GetAddress(netmask);
    essid  = m_essidBlueEdit;
    wepkey = m_wepkeyBlueEdit;
  }

  OutTextRawFile("player.cfg")
    << "teamColor " << Player::getTeamColorName(red?Player::red:Player::blue) << "\r\n"
    << "playerNumber " << Player::getPlayerNumberName((Player::playerNumber)(number-1)) << "\r\n"
    << "teamIdentifier " << (red ? config->teamIdentifierRed : config->teamIdentifierBlue) << "\r\n";

  OutTextRawFile("wlanconf.txt")
    << "HOSTNAME=AIBO"  << (ip & 0xff)      << "\r\n"
    << "ETHER_IP="      << IPToStr(ip)      << "\r\n"
    << "ETHER_NETMASK=" << IPToStr(netmask) << "\r\n"
    << "IP_GATEWAY="    << IPToStr(ip)      << "\r\n"
    << "ESSID="         << essid            << "\r\n"
    << "WEPENABLE="     << (wepkey!="")     << "\r\n"
    << "WEPKEY="        << wepkey           << "\r\n"
    << "APMODE="        << apmode           << "\r\n"
    << "CHANNEL="       << channel          << "\r\n";
  
  getQueues().toGUI.out.text 
    << "PlayerConfig " 
    << Player::getTeamColorName(red ? Player::red : Player::blue)
    << Player::getPlayerNumberName((Player::playerNumber)(number-1))
    << " saved to " << File::getGTDir() << "/Config/player.cfg\r\n"
    << File::getGTDir() << "/Config/wlanconf.txt created!";
  getQueues().toGUI.out.finishMessage(idText);

  _flushall(); // just for safety. see system()
  system(
    CString("bash ")
    + File::getGTDir() + "/Make/copyfiles.bash --pause -d "
    + File::getGTDir() + " " 
    + (m_updateCheck.GetCheck() ? "--update "   : "")
    + (m_removeCheck.GetCheck() && !m_updateCheck.GetCheck() ? "--rm "       : "")
    + (m_ejectCheck.GetCheck()  ? "--eject "    : "")
    + (m_unsafeCheck.GetCheck() ? "--unsafe "   : "")
    + (m_telnetCheck.GetCheck() ? "--wconsole " : "")
    + (m_isERS7.GetCheck()      ? "ERS7 "       : "ERS210 ")
  );
}

void CWLANConfigurationDialog::setWLANConfiguration(CRobotControlWLANConfiguration* externConfig)
{
  config=externConfig;
}

/*
* Change log :
* 
* $Log: WLANConfigurationDialog.cpp,v $
* Revision 1.4  2004/06/27 22:30:12  thomas
* modified wlan-dialog
* - save-dialog back to save&close
* ** this should stay so until correct storing of profile is achived **
*
* Revision 1.3  2004/06/16 13:06:33  dueffert
* usability of WLANConfigurationDialog improved
*
* Revision 1.2  2004/05/26 14:50:53  kindler
* Don't do "--rm" when "--update" is selected.
*
* Revision 1.1.1.1  2004/05/22 17:28:26  cvsadm
* created new repository GT2004_WM
*
* Revision 1.16  2004/04/08 15:33:08  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.16  2004/03/29 17:02:57  pg_thki
* - --unsafe, --ers7 and --rm buttons are disabled when update is checked.
*
* Revision 1.15  2004/03/24 00:06:03  pg_thki
* - added unsafe and telnet options
*
* Revision 1.14  2004/03/16 14:54:51  dueffert
* copyfiles options usable in dialog now
*
* Revision 1.13  2004/02/02 15:15:53  jhoffman
* UI improvements, user feedback integrated
*
* Revision 1.12  2004/01/29 23:42:31  kindler
* Fixed ERS7/210 radio buttons (using the official button-group way)
*
* Revision 1.10  2004/01/29 22:32:19  kindler
* Cleaned up the OnCopy() method, and tried out the 
* brand new shiny OutTextRawFile-Class. I love it.
*
* Revision 1.9  2004/01/29 18:09:17  kindler
* PlayerNumber bug fixed (now for real ;).
*
* Revision 1.8  2004/01/29 18:01:03  kindler
* PlayerNumber bug fixed.
*
* Revision 1.7  2004/01/29 12:03:24  jhoffman
* UI changes:
* - Main menu entries renamed, reordered, added some new icons
* - delete-confirmation in settings and WLAN dialog
* - settings dialog uses icons, radio buttons added
* - WLAN dialog restructured
* - motion tester and head motion tested layout improved, stop button added
* - check boxes replaced by radio buttons where appropriate
*
* Revision 1.6  2004/01/27 23:20:23  wachter
* Added  teamIdentifier to WLANConfigurationDialog
*
* Revision 1.5  2004/01/14 15:33:36  juengel
* state of ers7-chek is stored in registry now
*
* Revision 1.4  2004/01/14 14:43:29  juengel
* state of ers7-chek is stored in registry now
*
* Revision 1.3  2004/01/12 11:30:52  juengel
* Added checkBox "ERS7" to WLANConfigurationDialog.
*
* Revision 1.2  2004/01/03 19:16:29  wachter
* - Debug-communication without router working now
* - Router-IP not longer needed
*
* Revision 1.1  2003/12/14 14:24:34  loetzsch
* renamed WLANNewDialog to WLANConfigurationDialog
*
* Revision 1.5  2003/12/13 11:32:06  loetzsch
* renamed WLANConfiguration to CRobotControlWLANConfiguration
* and moved to RobotControlPhysicalRobots.h
*
* Revision 1.4  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.3  2003/11/30 01:53:20  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.2  2003/10/12 20:18:54  juengel
* GTDIR is passed tp copyfiles.bash
*
* Revision 1.1  2003/10/07 10:09:39  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/07/05 22:06:24  risler
* bugfix: update before cp
*
* Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.7  2003/06/23 12:05:41  dueffert
* copy does WYSIWYG now, initialization added
*
* Revision 1.6  2003/05/11 23:39:24  dueffert
* Depend now works with RobotControl too
*
* Revision 1.5  2003/03/23 19:11:50  loetzsch
* OUTPUT not allowed in the RobotControl thread anymore.
* Use getQueues().toGUI.out instead.
*
* Revision 1.4  2003/03/19 09:23:23  dueffert
* team wlan support improved
*
* Revision 1.3  2003/03/13 16:39:47  dueffert
* wlan toolbar can handle teams now
*
* Revision 1.2  2002/09/22 13:46:09  dueffert
* direct wlan removed (still in code as comments)
*
* Revision 1.1  2002/09/10 15:49:06  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.4  2002/06/20 23:38:48  dueffert
* player toolbar & wlan toolbar completed
*
* Revision 1.3  2002/06/09 08:56:59  dueffert
* complete wlan config nearly completed
*
* Revision 1.2  2002/06/08 13:48:17  dueffert
* further wlan config functionality added
*
* Revision 1.1.1.1  2002/05/10 12:40:22  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.5  2002/04/16 16:15:32  dueffert
* no message
*
* Revision 1.3  2002/04/13 15:57:57  dueffert
* player - wlan synchronisation completed
*
* Revision 1.2  2002/04/13 13:55:46  dueffert
* PlayersToolbar & WLANConfigurationDialog synchronized
*
* Revision 1.4  2002/02/21 10:37:32  risler
* removed strange bug with m_useRouter
*
* Revision 1.3  2002/02/20 16:08:12  dueffert
* direct wlan connection added, not fully functional yet
*
* Revision 1.2  2002/02/05 03:44:59  loetzsch
* #include "StdAfx.h" eingebaut, damit die Datei nicht so oft kompiliert wird
*
* Revision 1.1  2002/01/24 22:57:22  risler
* finished WLAN Toolbar
*
*
*/

