/**
* @file SplashScreenDlg.cpp
*
* Implementation of class CSplashScreenDlg
*
* @author Martin Ltzsch
*/

#include "StdAfx.h"
#include "SplashScreenDlg.h"


CSplashScreenDlg::CSplashScreenDlg(CWnd* pParent /*=NULL*/)
: CDialog(CSplashScreenDlg::IDD, pParent)
{
  //{{AFX_DATA_INIT(CSplashScreenDlg)
  //}}AFX_DATA_INIT
}


void CSplashScreenDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CSplashScreenDlg)
  DDX_Control(pDX, IDC_SPLASH_SCREEN_BITMAP, m_bitmapStatic);
  DDX_Control(pDX, IDC_SPLASH_SCREEN_CONFIGURATION, m_configurationStatic);
  DDX_Control(pDX, IDC_SPLASH_SCREEN_MESSAGE, m_messageStatic);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSplashScreenDlg, CDialog)
  //{{AFX_MSG_MAP(CSplashScreenDlg)
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CSplashScreenDlg::OnInitDialog() 
{
  CDialog::OnInitDialog();

  smallFont.CreateFont(14,0,0,0,FW_NORMAL,FALSE,FALSE,0,ANSI_CHARSET,
    OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    DEFAULT_PITCH | FF_SWISS,"Arial");

  // resize dialog to match the bitmap's dimensions
  // (for non-96 DPI Displays)
  CRect rect;
  m_bitmapStatic.GetWindowRect(&rect);
  SetWindowPos(0, 0, 0, rect.Width(), rect.Height()+40, SWP_NOMOVE | SWP_NOZORDER);
 
  m_configurationStatic.SetWindowPos(0, 5, rect.Height()+5, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
  m_configurationStatic.SetFont(&smallFont);

  m_messageStatic.SetWindowPos(0, 5, rect.Height()+20, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
  m_messageStatic.SetFont(&smallFont);

  m_configurationStatic.SetWindowText(CString("Process Layout: ") + CString(LAYOUT));

  return TRUE;
}

void CSplashScreenDlg::setMessage(CString message)
{
  m_messageStatic.SetWindowText(message);

  RedrawWindow(NULL,NULL,RDW_UPDATENOW);
}

/*
* Change log :
* 
* $Log: SplashScreenDlg.cpp,v $
* Revision 1.2  2004/06/16 15:09:24  kindler
* - Fixed splash screen layout for non-96 DPI displays
*
* Revision 1.1.1.1  2004/05/22 17:28:25  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2003/12/31 13:24:30  loetzsch
* another splash screen version
*
* Revision 1.3  2003/12/18 15:03:24  jhoffman
* changed wording: rc configuration -> robotcontrol process layout
*
* Revision 1.2  2003/12/18 13:54:22  jhoffman
* fixed font size for splash screen
*
* Revision 1.1  2003/12/15 13:05:04  loetzsch
* RobotControl now displays a splash screen at the beginning
*
*/
