/**
 *  @file HSIColorTableToolZoomDlg.h
 *  Declaration of class HSIColorTableToolZoomDlg.
 *  @author<A href=mailto:kspiess@informatik.uni-bremen.de>Kai Spiess</A>
 */
#ifndef __HSIColorTableToolZoomedDlg_h
#define __HSIColorTableToolZoomedDlg_h

#include "StdAfx.h"
#include "resource.h"
#include "HSITools/HSIColorTableToolCore.h"

/** A constant for enlarging a color class range. */
static const int GROW = 1;
/** A constant for reducing a color class range. */
static const int SHRINK = 2;

/**
 *  @class HSIColorTableToolZoomDlg
 *  A dialog with a zoomes RGB- and the color classified image, where the range of a 
 *  selected color class can be modified by selecting single pixels.
 *  The range will be enlarged or reduced depending on the pressed mouse button, so 
 *  that the HSI color of the selected pixel lies inside/outside this range. 
 *  It has a multiple undo function.
 *  
 *  @author Kai Spiess
 */
class HSIColorTableToolZoomDlg : public CDialog
{
public:
  /** Edits an HSI color range for a selected pixel in the zoomed image.
   *  @param nFlags The flags of the pressed mouse button.
   *  @param point The point in the dialog where the mouse button has been pressed.
   *  @param editType The type of modifiing the color range.
   */
  void editHSIColorRange(UINT nFlags, CPoint point, int editType);
  /** This sets the a pointer to the core of the HSI color table tool for this dialog.
   *  @param hsiToolCore The pointer to cor of the HSI color table tool.
   */
	void setHSIToolCore(HSIColorTableToolCore* hsiToolCore);

  /** The color chooser for color classes.*/
	int m_choosenColor;
  /** The pointer to the cor of the HSI color table tool.*/
	HSIColorTableToolCore* m_hsiToolCore;
  /** The height of the source image.*/
  int m_sourceImageHeight;
  /** The width of the source image.*/
	int m_sourceImageWidth;
  /** The height of the zoomed image.*/
	int m_zoomedImageHeight;
  /** The width of the zoomed image.*/
	int m_zoomedImageWidth;
  /** The position of the upper left point of the color classified image. */
	CPoint m_segmentedImagePlace;
  /** The position of the upper left point of the RGB image. */
	CPoint m_rgbImagePlace;
  /** The index of the zoomed image in the main dialg. */
	int m_indexOfZoomedImage;
  /** Default constructor*/
	HSIColorTableToolZoomDlg(CWnd* pParent = NULL);

	//{{AFX_DATA(HSIColorTableToolZoomDlg)
	enum { IDD = IDD_DIALOG_HSICOLORTABLETOOL_ZOOM };
	CComboBox	m_colorChooser;
	CButton	m_undoButton;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(HSIColorTableToolZoomDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(HSIColorTableToolZoomDlg)
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSelchangeHsicolortabletoolZoomColorchooser();
	virtual BOOL OnInitDialog();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnClose();
	afx_msg void OnHsicolortabletoolZoomUndoButton();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif //__HSIColorTableToolZoomDlg_h

/*
 * Change log :
 * 
 * $Log: HSIColorTableToolZoomDlg.h,v $
 * Revision 1.1.1.1  2004/05/22 17:28:25  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:09:39  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/05/11 23:39:24  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.4  2002/12/18 16:22:56  dueffert
 * doxygen docu corrected
 *
 * Revision 1.3  2002/11/20 13:37:30  dueffert
 * missing or wrong doxygen file corrected
 *
 * Revision 1.2  2002/10/01 09:03:17  kspiess
 * fixed click-pixel-routine in zoomed dialog
 *
 * Revision 1.1  2002/09/10 15:49:06  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.4  2002/08/30 17:15:39  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.3  2002/08/29 13:56:27  dueffert
 * includes in correct case, system includes in <>
 *
 * Revision 1.2  2002/07/23 13:44:05  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - new debug message handling
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:22  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2002/04/05 08:18:02  kspiess
 * Fehler beim Anklicken einzelner Pixel im Zoom-Dialog zur Verschiebung
 * der HSI-Grenzen behoben;
 * Fehler beim mehrstufigen Undo behoben
 *
 * Revision 1.2  2002/02/08 14:46:45  kspiess
 * Change log added
 *
 *
 */