/**
 *  @file HSIColorTableToolZoomDlg.cpp
 *  Implementation of class HSIColorTableToolZoomDlg.
 */

#include "StdAfx.h"
#include "HSIColorTableToolZoomDlg.h"

#include "Visualization/ImageMethods.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld HSIColorTableToolZoomDlg 


HSIColorTableToolZoomDlg::HSIColorTableToolZoomDlg(CWnd* pParent /*=NULL*/)
: CDialog(HSIColorTableToolZoomDlg::IDD, pParent)
{
  //{{AFX_DATA_INIT(HSIColorTableToolZoomDlg)
  //}}AFX_DATA_INIT
}


void HSIColorTableToolZoomDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(HSIColorTableToolZoomDlg)
  DDX_Control(pDX, IDC_HSICOLORTABLETOOL_ZOOM_COLORCHOOSER, m_colorChooser);
  DDX_Control(pDX, IDC_HSICOLORTABLETOOL_ZOOM_UNDO_BUTTON, m_undoButton);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(HSIColorTableToolZoomDlg, CDialog)
//{{AFX_MSG_MAP(HSIColorTableToolZoomDlg)
ON_WM_PAINT()
ON_WM_LBUTTONDOWN()
ON_CBN_SELCHANGE(IDC_HSICOLORTABLETOOL_ZOOM_COLORCHOOSER, OnSelchangeHsicolortabletoolZoomColorchooser)
ON_WM_RBUTTONDOWN()
ON_WM_CLOSE()
ON_BN_CLICKED(IDC_HSICOLORTABLETOOL_ZOOM_UNDO_BUTTON, OnHsicolortabletoolZoomUndoButton)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten HSIColorTableToolZoomDlg 

BOOL HSIColorTableToolZoomDlg::OnInitDialog() 
{
  CDialog::OnInitDialog();
  
  this->m_rgbImagePlace.x = 20;
  this->m_rgbImagePlace.y = 30;
  this->m_segmentedImagePlace.x = 410;
  this->m_segmentedImagePlace.y = 30;
  
  this->m_zoomedImageWidth = 352;
  this->m_zoomedImageHeight = 288;
  
  this->m_sourceImageWidth = 176;
  this->m_sourceImageHeight = 144;
  
  this->m_undoButton.EnableWindow(false);
  
  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void HSIColorTableToolZoomDlg::OnPaint() 
{
  CPaintDC dc(this); // device context for painting
  
  //RGB
  ImageMethods::paintImage2CDCAsYUV(dc,
    this->m_hsiToolCore->originalYUVImages[this->m_indexOfZoomedImage],
    CRect(this->m_rgbImagePlace.x,
    this->m_rgbImagePlace.y,
    this->m_rgbImagePlace.x + this->m_zoomedImageWidth,
    this->m_rgbImagePlace.y + this->m_zoomedImageHeight) 
    );
  //ColorClassified
  ImageMethods::paintColorClassImage2CDC(dc, 
    this->m_hsiToolCore->colorClassImages[this->m_indexOfZoomedImage],
    CRect(this->m_segmentedImagePlace.x,
    this->m_segmentedImagePlace.y, 
    this->m_segmentedImagePlace.x + this->m_zoomedImageWidth,
    this->m_segmentedImagePlace .y+ this->m_zoomedImageHeight)
    );
  
  
  // Kein Aufruf von CDialog::OnPaint() fr Zeichnungsnachrichten
}

void HSIColorTableToolZoomDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
  this->editHSIColorRange(nFlags, point, GROW);
  CDialog::OnLButtonDown(nFlags, point);
}

void HSIColorTableToolZoomDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
  this->editHSIColorRange(nFlags, point, SHRINK);
  CDialog::OnRButtonDown(nFlags, point);
}

void HSIColorTableToolZoomDlg::OnSelchangeHsicolortabletoolZoomColorchooser() 
{
  this->m_choosenColor = this->m_colorChooser.GetCurSel();
}

void HSIColorTableToolZoomDlg::setHSIToolCore(HSIColorTableToolCore* hsiToolCore)
{
  this->m_hsiToolCore = hsiToolCore;
}

void HSIColorTableToolZoomDlg::OnClose() 
{
  this->DestroyWindow();
  
  CDialog::OnClose();
}

void HSIColorTableToolZoomDlg::editHSIColorRange(UINT nFlags, CPoint point, int editType)
{
  CPoint clickedImagePoint;
  clickedImagePoint.x = -1;
  clickedImagePoint.y = -1;
  
  if(point.x >= this->m_rgbImagePlace.x && point.x <= (this->m_rgbImagePlace.x + this->m_zoomedImageWidth)
    && point.y >= this->m_rgbImagePlace.y && point.y <= (this->m_rgbImagePlace.y + this->m_zoomedImageHeight))
  {
    clickedImagePoint.x = ((point.x - this->m_rgbImagePlace.x) / 2);
    clickedImagePoint.y = ((point.y - this->m_rgbImagePlace.y) / 2);
  }
  if(point.x >= this->m_segmentedImagePlace.x && point.x <= (this->m_segmentedImagePlace.x + this->m_zoomedImageWidth)
    && point.y >= this->m_segmentedImagePlace.y && point.y <= (this->m_segmentedImagePlace.y + this->m_zoomedImageHeight))
  {
    clickedImagePoint.x = ((point.x - this->m_segmentedImagePlace.x) / 2);
    clickedImagePoint.y = ((point.y - this->m_segmentedImagePlace.y) / 2);
  }
  
  if((clickedImagePoint.x != -1) && (clickedImagePoint.y != -1))
  {
    this->m_undoButton.EnableWindow(true);
    
    int h,s,i, colorClass;
    
    colorClass = this->m_colorChooser.GetCurSel();
    h = this->m_hsiToolCore->hsiImages[0].image[clickedImagePoint.x][0][clickedImagePoint.y];
    s = this->m_hsiToolCore->hsiImages[0].image[clickedImagePoint.x][1][clickedImagePoint.y];
    i = this->m_hsiToolCore->hsiImages[0].image[clickedImagePoint.x][2][clickedImagePoint.y];
    if(clickedImagePoint.x >= 0 && clickedImagePoint.y >= 0 
      && clickedImagePoint.x < this->m_sourceImageWidth 
      && clickedImagePoint.y < this->m_sourceImageHeight)
    {
      if(editType == GROW)
      {
        this->m_hsiToolCore->growHSIColorRange(h,s,i, colorClass);
      }
      else if(editType == SHRINK)
      {
        this->m_hsiToolCore->shrinkHSIColorRange(h,s,i, colorClass);
      }
      
      this->m_hsiToolCore->doImageSegmentation();
    }
    
  }
  Invalidate(false);
  CWnd* test = this->GetOwner();
}

void HSIColorTableToolZoomDlg::OnHsicolortabletoolZoomUndoButton() 
{
  this->m_hsiToolCore->undoEditHSIColorRange();
  if(this->m_hsiToolCore->numberOfUndos ==0)
    this->m_undoButton.EnableWindow(false);
  Invalidate(false);
}


/*
* Change log :
* 
* $Log: HSIColorTableToolZoomDlg.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:28:25  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/05/01 17:09:33  roefer
* Streamlined HSI stuff
*
* Revision 1.2  2004/01/17 17:07:41  roefer
* HSI-Toolbar does not crash anymore, but image size is still 176x144
*
* Revision 1.1  2003/10/07 10:09:39  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 11:40:13  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/11 23:39:23  dueffert
* Depend now works with RobotControl too
*
* Revision 1.4  2003/03/23 19:11:50  loetzsch
* OUTPUT not allowed in the RobotControl thread anymore.
* Use getQueues().toGUI.out instead.
*
* Revision 1.3  2002/11/21 16:08:40  dueffert
* doxygen comments corrected
*
* Revision 1.2  2002/10/01 09:03:17  kspiess
* fixed click-pixel-routine in zoomed dialog
*
* Revision 1.1  2002/09/10 15:49:06  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.2  2002/07/23 13:44:05  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - new debug message handling
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.1.1.1  2002/05/10 12:40:22  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.5  2002/04/05 08:18:02  kspiess
* Fehler beim Anklicken einzelner Pixel im Zoom-Dialog zur Verschiebung
* der HSI-Grenzen behoben;
* Fehler beim mehrstufigen Undo behoben
*
* Revision 1.3  2002/02/11 00:53:33  loetzsch
* ::Paint Methoden in ::paint umbenannt
*
* Revision 1.2  2002/02/08 14:46:45  kspiess
* Change log added
*
*
*/