/**
* @file AboutDlg.cpp
*
* implementation of class CAboutDlg
*
* @author Uwe Dffert
*/

#include "StdAfx.h"
#include "AboutDlg.h"


CAboutDlg::CAboutDlg(CWnd* pParent /*=NULL*/)
: CDialog(CAboutDlg::IDD, pParent)
{
  //{{AFX_DATA_INIT(CAboutDlg)
  //}}AFX_DATA_INIT
}


void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CAboutDlg)
  DDX_Control(pDX, IDC_DISCLAIMER, m_disclaimerEdit);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
//{{AFX_MSG_MAP(CAboutDlg)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CAboutDlg::OnInitDialog() 
{
  CDialog::OnInitDialog();

  char* s=0;
  DWORD dwSize;

  HMODULE hModule = AfxGetResourceHandle();
  HRSRC hRsrc = ::FindResource(hModule, MAKEINTRESOURCE(IDR_LICENCE), RT_HTML);
  if (hRsrc)
  {
    dwSize = ::SizeofResource(hModule, hRsrc); 
    HGLOBAL hGlobal = ::LoadResource(AfxGetResourceHandle(), hRsrc);

    if (hGlobal)
    {
      s = new char[dwSize + 1];
      char* pszResource = (char*) ::LockResource(hGlobal);
      if (pszResource)
      {
        strncpy(s, pszResource, dwSize);
        s[dwSize] = _T('\0');
      }
      else
        TRACE(_T("Failed to load HTML resource, GetLastError:%d\n"), GetLastError());
    }
  }
  m_disclaimerEdit.SetWindowText(s);

  if(s) delete s;
  return TRUE;
}

/*
* Change log :
* 
* $Log: AboutDlg.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:28:24  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2003/12/09 18:18:17  loetzsch
* just touching this file as i changed the ID for this dialog in resource.h
* Enforces recompiling of this file
*
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:06:13  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/05/11 23:39:23  dueffert
* Depend now works with RobotControl too
*
* Revision 1.1  2002/09/10 15:49:06  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.3  2002/09/01 19:54:18  loetzsch
* removed memory leaks
*
* Revision 1.2  2002/09/01 17:21:36  loetzsch
* beautified About dialog
*
* Revision 1.1  2002/08/30 21:11:15  dueffert
* AboutDlg added
*
*/
