/**
* @file Xabsl2DlgBar.h
*
* Declaration of class CXabsl2DlgBar
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
* @author <a href="mailto:loetzsch@informatik.hu-berlin.de">Martin Ltzsch</a>
*/

#ifndef __Xabsl2DlgBar_h_
#define __Xabsl2DlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "Tools/Module/SolutionRequest.h"

/**
* @class CXabsl2DlgBar 
* 
* A dialog bar to test and debug behavior that was developed with Xabsl2
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
* @author <a href="mailto:loetzsch@informatik.hu-berlin.de">Martin Ltzsch</a>
*/
class CXabsl2DlgBar : public CRobotControlDialogBar
{
public:
  /**
  * Default constructor.
  */
  CXabsl2DlgBar();

  ~CXabsl2DlgBar();

	//{{AFX_DATA(CXabsl2DlgBar)
	enum { IDD = IDD_DIALOG_BAR_XABSL2 };
	CButton	m_testHeadControlCheck;
	CButton	m_TestOnRobotCheck;
	CButton	m_SendButton;
	CStatic	m_ParameterStatic;
	CEdit	m_Param5Edit;
	CEdit	m_Param4Edit;
	CEdit	m_Param3Edit;
	CEdit	m_Param2Edit;
	CEdit	m_Param1Edit;
	CComboBox	m_OutputSymbolValueCombo;
	CComboBox	m_OutputSymbolCombo;
	CComboBox	m_OptionsCombo;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CXabsl2DlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL
  
  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

protected:
  /** the rectangle in the dialog for painting */
  CRect paintRect;

  /** the rectangle in the bitmap for painting */
  CRect currentRect;

  /** An off screen device cotext for painting*/
  CDC dcOffScreen;
  
  /** A bitmap that is selected by dcOffScreen*/
  CBitmap* bmpOffScreen;

  /** The old bitmap that is selected by dcOffScreen at the end to enable
  *   the destruction of bmpOffScreen.
  */
  CBitmap* oldBitmap;


	//{{AFX_MSG(CXabsl2DlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnXabsl2TestOnRobotCheck();
	afx_msg void OnXabsl2SendButton();
	afx_msg void OnSelchangeXabsl2OptionsCombo();
	afx_msg void OnSelchangeXabsl2OutputSymbolCombo();
	afx_msg void OnSelchangeXabsl2OutputSymbolValueCombo();
	afx_msg void OnXabsl2TestHeadcontrolCheck();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();

public:
  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);

private:
  /** Indicates, wether the current selection is an option or a basic behavior*/
  enum {option, basicBehavior, nothing} currentSelection;

  typedef CTypedPtrMap<CMapStringToOb,CString,int> CMapStringToInt;

  CMapStringToInt inputSymbolIndex;
  CMapStringToInt outputSymbolIndex;

  int numberOfInputSymbols;
  int numberOfOutputSymbols;
  int numberOfOptions;
  int numberOfBasicBehaviors;

  int numberOfShownInputAndOutputSymbols;
  int numberOfShownInputSymbols;
  int numberOfShownOutputSymbols;

  CStringArray inputSymbolName;
  CStringArray inputSymbolValue;
  enum InputSymbolType{decimal, boolean, enumerated};
  CArray<InputSymbolType,InputSymbolType> typeOfInputSymbol;
  CArray<bool,bool> showInputSymbol;

  CStringArray outputSymbolName;
  CStringArray outputSymbolValue;
  CArray<bool,bool> showOutputSymbol;

  CArray<int,int> numberOfOutputSymbolAlternatives;
  CArray<CStringArray*,CStringArray*> outputSymbolAlternatives;
  CArray<int,int> selectedOutputSymbolAlternative; //unchanged: -1
 
  CStringArray optionName;
  CArray<int,int> numberOfOptionParameters;
  CArray<CStringArray*,CStringArray*> optionParameterNames;

  CStringArray basicBehaviorName;
  CArray<int,int> numberOfBasicBehaviorParameters;
  CArray<CStringArray*,CStringArray*> basicBehaviorParameterNames;


  SolutionRequest::xabsl2EngineID currentEngineID;

  //option activation Path:
  CString selectedBehaviorControlName;
  CString selectedAgentName;

  int numberOfActiveOptions;
  CStringArray activeOptionName;
  CStringArray activeOptionDurationOfActivation;
  CStringArray activeOptionActiveState;
  CStringArray activeOptionDurationOfStateActivation;
  CArray<int,int> activeOptionNumberOfParameters;
  CStringArray activeOptionParameterName[20];
  CStringArray activeOptionParameterValue[20];

  CString activeBasicBehaviorName;
  CString activeBasicBehaviorDurationOfActivation;
  char activeBasicBehaviorNumberOfParameters;
  CString activeBasicBehaviorParameterName[20];
  CString activeBasicBehaviorParameterValue[20];

  CString generatedAction;

  /** The horizontal spacing of the drawing area.*/
  int horizontalSpacing;

  /** */
  enum FontType{normal, bold, italic};
  
  /** The number of lines (calculated in OnSize)*/
  int numberOfLines;

  /** The heiht of a single line*/
  int lineHeight;

  /** */
  enum{numberOfColumns = 10};

  /** The relative postion of the columns*/
  double leftOfColumnPercent[numberOfColumns];

  /** The position of the columns calculated by OnSize*/
  int leftOfColumnPosition[numberOfColumns];

  void countNumberOfShownInputAndOutputSymbols();

  /** 
  * Draws a text to dcOffScreen.
  * @param fontType The type of the font. (normal, bold, italic)
  * @param line The line to paint to.
  * @param column The column to paint to.
  * @param string The text to paint.
  */
  void drawText(FontType fontType, int line, int column, CString string);

  void drawHorizontalLines();
  CArray<int,int> horizontalLineList;

  void drawVerticalLines();
  struct VerticalLine
  {
    VerticalLine(int column, int begin, int end) : column(column), begin(begin), end(end) {}
    VerticalLine() {}
    int column;
    int begin;
    int end;
  };
  CArray<VerticalLine,VerticalLine> verticalLineList;

  /** 
  * Draws a text to dcOffScreen.
  * @param fontType The type of the font. (normal, bold, italic)
  * @param line The line to paint to.
  * @param x The x position to paint to.
  * @param string The string to paint.
  */
  void drawTextFixedX(FontType fontType, int line, int x, CString string);

  /** creates some Fonts*/
  void createFonts();

  /** deletes the fonts*/
  void deleteFonts();

  /** The old font is selected to the dcOffScreen at the end to 
  *   enable the destruction of the fonts created by create fonts.
  */
  CFont* oldFont;

  /** */
  CFont normalFont;

  /** */
  CFont italicFont;
  
  /** */
  CFont boldFont;

  /** Reloads the debug symbols */
  void reload();

  /** Initializes all variables */
  void clear();

  /** grayes the edit boxes depending on the numbers of parameters*/
  void enableButtons();

  /** sends the debug request to the local Processes or to the robot */
  void sendDebugRequest();

  /** sends the intermediate code to the local Processes or to the robot */
  void sendIntermediateCode();

public:
  bool enableParam1Edit;
  bool enableParam2Edit;
  bool enableParam3Edit;
  bool enableParam4Edit;
  bool enableParam5Edit;
};

//{{AFX_INSERT_LOCATION}}

#endif //__Xabsl2DlgBar_h_

/*
 * Change log :
 * 
 * $Log: Xabsl2DlgBar.h,v $
 * Revision 1.3  2004/05/25 14:40:49  loetzsch
 * bug fix
 *
 * Revision 1.5  2004/05/17 18:35:23  loetzsch
 * continued support for multiple Xabsl engines in different modules
 *
 * Revision 1.4  2004/05/14 11:37:08  loetzsch
 * support for multiple xabsl2engines in different modules
 * preliminary GT2004HeadControl (does not work at all)
 *
 * Revision 1.3  2004/03/16 14:00:23  juengel
 * Integrated Improvments from "Gnne"
 * -ATH2004ERS7Behavior
 * -ATHHeadControl
 * -KickSelectionTable
 * -KickEditor
 *
 * Revision 1.2  2004/03/08 18:59:47  loetzsch
 * now allows for up to 10 option parameters
 *
 * Revision 1.2  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.1  2003/10/07 10:09:39  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.13  2003/05/11 23:46:36  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.12  2003/01/22 13:09:51  juengel
 * reload() is called, if behaviorControlId changes
 * intermediate code is sent, if reload is selected in context menu.
 *
 * Revision 1.11  2003/01/15 10:08:02  juengel
 * Parameters are stored in registry.
 * Added variables for "SetOutputSymbol".
 *
 * Revision 1.10  2003/01/13 18:28:44  juengel
 * Layout changed.
 *
 * Revision 1.9  2003/01/13 10:31:43  juengel
 * XabslDebugMessage extended. Xabsl2Dialog shows option activation path.
 *
 * Revision 1.8  2003/01/11 18:38:38  juengel
 * Xabsl2ehavior sends Xabsl2DebugMessages now.
 *
 * Revision 1.7  2003/01/11 13:29:55  juengel
 * Xabsl2Dialog sends Xabsl2DebugRequest now.
 *
 * Revision 1.6  2003/01/10 15:50:10  juengel
 * Added OptionsCombo to Xabsl2DialogBar
 *
 * Revision 1.5  2003/01/08 18:57:29  juengel
 * Added Controls for the Xabsl2 dialog.
 *
 * Revision 1.4  2002/12/18 16:49:30  dueffert
 * doxygen docu corrected
 *
 * Revision 1.3  2002/12/09 09:50:14  juengel
 * input and output symbols are stored in a CArray now
 *
 * Revision 1.2  2002/12/08 16:18:40  juengel
 * Added method drawText to xabsl2 dialog.
 * Xabsl2 dialog loads and shows input and output symbols.
 * Added context menu for xabsl2 dialog.
 *
 * Revision 1.1  2002/12/06 11:30:13  juengel
 * Added Xabsl2Dlg.
 *
*/
