/**
* @file TimeDiagramDlgBar.h
*
* Declaration of class CTimeDiagramDlgBar
*
* @author Matthias Jngel
* @author Martin Ltzsch
*/

#ifndef __TimeDiagramDlgBar_h_
#define __TimeDiagramDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Tools/Debugging/Stopwatch.h"
#include "Tools/RingBuffer.h"


/**
* @class CTimeDiagramDlgBar 
* 
* A dialog bar to view time diagrams
*/
class CTimeDiagramDlgBar : public CRobotControlDialogBar
{
public:
  /**
  * Default constructor.
  */
  CTimeDiagramDlgBar();

	~CTimeDiagramDlgBar();   
  
  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);

	//{{AFX_DATA(CTimeDiagramDlgBar)
	enum { IDD = IDD_DIALOG_BAR_TIME_DIAGRAM };
	CStatic	m_static1;
	CSliderCtrl	m_averageSlider;
	CComboBox	m_stopCombo;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CTimeDiagramDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CTimeDiagramDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSelchangeStopCombo();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
private:
	void deleteBrushes();
	void createBrushes();

  enum StopMode {displayLogFiles, stopTimesOnRobot, stopTimesLocal} stopMode;

  void saveCurrentSelection();
  void loadSelection();
  void unselectAll();
  void exportToFileAsCSV();
  void calculateAverageValues(Stopwatch::StopwatchEventID stopwatchEventID);

  /** clears all time buffers in the dialog */
  void clearBuffers();  

  //display ////////
  CRect rect;

  CDC dcOffScreen;
  CBitmap* bmpOffScreen;
  CBitmap* oldBitmap;

  CBrush brush[Stopwatch::numberOfStopwatchEventIDs];
  COLORREF crColor[Stopwatch::numberOfStopwatchEventIDs];
  CBrush* oldBrush;

  enum {millisecondsPerView = 100, ringBufferSize = 500};

  /** the range over that average times and average frequencies are calculated */
  int averageRange;

  //selection
  bool showTime[Stopwatch::numberOfStopwatchEventIDs];
  int numberOfSelectedTimes;

  //data
  RingBuffer<unsigned long, ringBufferSize> startTime[Stopwatch::numberOfStopwatchEventIDs];
  RingBuffer<unsigned long, ringBufferSize> measuredTime[Stopwatch::numberOfStopwatchEventIDs];
  RingBuffer<unsigned long, ringBufferSize> counter[Stopwatch::numberOfStopwatchEventIDs];

  double averageMeasuredTime[Stopwatch::numberOfStopwatchEventIDs];
  double averageFrequency[Stopwatch::numberOfStopwatchEventIDs];
  unsigned long maxMeasuredTime[Stopwatch::numberOfStopwatchEventIDs];
  unsigned long minMeasuredTime[Stopwatch::numberOfStopwatchEventIDs];

};

//{{AFX_INSERT_LOCATION}}

#endif //__TimeDiagramDlgBar_h_

/*
 * Change log :
 * 
 * $Log: TimeDiagramDlgBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:28:12  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 11:40:12  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/06/24 08:13:12  dueffert
 * average run time is now %2.1f
 *
 * Revision 1.4  2003/06/22 09:55:12  roefer
 * Stopwatch now RT compatible
 *
 * Revision 1.3  2003/05/11 23:46:35  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2002/09/22 18:40:52  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.4  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.3  2002/08/29 14:39:57  dueffert
 * includes in correct case, system includes in <>
 *
 * Revision 1.2  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.13  2002/04/25 14:50:34  kallnik
 * changed double/float to double
 * added several #include GTMath
 *
 * PLEASE use double
 *
 * Revision 1.12  2002/04/23 17:45:15  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.11  2002/02/27 19:52:49  loetzsch
 * TimeDiagram dialog continued
 *
 * Revision 1.10  2002/02/26 00:00:56  loetzsch
 * Dies & Das
 *
 * Revision 1.9  2002/02/25 20:01:18  loetzsch
 * CSV output
 *
 * Revision 1.8  2002/02/25 19:27:49  juengel
 * no message
 *
 * Revision 1.7  2002/02/25 19:14:36  loetzsch
 * writeAsCSV started
 *
 * Revision 1.6  2002/02/24 10:02:21  juengel
 * TimeDiagramDlgBar completed.
 *
 * Revision 1.5  2002/01/19 08:07:28  juengel
 * stopwatch weiterentwickelt
 *
 * Revision 1.4  2002/01/16 16:34:10  juengel
 * stopwatch eingebaut
 *
 *
 */
