/**
* @file TestDataGeneratorDlgBar.cpp
*
* Implementation of class CTestDataGeneratorDlgBar
*
* @author Matthias Jngel
*/

#include "StdAfx.h"
#include "TestDataGeneratorDlgBar.h"

#include "RobotControlQueues.h"

CTestDataGeneratorDlgBar::CTestDataGeneratorDlgBar()
: CRobotControlDialogBar(IDD)
{
  //{{AFX_DATA_INIT(CTestDataGeneratorDlgBar)
  //}}AFX_DATA_INIT
}

CTestDataGeneratorDlgBar::~CTestDataGeneratorDlgBar()
{
  saveParameters();
}


void CTestDataGeneratorDlgBar::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CTestDataGeneratorDlgBar)
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_A_EDIT, m_descriptionAEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_B_EDIT, m_descriptionBEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_C_EDIT, m_descriptionCEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_D_EDIT, m_descriptionDEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_E_EDIT, m_descriptionEEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_F_EDIT, m_descriptionFEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_G_EDIT, m_descriptionGEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_H_EDIT, m_descriptionHEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_I_EDIT, m_descriptionIEdit);
  DDX_Control(pDX, IDC_TDG_DESCRIPTION_J_EDIT, m_descriptionJEdit);
  DDX_Control(pDX, IDC_TDG_TEST_ON_ROBOT_CHECK, m_testOnRobotCheck);
  DDX_Control(pDX, IDC_TDG_MIN_I_EDIT, m_minIEdit);
  DDX_Control(pDX, IDC_TDG_MIN_J_EDIT, m_minJEdit);
  DDX_Control(pDX, IDC_TDG_MIN_H_EDIT, m_minHEdit);
  DDX_Control(pDX, IDC_TDG_MIN_G_EDIT, m_minGEdit);
  DDX_Control(pDX, IDC_TDG_MIN_F_EDIT, m_minFEdit);
  DDX_Control(pDX, IDC_TDG_MIN_E_EDIT, m_minEEdit);
  DDX_Control(pDX, IDC_TDG_MIN_D_EDIT, m_minDEdit);
  DDX_Control(pDX, IDC_TDG_MIN_C_EDIT, m_minCEdit);
  DDX_Control(pDX, IDC_TDG_MIN_B_EDIT, m_minBEdit);
  DDX_Control(pDX, IDC_TDG_MIN_A_EDIT, m_minAEdit);
  DDX_Control(pDX, IDC_TDG_MAX_J_EDIT, m_maxJEdit);
  DDX_Control(pDX, IDC_TDG_MAX_I_EDIT, m_maxIEdit);
  DDX_Control(pDX, IDC_TDG_MAX_H_EDIT, m_maxHEdit);
  DDX_Control(pDX, IDC_TDG_MAX_G_EDIT, m_maxGEdit);
  DDX_Control(pDX, IDC_TDG_MAX_F_EDIT, m_maxFEdit);
  DDX_Control(pDX, IDC_TDG_MAX_E_EDIT, m_maxEEdit);
  DDX_Control(pDX, IDC_TDG_MAX_D_EDIT, m_maxDEdit);
  DDX_Control(pDX, IDC_TDG_MAX_C_EDIT, m_maxCEdit);
  DDX_Control(pDX, IDC_TDG_MAX_B_EDIT, m_maxBEdit);
  DDX_Control(pDX, IDC_TDG_MAX_A_EDIT, m_maxAEdit);
  DDX_Control(pDX, IDC_TDG_TEST_DATA_SORT_COMBO, m_testDataTypeCombo);
  DDX_Control(pDX, IDC_TDG_SEND_ON_CHANGE_CHECK, m_sendOnChangeCheck);
  DDX_Control(pDX, IDC_TDG_SLIDER10, m_slider10);
  DDX_Control(pDX, IDC_TDG_SLIDER9, m_slider9);
  DDX_Control(pDX, IDC_TDG_SLIDER8, m_slider8);
  DDX_Control(pDX, IDC_TDG_SLIDER7, m_slider7);
  DDX_Control(pDX, IDC_TDG_SLIDER6, m_slider6);
  DDX_Control(pDX, IDC_TDG_SLIDER5, m_slider5);
  DDX_Control(pDX, IDC_TDG_SLIDER4, m_slider4);
  DDX_Control(pDX, IDC_TDG_SLIDER3, m_slider3);
  DDX_Control(pDX, IDC_TDG_SLIDER2, m_slider2);
  DDX_Control(pDX, IDC_TDG_SLIDER1, m_slider1);
  DDX_Control(pDX, IDC_TDG_VALUE_J_EDIT, m_valueJEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_I_EDIT, m_valueIEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_H_EDIT, m_valueHEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_G_EDIT, m_valueGEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_F_EDIT, m_valueFEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_E_EDIT, m_valueEEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_D_EDIT, m_valueDEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_C_EDIT, m_valueCEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_B_EDIT, m_valueBEdit);
  DDX_Control(pDX, IDC_TDG_VALUE_A_EDIT, m_valueAEdit);
  //}}AFX_DATA_MAP
}



BEGIN_MESSAGE_MAP(CTestDataGeneratorDlgBar, CDynamicBarDlg)
//{{AFX_MSG_MAP(CTestDataGeneratorDlgBar)
ON_BN_CLICKED(IDC_TDG_SEND_ON_CHANGE_CHECK, OnSendOnChangeCheck)
ON_BN_CLICKED(IDC_TDG_SEND_BUTTON, OnSendButton)
ON_WM_HSCROLL()
ON_CBN_SELCHANGE(IDC_TDG_TEST_DATA_SORT_COMBO, OnSelchangeTestDataTypeCombo)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_A_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_MAX_A_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_A_EDIT, OnChangeValue)
ON_BN_CLICKED(IDC_TDG_TEST_ON_ROBOT_CHECK, OnTestOnRobotCheck)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_B_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_C_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_D_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_E_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_F_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_G_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_H_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_I_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_DESCRIPTION_J_EDIT, OnChangeDescription)
ON_EN_KILLFOCUS(IDC_TDG_MAX_B_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MAX_C_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MAX_D_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MAX_E_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MAX_F_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MAX_G_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MAX_H_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MAX_I_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MAX_J_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_A_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_B_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_C_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_D_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_E_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_F_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_G_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_H_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_I_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_MIN_J_EDIT, OnChangeMinMax)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_B_EDIT, OnChangeValue)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_C_EDIT, OnChangeValue)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_D_EDIT, OnChangeValue)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_E_EDIT, OnChangeValue)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_F_EDIT, OnChangeValue)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_G_EDIT, OnChangeValue)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_H_EDIT, OnChangeValue)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_I_EDIT, OnChangeValue)
ON_EN_KILLFOCUS(IDC_TDG_VALUE_J_EDIT, OnChangeValue)
ON_BN_CLICKED(IDC_TDG_DEFAULT_BUTTON, OnDefaultButton)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CTestDataGeneratorDlgBar 


BOOL CTestDataGeneratorDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();
  int i;
  for(i = 0; i < TestDataGenerator::numberOfTestDataTypes; i++)
  {
    int index = m_testDataTypeCombo.AddString(
      TestDataGenerator::getTestDataTypeName((enum TestDataGenerator::TestDataType)(i))
      );
    m_testDataTypeCombo.SetItemData(index, (enum TestDataGenerator::TestDataType)i);
  }
  int j;
  for(j = 0; j < GenericDebugData::numOfGenericDebugDataIDs; j++)
  {
    CString string = GenericDebugData::getGenericDebugDateName((GenericDebugData::GenericDebugDataID)(j));
    string.Insert(0, "GenericDebugData - ");
    int index = m_testDataTypeCombo.AddString(string);
    m_testDataTypeCombo.SetItemData(index, j + TestDataGenerator::numberOfTestDataTypes);
  }
  
  m_testDataTypeCombo.SetCurSel(0);
  
  selectedTestDataType =
    (TestDataGenerator::TestDataType)
    m_testDataTypeCombo.GetItemData(m_testDataTypeCombo.GetCurSel());
  
  selectedTestDataType = 
    (TestDataGenerator::TestDataType)AfxGetApp()->GetProfileInt("TestDataGenerator", "selectedTestDataType", 0);
  selectedGenericDebugDataID = 
    (GenericDebugData::GenericDebugDataID)AfxGetApp()->GetProfileInt("TestDataGenerator", "selectedGenericDebugDataID", 0);
  
  if(selectedTestDataType == TestDataGenerator::genericDebugData)
    m_testDataTypeCombo.SetCurSel(selectedGenericDebugDataID + TestDataGenerator::numberOfTestDataTypes);
  else
    m_testDataTypeCombo.SetCurSel(selectedTestDataType);
  
  loadParameters();
  
  m_sendOnChangeCheck.SetCheck(sendOnChange);
  m_testOnRobotCheck.SetCheck(testOnRobot);
  
  setDescription();
  setSliderRanges();
  setSliders();
  
  return true;  
}

void CTestDataGeneratorDlgBar::OnSendOnChangeCheck() 
{
  if(m_sendOnChangeCheck.GetCheck()) sendOnChange = true;
  else sendOnChange = false;
}

void CTestDataGeneratorDlgBar::OnTestOnRobotCheck() 
{
  if(m_testOnRobotCheck.GetCheck())
  {
    testOnRobot = true;
    testLocal = false;
  }
  else 
  {
    testOnRobot = false;
    testLocal = true;
  }
}


void CTestDataGeneratorDlgBar::OnSendButton() 
{
  generateTestData();
}

void CTestDataGeneratorDlgBar::OnDefaultButton() 
{
  for(int i = 0; i < 10; i++)
  {
    if(selectedTestDataType == TestDataGenerator::genericDebugData)
    {
      description[i] = GenericDebugData::getParameterName(selectedGenericDebugDataID,i);
      value[i] = (float)GenericDebugData::getDefaultValue(selectedGenericDebugDataID,i);
      min[i] = (float)GenericDebugData::getMinValue(selectedGenericDebugDataID,i);
      max[i] = (float)GenericDebugData::getMaxValue(selectedGenericDebugDataID,i);
    }
  }
  setDescription();
  setSliderRanges();
  setSliders();
  if(sendOnChange) generateTestData();
}


void CTestDataGeneratorDlgBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  value[0] = (float)(m_slider1.GetPos() / scale[0]);
  value[1] = (float)(m_slider2.GetPos() / scale[1]);
  value[2] = (float)(m_slider3.GetPos() / scale[2]);
  value[3] = (float)(m_slider4.GetPos() / scale[3]);
  value[4] = (float)(m_slider5.GetPos() / scale[4]);
  value[5] = (float)(m_slider6.GetPos() / scale[5]);
  value[6] = (float)(m_slider7.GetPos() / scale[6]);
  value[7] = (float)(m_slider8.GetPos() / scale[7]);
  value[8] = (float)(m_slider9.GetPos() / scale[8]);
  value[9] = (float)(m_slider10.GetPos() / scale[9]);
  
  setSliders();
  if(sendOnChange) generateTestData();
  
  CDynamicBarDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CTestDataGeneratorDlgBar::generateTestData()
{
  GenericDebugData genericDebugData;
  if(selectedTestDataType == TestDataGenerator::genericDebugData)
  {
    genericDebugData.id = selectedGenericDebugDataID;
  }
  else
  {
    genericDebugData.id = GenericDebugData::unknown;
  }
  for(int i = 0; i < 10; i++) genericDebugData.data[i] = value[i];
  
  if(testOnRobot)
    TestDataGenerator::generateTestData(selectedTestDataType, genericDebugData, getQueues().toPhysical.selectedRobot.out);
  if(testLocal)
    TestDataGenerator::generateTestData(selectedTestDataType, genericDebugData, getQueues().toSimulated.selectedRobot.out);
}

void CTestDataGeneratorDlgBar::OnSelchangeTestDataTypeCombo() 
{
  saveParameters();
  
  int index = (int)m_testDataTypeCombo.GetItemData(m_testDataTypeCombo.GetCurSel());
  
  if(index >= TestDataGenerator::numberOfTestDataTypes)
  {
    selectedTestDataType = TestDataGenerator::genericDebugData;
    selectedGenericDebugDataID = (GenericDebugData::GenericDebugDataID)(index - TestDataGenerator::numberOfTestDataTypes);
  }
  else
    selectedTestDataType = (TestDataGenerator::TestDataType)index;
  
  loadParameters();
  
  m_sendOnChangeCheck.SetCheck(sendOnChange);
  m_testOnRobotCheck.SetCheck(testOnRobot);
  
  setDescription();
  setSliderRanges();
  setSliders();
  if(sendOnChange) generateTestData();
}

void CTestDataGeneratorDlgBar::loadParameters()
{
  CString string = "TestDataGenerator\\Parameters\\";
  if(selectedTestDataType == TestDataGenerator::genericDebugData)
    string.Insert(111, GenericDebugData::getGenericDebugDateName(selectedGenericDebugDataID));
  else
    string.Insert(111, TestDataGenerator::getTestDataTypeName(selectedTestDataType));
  
  CString keyString;
  for(int i = 0; i < 10; i++)
  {
    keyString.Format("Param%d",(i+1));
    value[i] = (float)(AfxGetApp()->GetProfileInt(string, keyString, (int)(GenericDebugData::getDefaultValue(selectedGenericDebugDataID,i) * 1000)) / 1000.0);
    keyString.Format("min%d",(i+1));
    min[i] = (float)(AfxGetApp()->GetProfileInt(string, keyString, 0) / 1000.0);
    keyString.Format("max%d",(i+1));
    max[i] = (float)(AfxGetApp()->GetProfileInt(string, keyString, 100000) / 1000.0);
    
    if(selectedTestDataType == TestDataGenerator::genericDebugData)
    {
      description[i] = GenericDebugData::getParameterName(selectedGenericDebugDataID,i);
    }
    else
      description[i] = "";
    
    if(description[i].GetLength() == 0)
    {
      keyString.Format("description%d",(i+1));
      description[i] = AfxGetApp()->GetProfileString(string, keyString, keyString);
      enableDescriptionEdit[i] = true;
    }
    else
    {
      enableDescriptionEdit[i] = false;
    }
  }
  sendOnChange = (AfxGetApp()->GetProfileInt(string, "sendOnChange", 1) == 1);
  testOnRobot = (AfxGetApp()->GetProfileInt(string, "testOnRobot", 0) == 1);
  testLocal = (AfxGetApp()->GetProfileInt(string, "testLocal", 1) == 1);
}

void CTestDataGeneratorDlgBar::saveParameters()
{
  CString string = "TestDataGenerator\\Parameters\\";
  if(selectedTestDataType == TestDataGenerator::genericDebugData)
    string.Insert(111, GenericDebugData::getGenericDebugDateName(selectedGenericDebugDataID));
  else
    string.Insert(111, TestDataGenerator::getTestDataTypeName(selectedTestDataType));
  
  CString keyString;
  for(int i = 0; i < 10; i++)
  {
    keyString.Format("Param%d",(i+1));
    AfxGetApp()->WriteProfileInt(string, keyString, (int)(value[i] * 1000));
    keyString.Format("min%d",(i+1));
    AfxGetApp()->WriteProfileInt(string, keyString, (int)(min[i] * 1000));
    keyString.Format("max%d",(i+1));
    AfxGetApp()->WriteProfileInt(string, keyString, (int)(max[i] * 1000));
    keyString.Format("description%d",(i+1));
    AfxGetApp()->WriteProfileString(string, keyString, description[i]);
  }
  AfxGetApp()->WriteProfileInt(string, "testOnRobot", testOnRobot);
  AfxGetApp()->WriteProfileInt(string, "testLocal", testLocal);
  AfxGetApp()->WriteProfileInt(string, "sendOnChange", sendOnChange);
  AfxGetApp()->WriteProfileInt("TestDataGenerator", "selectedTestDataType", selectedTestDataType);
  AfxGetApp()->WriteProfileInt("TestDataGenerator", "selectedGenericDebugDataID", selectedGenericDebugDataID);
}

void CTestDataGeneratorDlgBar::setSliderRanges()
{
  for(int i = 0; i < 10; i++)
  {
    if(max[i] < min[i]) max[i] = min[i];
    double z = max[i];
    double c = 1 / 1000000.0;
    while (z >= (10 / 1000000.0))
    {
      z /= 10.0;
      c *= 10;
    }
    scale[i] = 100.0 / c;
    if(value[i] > max[i]) value[i] = max[i];
    if(value[i] < min[i]) value[i] = min[i];
  }
  
  m_slider1.SetRange((int)(min[0]*scale[0]),(int)(max[0]*scale[0]));
  m_slider2.SetRange((int)(min[1]*scale[1]),(int)(max[1]*scale[1]));
  m_slider3.SetRange((int)(min[2]*scale[2]),(int)(max[2]*scale[2]));
  m_slider4.SetRange((int)(min[3]*scale[3]),(int)(max[3]*scale[3]));
  m_slider5.SetRange((int)(min[4]*scale[4]),(int)(max[4]*scale[4]));
  m_slider6.SetRange((int)(min[5]*scale[5]),(int)(max[5]*scale[5]));
  m_slider7.SetRange((int)(min[6]*scale[6]),(int)(max[6]*scale[6]));
  m_slider8.SetRange((int)(min[7]*scale[7]),(int)(max[7]*scale[7]));
  m_slider9.SetRange((int)(min[8]*scale[8]),(int)(max[8]*scale[8]));
  m_slider10.SetRange((int)(min[9]*scale[9]),(int)(max[9]*scale[9]));
}

void CTestDataGeneratorDlgBar::setDescription()
{
  m_descriptionAEdit.SetWindowText(description[0]);
  m_descriptionBEdit.SetWindowText(description[1]);
  m_descriptionCEdit.SetWindowText(description[2]);
  m_descriptionDEdit.SetWindowText(description[3]);
  m_descriptionEEdit.SetWindowText(description[4]);
  m_descriptionFEdit.SetWindowText(description[5]);
  m_descriptionGEdit.SetWindowText(description[6]);
  m_descriptionHEdit.SetWindowText(description[7]);
  m_descriptionIEdit.SetWindowText(description[8]);
  m_descriptionJEdit.SetWindowText(description[9]);
}

void CTestDataGeneratorDlgBar::setSliders()
{
  m_slider1.SetPos((int)(value[0] * scale[0] * 1.001));
  m_slider2.SetPos((int)(value[1] * scale[1] * 1.001));
  m_slider3.SetPos((int)(value[2] * scale[2] * 1.001));
  m_slider4.SetPos((int)(value[3] * scale[3] * 1.001));
  m_slider5.SetPos((int)(value[4] * scale[4] * 1.001));
  m_slider6.SetPos((int)(value[5] * scale[5] * 1.001));
  m_slider7.SetPos((int)(value[6] * scale[6] * 1.001));
  m_slider8.SetPos((int)(value[7] * scale[7] * 1.001));
  m_slider9.SetPos((int)(value[8] * scale[8] * 1.001));
  m_slider10.SetPos((int)(value[9] * scale[9] * 1.001));
  
  CString string;
  string.Format("%.3f", value[0]);
  m_valueAEdit.SetWindowText(string);
  
  string.Format("%.3f", value[1]);
  m_valueBEdit.SetWindowText(string);
  
  string.Format("%.3f", value[2]);
  m_valueCEdit.SetWindowText(string);
  
  string.Format("%.3f", value[3]);
  m_valueDEdit.SetWindowText(string);
  
  string.Format("%.3f", value[4]);
  m_valueEEdit.SetWindowText(string);
  
  string.Format("%.3f", value[5]);
  m_valueFEdit.SetWindowText(string);
  
  string.Format("%.3f", value[6]);
  m_valueGEdit.SetWindowText(string);
  
  string.Format("%.3f", value[7]);
  m_valueHEdit.SetWindowText(string);
  
  string.Format("%.3f", value[8]);
  m_valueIEdit.SetWindowText(string);
  
  string.Format("%.3f", value[9]);
  m_valueJEdit.SetWindowText(string);
  
  
  CString minString[10], maxString[10];
  for(int i = 0; i < 10; i++)
  {
    minString[i].Format("%.3f", min[i]);
    maxString[i].Format("%.3f", max[i]);
  }
  m_minAEdit.SetWindowText(minString[0]);
  m_maxAEdit.SetWindowText(maxString[0]);
  m_minBEdit.SetWindowText(minString[1]);
  m_maxBEdit.SetWindowText(maxString[1]);
  m_minCEdit.SetWindowText(minString[2]);
  m_maxCEdit.SetWindowText(maxString[2]);
  m_minDEdit.SetWindowText(minString[3]);
  m_maxDEdit.SetWindowText(maxString[3]);
  m_minEEdit.SetWindowText(minString[4]);
  m_maxEEdit.SetWindowText(maxString[4]);
  m_minFEdit.SetWindowText(minString[5]);
  m_maxFEdit.SetWindowText(maxString[5]);
  m_minGEdit.SetWindowText(minString[6]);
  m_maxGEdit.SetWindowText(maxString[6]);
  m_minHEdit.SetWindowText(minString[7]);
  m_maxHEdit.SetWindowText(maxString[7]);
  m_minIEdit.SetWindowText(minString[8]);
  m_maxIEdit.SetWindowText(maxString[8]);
  m_minJEdit.SetWindowText(minString[9]);
  m_maxJEdit.SetWindowText(maxString[9]);
}

void CTestDataGeneratorDlgBar::OnChangeValue()
{
  CString valueString[10];
  m_valueAEdit.GetWindowText(valueString[0]);
  m_valueBEdit.GetWindowText(valueString[1]);
  m_valueCEdit.GetWindowText(valueString[2]);
  m_valueDEdit.GetWindowText(valueString[3]);
  m_valueEEdit.GetWindowText(valueString[4]);
  m_valueFEdit.GetWindowText(valueString[5]);
  m_valueGEdit.GetWindowText(valueString[6]);
  m_valueHEdit.GetWindowText(valueString[7]);
  m_valueIEdit.GetWindowText(valueString[8]);
  m_valueJEdit.GetWindowText(valueString[9]);
  
  for(int i = 0; i < 10; i++)
  {
    sscanf(valueString[i].GetBuffer(valueString[i].GetLength()), "%f", &(value[i]));
    if(value[i] > max[i]) value[i] = max[i];
    if(value[i] < min[i]) value[i] = min[i];
  }
  setSliders();
  if(sendOnChange) generateTestData();
}

void CTestDataGeneratorDlgBar::OnChangeDescription()
{
  m_descriptionAEdit.GetWindowText(description[0]);
  m_descriptionBEdit.GetWindowText(description[1]);
  m_descriptionCEdit.GetWindowText(description[2]);
  m_descriptionDEdit.GetWindowText(description[3]);
  m_descriptionEEdit.GetWindowText(description[4]);
  m_descriptionFEdit.GetWindowText(description[5]);
  m_descriptionGEdit.GetWindowText(description[6]);
  m_descriptionHEdit.GetWindowText(description[7]);
  m_descriptionIEdit.GetWindowText(description[8]);
  m_descriptionJEdit.GetWindowText(description[9]);
}

void CTestDataGeneratorDlgBar::OnChangeMinMax()
{
  CString minString[10], maxString[10];
  
  m_maxAEdit.GetWindowText(maxString[0]);
  m_minAEdit.GetWindowText(minString[0]);
  m_maxBEdit.GetWindowText(maxString[1]);
  m_minBEdit.GetWindowText(minString[1]);
  m_maxCEdit.GetWindowText(maxString[2]);
  m_minCEdit.GetWindowText(minString[2]);
  m_maxDEdit.GetWindowText(maxString[3]);
  m_minDEdit.GetWindowText(minString[3]);
  m_maxEEdit.GetWindowText(maxString[4]);
  m_minEEdit.GetWindowText(minString[4]);
  m_maxFEdit.GetWindowText(maxString[5]);
  m_minFEdit.GetWindowText(minString[5]);
  m_maxGEdit.GetWindowText(maxString[6]);
  m_minGEdit.GetWindowText(minString[6]);
  m_maxHEdit.GetWindowText(maxString[7]);
  m_minHEdit.GetWindowText(minString[7]);
  m_maxIEdit.GetWindowText(maxString[8]);
  m_minIEdit.GetWindowText(minString[8]);
  m_maxJEdit.GetWindowText(maxString[9]);
  m_minJEdit.GetWindowText(minString[9]);
  
  sscanf(minString[0].GetBuffer(minString[0].GetLength()), "%f", &(min[0]));
  sscanf(maxString[0].GetBuffer(maxString[0].GetLength()), "%f", &(max[0]));
  sscanf(minString[1].GetBuffer(minString[1].GetLength()), "%f", &(min[1]));
  sscanf(maxString[1].GetBuffer(maxString[1].GetLength()), "%f", &(max[1]));
  sscanf(minString[2].GetBuffer(minString[2].GetLength()), "%f", &(min[2]));
  sscanf(maxString[2].GetBuffer(maxString[2].GetLength()), "%f", &(max[2]));
  sscanf(minString[3].GetBuffer(minString[3].GetLength()), "%f", &(min[3]));
  sscanf(maxString[3].GetBuffer(maxString[3].GetLength()), "%f", &(max[3]));
  sscanf(minString[4].GetBuffer(minString[4].GetLength()), "%f", &(min[4]));
  sscanf(maxString[4].GetBuffer(maxString[4].GetLength()), "%f", &(max[4]));
  sscanf(minString[5].GetBuffer(minString[5].GetLength()), "%f", &(min[5]));
  sscanf(maxString[5].GetBuffer(maxString[5].GetLength()), "%f", &(max[5]));
  sscanf(minString[6].GetBuffer(minString[6].GetLength()), "%f", &(min[6]));
  sscanf(maxString[6].GetBuffer(maxString[6].GetLength()), "%f", &(max[6]));
  sscanf(minString[7].GetBuffer(minString[7].GetLength()), "%f", &(min[7]));
  sscanf(maxString[7].GetBuffer(maxString[7].GetLength()), "%f", &(max[7]));
  sscanf(minString[8].GetBuffer(minString[8].GetLength()), "%f", &(min[8]));
  sscanf(maxString[8].GetBuffer(maxString[8].GetLength()), "%f", &(max[8]));
  sscanf(minString[9].GetBuffer(minString[9].GetLength()), "%f", &(min[9]));
  sscanf(maxString[9].GetBuffer(maxString[9].GetLength()), "%f", &(max[9]));
  
  setSliderRanges();
  setSliders();
}

void CTestDataGeneratorDlgBar::updateUI(CCmdUI* pCmdUI)
{
  switch(pCmdUI->m_nID)
  {
  case IDC_TDG_DESCRIPTION_A_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[0]);
    return;
  case IDC_TDG_DESCRIPTION_B_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[1]);
    return;
  case IDC_TDG_DESCRIPTION_C_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[2]);
    return;
  case IDC_TDG_DESCRIPTION_D_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[3]);
    return;
  case IDC_TDG_DESCRIPTION_E_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[4]);
    return;
  case IDC_TDG_DESCRIPTION_F_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[5]);
    return;
  case IDC_TDG_DESCRIPTION_G_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[6]);
    return;
  case IDC_TDG_DESCRIPTION_H_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[7]);
    return;
  case IDC_TDG_DESCRIPTION_I_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[8]);
    return;
  case IDC_TDG_DESCRIPTION_J_EDIT:
    pCmdUI->Enable(enableDescriptionEdit[9]);
    return;
  default:
    return;
  }
}
////////////////////////////////////////////////////////////////////////

#include "Representations/Perception/CameraMatrix.h"
#include "Tools/Math/Common.h"
#include "Tools/Math/Vector2.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Debugging/DebugDrawings.h"


void TestDataGenerator::generateTestData
(
 TestDataType testDataType, 
 GenericDebugData parameters,
 OutMessage& out
 )
{
  switch (testDataType) 
  {
  case showColorSlidesInImage: 
    generateImageWithYUV_Layer(parameters, out);
    break;
  case generateBallInImage:
    generateImageWithBall(parameters, out);
    break;
  case generateLineInImage:
    generateImageWithLine(parameters, out);
    break;
  case testLineClipping:
    lineClippingTest(parameters, out);
    break;
  case testLineClipping2:
    lineClippingTest2(parameters, out);
    break;
  case genericDebugData:
    generateGenericDebugData(parameters, out);
  }
}

const char* TestDataGenerator::getTestDataTypeName
(
 enum TestDataType testDataType
 )
{
  switch (testDataType) 
  {
  case showColorSlidesInImage: return "show color slides in image";
  case generateBallInImage: return "generate ball in image";
  case generateLineInImage: return "generate line in image";
  case testLineClipping: return "test line clipping";
  case testLineClipping2: return "test line clipping2";
  default: return "check available TestDataTypes";
  }
}

void TestDataGenerator::generateGenericDebugData
(
 GenericDebugData parameters,
 OutMessage& out
 )
{
  out.bin << parameters;
  out.finishMessage(GenericDebugData::getMessageID((GenericDebugData::GenericDebugDataID)parameters.id));
}

void TestDataGenerator::generateImageWithYUV_Layer
(
 GenericDebugData parameters,
 OutMessage& out
 )
{
  Image image;
  image.cameraInfo.resolutionHeight = 144;
  image.cameraInfo.resolutionWidth = 176;
//  image.cameraInfo.resolutionHeight = 160;
//  image.cameraInfo.resolutionWidth = 208;
  CameraMatrix cameraMatrix;
  if(
    parameters.data[1] == 0 && 
    parameters.data[2] == 0 && 
    parameters.data[3] == 0)
  {
    int layer = (int)parameters.data[0];
    for (int line = 0;line < image.cameraInfo.resolutionHeight; line++)
    {
      for (int column = 0; column < image.cameraInfo.resolutionWidth; column++)
      {
        image.image[image.cameraInfo.resolutionHeight - 1 - line][0][column] = layer;
        image.image[image.cameraInfo.resolutionHeight - 1 - line][1][column] = column * 256 / image.cameraInfo.resolutionWidth;
        image.image[image.cameraInfo.resolutionHeight - 1 - line][2][column] = line * 256 / image.cameraInfo.resolutionHeight;
      }
    }
  }
  else
  {
    for (int line = 0;line < image.cameraInfo.resolutionHeight; line++)
    {
      for (int column = 0; column < image.cameraInfo.resolutionWidth; column++)
      {
        image.image[line][0][column] = rand() * (int)parameters.data[1] / RAND_MAX;
        image.image[line][1][column] = rand() * (int)parameters.data[2] / RAND_MAX;
        image.image[line][2][column] = rand() * (int)parameters.data[3] / RAND_MAX;
      }
    }
  } // else
  out.bin << SEND_IMAGE(image,cameraMatrix);
  out.finishMessage(idImage);
}

void TestDataGenerator::generateImageWithBall
(
 GenericDebugData parameters,
 OutMessage& out
 )
{
  Image image;
  CameraMatrix cameraMatrix;
  double radius = parameters.data[0] / 5.0;
  int centerX = (int)parameters.data[1];
  int centerY = (int)parameters.data[2];
  
  generateRectangleInImage(
    image,
    0, 0, image.cameraInfo.resolutionWidth, image.cameraInfo.resolutionHeight, 
    90, 120, 100  // green
    );
  
  generateCircleInImage(
    image,
    centerX, centerY, radius,
    160, 190, 80    // orange
    );
  
  out.bin << SEND_IMAGE(image,cameraMatrix);
  out.finishMessage(idImage);
}

void TestDataGenerator::generateImageWithLine
(
 GenericDebugData parameters,
 OutMessage& out
 )
{
  Image image;
  CameraMatrix cameraMatrix;
  
  generateRectangleInImage(
    image,
    0, 0, image.cameraInfo.resolutionWidth, image.cameraInfo.resolutionHeight, 
    255, 127, 127  // white
    );
  
  Vector2<int> point1((int)parameters.data[0], (int)parameters.data[1]);
  Vector2<int> point2((int)parameters.data[2], (int)parameters.data[3]);
  
  Geometry::clipLineWithRectangleCohenSutherland(
    Vector2<int>(0,0), Vector2<int>(175, 143), point1, point2);
  
  Geometry::PixeledLine linePixels(point1, point2);
  for(int i = 0; i < linePixels.getNumberOfPixels(); i++)
  {
    image.image[linePixels.getPixelY(i)][0][linePixels.getPixelX(i)] = 0;
  }
  
  out.bin << SEND_IMAGE(image,cameraMatrix);
  out.finishMessage(idImage);
}

void TestDataGenerator::lineClippingTest
(
 GenericDebugData parameters,
 OutMessage& out
 )
{
  Vector2<int> point1, point2, bottomLeft, topRight;
  
  point1.x = (int)parameters.data[0];
  point1.y = (int)parameters.data[1];
  point2.x = (int)parameters.data[2];
  point2.y = (int)parameters.data[3];
  
  bottomLeft.x = (int)parameters.data[4];
  bottomLeft.y = (int)parameters.data[5];
  topRight.x = (int)parameters.data[6];
  topRight.y = (int)parameters.data[7];
  
  Image image;
  CameraMatrix cameraMatrix;
  
  generateRectangleInImage(
    image,
    0, 0, image.cameraInfo.resolutionWidth, image.cameraInfo.resolutionHeight, 
    255, 127, 127  // white
    );
  
  generateRectangleInImage(
    image,
    bottomLeft.x, bottomLeft.y, topRight.x, topRight.y, 
    127, 127, 127  // gray
    );
  
  Geometry::Line line(point1, point2-point1);
  
  Geometry::PixeledLine linePixels(point1, point2);
  for(int i = 0; i < linePixels.getNumberOfPixels(); i++)
  {
    image.image[linePixels.getPixelY(i)][0][linePixels.getPixelX(i)] = 192;
    image.image[linePixels.getPixelY(i)][1][linePixels.getPixelX(i)] = 127;
    image.image[linePixels.getPixelY(i)][2][linePixels.getPixelX(i)] = 127;
  }
  
  if(Geometry::clipLineWithRectangleCohenSutherland(
    bottomLeft, topRight, point1, point2))
  {
    Geometry::PixeledLine linePixels(point1, point2);
    for(int i = 0; i < linePixels.getNumberOfPixels(); i++)
    {
      image.image[linePixels.getPixelY(i)][0][linePixels.getPixelX(i)] = 0;
      image.image[linePixels.getPixelY(i)][1][linePixels.getPixelX(i)] = 127;
      image.image[linePixels.getPixelY(i)][2][linePixels.getPixelX(i)] = 127;
    }
  }
  
  image.image[point1.y][0][point1.x] = 0;
  image.image[point1.y][1][point1.x] = 255;
  image.image[point1.y][2][point1.x] = 0;
  
  image.image[point2.y][0][point2.x] = 255;
  image.image[point2.y][1][point2.x] = 0;
  image.image[point2.y][2][point2.x] = 0;
  
  out.bin << SEND_IMAGE(image,cameraMatrix);
  out.finishMessage(idImage);
  /*
  Vector2<int> point1, point2, bottomLeft, topRight;
  
    point1.x = (int)parameters.data[0];
    point1.y = (int)parameters.data[1];
    point2.x = (int)parameters.data[2];
    point2.y = (int)parameters.data[3];
    
      bottomLeft.x = (int)parameters.data[4];
      bottomLeft.y = (int)parameters.data[5];
      topRight.x = (int)parameters.data[6];
      topRight.y = (int)parameters.data[7];
      
        
          DOT(sketch, point1.x, point1.y, Drawings::red, Drawings::red);
          DOT(sketch, point2.x, point2.y, Drawings::green, Drawings::green);
          LINE(sketch, point1.x, point1.y, point2.x, point2.y, 0, Drawings::ps_solid, Drawings::gray);
          
            DOT(sketch, bottomLeft.x, bottomLeft.y, Drawings::blue, Drawings::blue);
            DOT(sketch, topRight.x, topRight.y, Drawings::yellow, Drawings::yellow);
            QUADRANGLE(sketch, 
            bottomLeft.x, bottomLeft.y, 
            topRight.x, bottomLeft.y,
            topRight.x, topRight.y,
            bottomLeft.x, topRight.y,
            0, Drawings::ps_solid, Drawings::gray);
            
              if(Geometry::clipLineWithRectangleCohenSutherland(
              bottomLeft, topRight, point1, point2) )
              {
              LINE(sketch, point1.x, point1.y, point2.x, point2.y, 0, Drawings::ps_solid, Drawings::white);
              DOT(sketch, point1.x, point1.y, Drawings::red, Drawings::white);
              DOT(sketch, point2.x, point2.y, Drawings::green, Drawings::white);
              }
              
                DEBUG_DRAWING_FINISHED(sketch);
  */
 }
 
 void TestDataGenerator::lineClippingTest2
   (
   GenericDebugData parameters,
   OutMessage& out
   )
 {
   Vector2<int> point1, point2, bottomLeft, topRight;
   
   point1.x = (int)parameters.data[0];
   point1.y = (int)parameters.data[1];
   point2.x = (int)parameters.data[2];
   point2.y = (int)parameters.data[3];
   
   bottomLeft.x = (int)parameters.data[4];
   bottomLeft.y = (int)parameters.data[5];
   topRight.x = (int)parameters.data[6];
   topRight.y = (int)parameters.data[7];
   
   Image image;
   CameraMatrix cameraMatrix;
   
   generateRectangleInImage(
     image,
     0, 0, image.cameraInfo.resolutionWidth, image.cameraInfo.resolutionHeight, 
     255, 127, 127  // white
     );
   
   generateRectangleInImage(
     image,
     bottomLeft.x, bottomLeft.y, topRight.x, topRight.y, 
     127, 127, 127  // gray
     );
   
   Geometry::Line line(point1, point2-point1);
   
   Geometry::PixeledLine linePixels(point1, point2);
   for(int i = 0; i < linePixels.getNumberOfPixels(); i++)
   {
     image.image[linePixels.getPixelY(i)][0][linePixels.getPixelX(i)] = 192;
     image.image[linePixels.getPixelY(i)][1][linePixels.getPixelX(i)] = 127;
     image.image[linePixels.getPixelY(i)][2][linePixels.getPixelX(i)] = 127;
   }
   
   if(Geometry::getIntersectionPointsOfLineAndRectangle(
     bottomLeft, topRight, line, point1, point2))
   {
     Geometry::PixeledLine linePixels(point1, point2);
     for(int i = 0; i < linePixels.getNumberOfPixels(); i++)
     {
       image.image[linePixels.getPixelY(i)][0][linePixels.getPixelX(i)] = 0;
       image.image[linePixels.getPixelY(i)][1][linePixels.getPixelX(i)] = 127;
       image.image[linePixels.getPixelY(i)][2][linePixels.getPixelX(i)] = 127;
     }
   }
   
   image.image[point1.y][0][point1.x] = 0;
   image.image[point1.y][1][point1.x] = 255;
   image.image[point1.y][2][point1.x] = 0;
   
   image.image[point2.y][0][point2.x] = 255;
   image.image[point2.y][1][point2.x] = 0;
   image.image[point2.y][2][point2.x] = 0;
   
   out.bin << SEND_IMAGE(image,cameraMatrix);
   out.finishMessage(idImage);
 }
 
 
 void TestDataGenerator::generateColorSlideInImage
   (
   Image& image,
   int y1, int u1, int v1,
   int y2, int u2, int v2
   )
 {
   //fill image
   for (int line = 0;line < 144; line++)
   {
     for (int column = 0; column < 176; column++)
     {
       image.image[line][0][column] = (int)(y1 + (y2 - y1) * line / 144.0);
       image.image[line][1][column] = (int)(u1 + (u2 - u1) * line / 144.0);
       image.image[line][2][column] = (int)(v1 + (v2 - v1) * line / 144.0);
     }
   }
 }
 
 void TestDataGenerator::generateCircleInImage
   (
   Image& image,
   int centerX, int centerY, double radius,
   int y, int u, int v
   )
 {
   //fill circle
   for (double r = 0; r < radius; r += 0.2)
   {
     for (double angle = 0; angle < pi2; angle += pi2 / r / 6)
     {
       int column = (int)(centerX + r * cos(angle));
       int line = (int)(centerY + r * sin(angle));
       
       if(line >= 0 && line < image.cameraInfo.resolutionHeight && column >= 0 && column < image.cameraInfo.resolutionWidth)
       {
         image.image[line][0][column] = y;
         image.image[line][1][column] = u;
         image.image[line][2][column] = v;
       }
     }
   }
 }
 
 void TestDataGenerator::generateRectangleInImage
   (
   Image& image,
   int left, int top, int right, int bottom,
   int y, int u, int v
   )
 {
   if(left < 0) left = 0;
   if(top < 0) top = 0;
   if(right > image.cameraInfo.resolutionWidth) right = image.cameraInfo.resolutionWidth;
   if(bottom > image.cameraInfo.resolutionHeight) bottom = image.cameraInfo.resolutionHeight;
   
   //fill rect
   for (int line = top;line < bottom; line++)
   {
     for (int column = left; column < right; column++)
     {
       image.image[line][0][column] = y;
       image.image[line][1][column] = u;
       image.image[line][2][column] = v;
     }
   }
 }
 
 
 /*
 * Change log :
 * 
 * $Log: TestDataGeneratorDlgBar.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:28:08  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.7  2004/02/05 14:31:02  juengel
 * changed color slide generation
 *
 * Revision 1.6  2004/01/04 12:07:21  juengel
 * Larger image for "color slides"
 *
 * Revision 1.5  2003/12/15 11:49:08  juengel
 * Introduced CameraInfo
 *
 * Revision 1.4  2003/12/09 19:49:26  loetzsch
 * Renamed some of the main queues of RobotControl.
 *
 * Added possibility to send messages to specific simulated or physical robots.
 *
 * Revision 1.3  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.2  2003/11/30 14:02:58  loetzsch
 * made RobotControl compilable under VC7
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.2  2003/09/26 11:40:12  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.13  2003/06/25 18:41:02  juengel
 * Added lineClippingTest2.
 *
 * Revision 1.12  2003/05/11 23:46:35  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.11  2003/03/05 17:09:28  loetzsch
 * redesign of the queues and debug key tables in RobotControl
 *
 * Revision 1.10  2003/02/09 10:05:26  juengel
 * Added default button to TestDataGenerator
 *
 * Revision 1.9  2003/01/30 22:29:30  juengel
 * Added methods getParameterName and getParameterValue to GenericDebugData.
 *
 * Revision 1.8  2003/01/30 11:32:32  juengel
 * GenericDebugData has message getMessageID.
 *
 * Revision 1.7  2003/01/27 14:47:12  juengel
 * TestDataGenerator generates GenericDebugData now.
 *
 * Revision 1.6  2003/01/23 19:08:47  juengel
 * Improved TestDataGeneratorDlg.
 * Removed ParameterStruct.
 * Moved implementation and declaration of TestDataGenerator to
 * TestDataGeneratorDlg.h and TestDataGeneratorDlg.cpp.
 *
 * Revision 1.5  2003/01/22 15:18:43  dueffert
 * warning removed
 *
 * Revision 1.4  2003/01/17 12:48:18  jhoffman
 * added GenericDebugData
 * changes to the TestDataGenerator towards using sliders, min/max, and other cool stuff
 *
 * Revision 1.3  2002/12/01 17:36:41  juengel
 * TestDataGenerator has 8 sliders now.
 *
 * Revision 1.2  2002/11/28 14:06:08  dueffert
 * docu improved
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.2  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2002/02/07 23:25:47  loetzsch
 * Changed registry access
 *
 * Revision 1.2  2002/01/26 20:25:25  juengel
 * Nichts gendert
 *
 * Revision 1.1  2002/01/22 14:47:59  juengel
 * TestDataGenerator eingefhrt
 *
 *
 */
