/**
* @file SimulatedRobotsToolBar.h
* 
* Definition of the simulated robot robots toolbar.
*
* @author Martin Ltzsch
*/

#ifndef __SimulatedRobotsToolBar_h_ 
#define __SimulatedRobotsToolBar_h_ 

#include "StdAfx.h"
#include "RobotControlToolBar.h"

/** 
* A ToolBar for the simulated robots ui.
* @author Martin Ltzsch
*/
class CSimulatedRobotsToolBar : public CRobotControlToolBar
{
  DECLARE_DYNAMIC( CSimulatedRobotsToolBar );
public:
  virtual void Init();

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

  /** 
  * Handles Dropdown events in the toolbar 
  * @return if the message was handled
  */
  virtual bool handleDropDown(NMHDR* pNotifyStruct);

protected:
  /** Sets the correct toobar image of a simulated robot */
  void setImage(int robot);

  /** Determines if a Button has a button text */
  virtual bool HasButtonText( UINT nID );
};

#endif //__SimulatedRobotsToolBar_h_ 

/*
 * Change log :
 * 
 * $Log: SimulatedRobotsToolBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:28:01  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:35  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2003/03/23 19:14:21  loetzsch
 * finished GUI for 8 simulated robots
 * - added the passive state
 * - added the state[8] variable to CRobotControlSimulatedRobots
 * - Repaint of object viewer after reset
 * - Resend debug key table after reset
 * - don't stop simulation when selected robot changes
 *
 * Revision 1.1  2003/03/20 20:36:22  loetzsch
 * renamed SimulatorToolbar to Simulated Robots toolbar
 * added class CRobotControlSimulatedRobots
 * started implementing the GUI for 8 simulated robots
 *
 * 
 * $Log: SimulatedRobotsToolBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:28:01  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:35  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2003/03/23 19:14:21  loetzsch
 * finished GUI for 8 simulated robots
 * - added the passive state
 * - added the state[8] variable to CRobotControlSimulatedRobots
 * - Repaint of object viewer after reset
 * - Resend debug key table after reset
 * - don't stop simulation when selected robot changes
 *
 * Revision 1.1  2003/03/20 20:36:22  loetzsch
 * renamed SimulatorToolbar to Simulated Robots toolbar
 * added class CRobotControlSimulatedRobots
 * started implementing the GUI for 8 simulated robots
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.5  2002/09/01 17:19:47  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.4  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.3  2002/08/13 12:55:10  loetzsch
 * - Added base class CRobotControlToolBar for tool bars
 * - Moved command handling from CRobotControlMainFrame to the tool bars
 *
 * Revision 1.2  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/01/14 22:40:49  loetzsch
 * SimRobot / RobotControl integration started
 *
 *
 */
