/**
* @file SettingsDlgBar.h
*
* Declaration of class CSettingsDlgBar
*
* @author Matthias Jngel
* @author Martin Ltzsch
*/

#ifndef __SettingsDlgBar_h_
#define __SettingsDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Tools/Module/SolutionRequest.h"
#include "MfcTools/GridCtrl/GridCtrl.h"


/**
* @class CSettingsDlgBar 
* 
* A dialog bar to administrate and edit settings of SolutionRequests 
* and DebugKeyTables.
* 
* @author Matthias Jngel
* @author Martin Ltzsch
*/
class CSettingsDlgBar : public CRobotControlDialogBar
{
  // Construction
public:
  /**
  * Default constructor.
  */
  CSettingsDlgBar();

  ~CSettingsDlgBar();

  /** returns the currently selected solution request for the local processes */
  SolutionRequest& getSolutionRequestForLocalProcesses();

  // Dialog Data
  //{{AFX_DATA(CSettingsDlgBar)
	enum { IDD = IDD_DIALOG_BAR_SETTINGS };
	CComboBox	m_settingsCombo;
	CButton   m_toAllRobots;
	CButton   m_toSelected;
  CButton   m_buttonNew;
  CButton   m_buttonDel;
  CButton   m_buttonRen;
  CButton   m_buttonSave;
  CButton   m_buttonMakeDefault;
  CStatic   m_SelectedRobotsText;
	//}}AFX_DATA
  CGridCtrl m_Grid;
  
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CSettingsDlgBar)
public:
  virtual BOOL PreTranslateMessage(MSG* pMsg);
protected:
  virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
  virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
  //}}AFX_VIRTUAL
  
  // Implementation
protected:
  
  // Generated message map functions
  //{{AFX_MSG(CSettingsDlgBar)
  virtual BOOL OnInitDialog();
  afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSelchangeSettingsCombo();
	afx_msg void OnSettingsNew();
	afx_msg void OnSettingsDelete();
	afx_msg void OnSettingsRename();
	afx_msg void OnSettingsSave();
  afx_msg void OnSettingsMakeDefault();
	afx_msg void OnStaCheck();
	//}}AFX_MSG
  afx_msg void OnGridClick(NMHDR *pNotifyStruct, LRESULT* pResult);
  DECLARE_MESSAGE_MAP();
    
private:
	void sendLocal();
	void sendToRobot();
  void initGrid();
  void loadSettings();
  void updateComboBox();
  void saveSetting(int index);
  void newSetting();

  int m_columnWidth;
  int m_rowHeight;

  int numberOfSettings;
  enum{maxNumberOfSettings = 20};

  typedef enum changeMode {readOnly,isSaved,isChanged,isNew} changeMode;
  changeMode modeOfSetting[maxNumberOfSettings];
  CString nameOfSetting[maxNumberOfSettings];

  int currentSetting;
  SolutionRequest solutionRequestRobotList[maxNumberOfSettings];
  SolutionRequest solutionRequestLocalList[maxNumberOfSettings];
};

#endif //__CSettingsDlgBar_h_

/*
* Change log :
* 
* $Log: SettingsDlgBar.h,v $
* Revision 1.1.1.1  2004/05/22 17:28:00  cvsadm
* created new repository GT2004_WM
*
* Revision 1.5  2004/02/29 17:32:21  jhoffman
* settings dialog resizing behavior improved
*
* Revision 1.4  2004/02/02 15:15:53  jhoffman
* UI improvements, user feedback integrated
*
* Revision 1.3  2004/01/29 12:03:24  jhoffman
* UI changes:
* - Main menu entries renamed, reordered, added some new icons
* - delete-confirmation in settings and WLAN dialog
* - settings dialog uses icons, radio buttons added
* - WLAN dialog restructured
* - motion tester and head motion tested layout improved, stop button added
* - check boxes replaced by radio buttons where appropriate
*
* Revision 1.2  2004/01/19 16:59:39  kerdels
* send to all Checkbox im Settings-Dialog hinzugefgt
*
* Revision 1.1  2003/10/07 10:09:38  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.6  2003/05/11 23:46:35  dueffert
* Depend now works with RobotControl too
*
* Revision 1.5  2003/03/05 17:09:28  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.4  2002/11/09 10:50:49  risler
* corrupt settings now get corrected
*
* Revision 1.3  2002/09/24 19:24:20  risler
* added make default button to settings dialog
*
* Revision 1.2  2002/09/11 00:14:43  loetzsch
* continued new module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:49:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.6  2002/08/30 17:13:56  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.5  2002/08/27 17:07:18  dueffert
* improved handling significantly
*
* Revision 1.4  2002/08/07 10:50:21  loetzsch
* - removed direct access to the dialogs
* - faster starting of RobotControl application and main window
* - general clean up
*
* Revision 1.3  2002/07/23 13:43:37  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.2  2002/06/04 00:13:26  loetzsch
* added access to solution request for local processes
*
* Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.3  2002/04/23 17:45:16  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.2  2002/02/24 15:50:54  juengel
* SettingsDlgBar completed.
*
* Revision 1.1  2002/02/18 14:03:57  juengel
* SettingsDlgBar added.
*
*/
