/**
* @file RadarViewerDlgBar.h
*
* Declaration of class CRadarViewerDlgBar
*
* @author Martin Ltzsch
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/

#ifndef __RadarViewerDlgBar_h_
#define __RadarViewerDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Perception/Image.h"
#include "Representations/Perception/BallPercept.h"
#include "Representations/Perception/LandmarksPercept.h"
#include "Representations/Perception/PlayersPercept.h"
#include "Representations/Perception/ObstaclesPercept.h"
#include "Representations/Perception/LinesPercept.h"
#include "Representations/Perception/EdgesPercept.h"
#include "Representations/Perception/PSDPercept.h"
#include "Representations/Cognition/BallModel.h"
#include "Representations/Cognition/ObstaclesModel.h"

#include "Tools/RingBuffer.h"

#include "MfcTools/DockingControlBars/DynamicBar.h"

/**
* @class CRadarViewerDlgBar 
* 
* A dialog bar to view percept collections
*/
class CRadarViewerDlgBar : public CRobotControlDialogBar
{
public:
	CRadarViewerDlgBar();   

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);

  //{{AFX_DATA(CRadarViewerDlgBar)
	enum { IDD = IDD_DIALOG_BAR_RADAR_VIEWER };
	CEdit	m_bufferEdit;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CRadarViewerDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CRadarViewerDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
private:
  /** 
  * Is called when a configuration is loaded. Can be used by the dialogs and 
  * bars to load configuration dependand settings.
  * @param sectionName The registry section for the current configuration
  */
  virtual void OnConfigurationLoad(CString sectionName);

  /** 
  * Is called when a configuration is saved. Can be used by the dialogs and 
  * bars to save configuration dependand settings.
  * @param sectionName The registry section for the current configuration
  */
  virtual void OnConfigurationSave(CString sectionName);

  void paintCurrentSelectionToCDC(CDC& dc, bool paintFrame = false);
  void copyToClipBoard();

  double scale;

  // Mouse
	CPoint m_LeftDownPos;
	bool m_LeftButtonDown;

  /** The rect where the image is painted*/
  CRect rect;

  enum {bufferSize = 100};
  //percepts
  RingBuffer<BallPercept, bufferSize> ballPerceptBuffer;
  RingBuffer<BallModel, bufferSize> ballModelBuffer;
  RingBuffer<LandmarksPercept, bufferSize> landmarksPerceptBuffer;
  RingBuffer<LinesPercept, bufferSize> linesPerceptBuffer;
  RingBuffer<ObstaclesPercept, bufferSize> obstaclesPerceptBuffer;
  RingBuffer<RobotPose, bufferSize> robotPoseBuffer;
  RingBuffer<ObstaclesModel, bufferSize> obstaclesModelBuffer;
  RingBuffer<PSDPercept, bufferSize> psdPerceptBuffer;
  RingBuffer<CameraMatrix, bufferSize> cameraMatrixBuffer;
  RingBuffer<CameraInfo, bufferSize> cameraInfoBuffer;
  RingBuffer<Image, bufferSize> imageBuffer;

  int numberOfShownEntries;

  //flags
  bool showCoordinateSystem;
  bool showRobot;
  bool showBallPerceptSizeBased;
  bool showBallPerceptBearingBased;
  bool showBallModel;
  bool showLandmarksPercept;
  bool showPlayersPercept;
  bool showLinesPercept;
  bool showObstaclesPercept;
  bool showObstaclesModel;
  bool showSensorData;
  bool showJointData;
  bool showAngleOfView;
  bool showImage;
  bool showImageOnGround;
  bool showPSDPercept;

  bool ballAsCross;
  bool lineToBall;
public:
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnEnChangeRadarBufferEdit();
};

//{{AFX_INSERT_LOCATION}}

#endif //__RadarViewerDlgBar_h_

/*
 * Change log :
 * 
 * $Log: RadarViewerDlgBar.h,v $
 * Revision 1.3  2004/06/15 10:58:27  thomas
 * added edge-specialist, edges-percept, debug-drawings etc. (not yet called from image-processor)
 *
 * Revision 1.2  2004/05/22 22:52:04  juengel
 * Renamed ballP_osition to ballModel.
 *
 * Revision 1.1.1.1  2004/05/22 17:27:53  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.5  2004/03/25 21:22:27  juengel
 * Ball model is shown.
 *
 * Revision 1.4  2004/02/07 15:48:24  juengel
 * Added buffer edit box to RadarViewer.
 * Added some different modes of view for the BallPercept
 *
 * Revision 1.3  2004/02/03 13:19:49  spranger
 * renamed all references to  class BallP_osition to BallModel
 *
 * Revision 1.2  2004/02/02 10:08:57  juengel
 * Redesign of RadarViewer.
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:35  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2002/09/20 23:28:33  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.4  2002/09/01 17:19:47  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.3  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.2  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/02/08 13:28:08  loetzsch
 * Visualization of PerceptCollection and RadarViewer started
 * (not implemented yet)
 *
 */
