/**
* @file RadarViewer3DDlgBar.h
*
* Declaration of class CRadarViewer3DDlgBar.
*
* @author Martin Ltzsch
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/
#ifndef __RadarViewer3DDlgBar_h_
#define __RadarViewer3DDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "Tools/RingBuffer.h"
#include "Representations/Perception/SensorData.h"
#include "Representations/Perception/CameraMatrix.h"
#include "Representations/Perception/Image.h"
#include "Representations/Motion/JointData.h"

/**
* A docking window for the color space viewer
*
* @author Matthias Jngel
*/
class CRadarViewer3DDlgBar : public CRobotControlDialogBar
{
// Construction
public:
	CRadarViewer3DDlgBar();	// standard constructor

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);

  /** renders the scene with the current rotation parameters*/
  void renderScene();
  HDC m_hDC;

// Dialog Data
	//{{AFX_DATA(CRadarViewer3DDlgBar)
	enum { IDD = IDD_DIALOG_BAR_RADAR_VIEWER_3D };
	CStatic	m_static_buffer_size;
	CSliderCtrl	m_slider_buffer_size;
	CSliderCtrl	m_slider_x_pos;
	CSliderCtrl	m_slider_y_pos;
	CSliderCtrl	m_slider_z_pos;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CRadarViewer3DDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CRadarViewer3DDlgBar)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
private:
  void setSliders();

  /** 
  * Is called when a configuration is loaded. Can be used by the dialogs and 
  * bars to load configuration dependand settings.
  * @param sectionName The registry section for the current configuration
  */
  virtual void OnConfigurationLoad(CString sectionName);

  /** 
  * Is called when a configuration is saved. Can be used by the dialogs and 
  * bars to save configuration dependand settings.
  * @param sectionName The registry section for the current configuration
  */
  virtual void OnConfigurationSave(CString sectionName);

  bool showBallPercept;
  bool showLandmarksPercept;
  bool showPlayersPercept;
  bool showLinesPercept;
  bool showObstaclesPercept;
  bool showObstaclesModel;
  bool showSensorData;
  bool showJointData;
  bool showAngleOfView;
  bool showImage;
  bool showImageOnGround;
  bool showPSDPercept;

  // Mouse
	CPoint m_LeftDownPos;
	BOOL m_LeftButtonDown;

	// Interaction
	double m_xRotate;
	double m_yRotate;
	double m_zRotate;

  double x_pos;
  double y_pos;
  double z_pos;

  HGLRC m_hGLContext;

  RingBuffer<JointData, 200> jointDataRingBuffer;
  RingBuffer<SensorData, 200> sensorDataRingBuffer;

  RingBuffer<Image, 100> imageRingBuffer;
  RingBuffer<CameraMatrix, 100> cameraMatrixRingBuffer;
  
//  CameraMatrix sensorDataBasedCameraMatrix;
  
  int imageBufferSize;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined RadarViewer3DDlgBar

/*
 * Change log :
 * $Log: RadarViewer3DDlgBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:27:52  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.6  2004/02/14 13:05:57  roefer
 * SensorData drawn for feet and knees
 *
 * Revision 1.5  2004/01/25 21:23:57  juengel
 * Added bodyTiltCalibration mechanism.
 *
 * Revision 1.4  2004/01/14 19:19:02  mellmann
 * Visualization of PSDPercept.
 *
 * Revision 1.3  2004/01/10 12:39:57  juengel
 * Selections are stored dependent on configuration.
 *
 * Revision 1.2  2003/10/23 07:30:09  juengel
 * Added image buffer to radar viewer 3d.
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.2  2003/09/11 15:54:58  juengel
 * Added sliders for camera position.
 * Added visualization of joint and sensor data.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.9  2003/06/26 12:35:53  juengel
 * Visualization of ObstaclesModel.
 *
 * Revision 1.8  2003/05/11 23:46:35  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.7  2003/03/11 11:26:56  juengel
 * Added obstaclesPercept to drawingMethods.
 *
 * Revision 1.6  2002/11/28 18:53:52  juengel
 * RadarViewer3D shows images projected on ground.
 *
 * Revision 1.5  2002/11/26 19:19:24  loetzsch
 * JPEG images are put into local processes
 *
 * Revision 1.4  2002/11/26 14:17:36  juengel
 * RadarViewer3DDlg displays images.
 *
 * Revision 1.3  2002/10/11 13:45:30  juengel
 * Methods for visualization of percepts added.
 *
 * Revision 1.2  2002/10/10 16:18:39  loetzsch
 * some minor improvements and better doxygen comments
 *
 * Revision 1.1  2002/10/10 13:09:49  loetzsch
 * First experiments with the PSD Sensor
 * - SensorDataProcessor now calculates PSDPercept
 * - Added the PerceptBehaviorControl solution PSDTest
 * - Added the RadarViewer3D to RobotControl, which can display the Points3D structure
 *
 */
