/**
* @file MotionTesterDlgBar.cpp
* 
* Implementation of class CMotionTesterDlgBar.
*
* @author Martin Ltzsch
*/

#include "StdAfx.h"
#include "MotionTesterDlgBar.h"

#include "Platform/SystemCall.h"
#include "RobotControlQueues.h"

CMotionTesterDlgBar::CMotionTesterDlgBar()
: CRobotControlDialogBar(IDD),
lastSentTime(0),
motionControlExecuteSlowMotion(1)
{
  //{{AFX_DATA_INIT(CMotionTesterDlgBar)
  //}}AFX_DATA_INIT
	smoothControlMode=false;
}


void CMotionTesterDlgBar::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CMotionTesterDlgBar)
  DDX_Control(pDX, IDC_MOTION_TESTER_TAIL_COMBO, m_tailCombo);
  DDX_Control(pDX, IDC_MOTION_TESTER_TAIL_STATIC, m_tailStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_WALK_TYPE, m_walkTypeCombo);
  DDX_Control(pDX, IDC_MOTION_TESTER_TYPE_LIST, m_typeList);
  DDX_Control(pDX, IDC_MOTION_TESTER_WALK_SLIDER1, m_walkSlider1);
  DDX_Control(pDX, IDC_MOTION_TESTER_WALK_SLIDER2, m_walkSlider2);
  DDX_Control(pDX, IDC_MOTION_TESTER_WALK_SLIDER3, m_walkSlider3);
  DDX_Control(pDX, IDC_MOTION_TESTER_FORWARD_STATIC, m_forwardStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_BACKWARD_STATIC, m_backwardStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_LEFT_STATIC, m_leftStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_RIGHT_STATIC, m_rightStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_ROT_LEFT_STATIC, m_rotLeftStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_ROT_RIGHT_STATIC, m_rotRightStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_FORWARD_BACKWARD_STATIC, m_forwardBackwardStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_FORWARD_LEFT_RIGHT_STATIC, m_leftRightStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_FORWARD_ROT_LEFT_RIGHT_STATIC, m_rotLeftRightStatic);
  DDX_Control(pDX, IDC_MOTION_TESTER_SPECIAL_ACTION_LIST, m_specialActionList);
  DDX_Control(pDX, IDC_MOTION_TESTER_SEND_BUTTON, m_sendButton);
  DDX_Control(pDX, IDC_MOTION_TESTER_BUTTON_X2, m_stopButton);
  DDX_Control(pDX, IDC_MOTION_TESTER_RESET_BUTTON, m_resetButton);
  DDX_Control(pDX, IDC_MOTION_TESTER_STABILIZE_CHECK, m_stabilizeCheck);
  DDX_Control(pDX, IDC_MOTION_TESTER_UPDATEODOMETRYINMOTION_CHECK, m_updateRPCheck);
  DDX_Control(pDX, IDC_MOTION_TESTER_BREATHE_CHECK, m_breatheCheck);
	DDX_Control(pDX, IDC_MOTION_TESTER_SMOOTHCONTROL_CHECK, m_smoothControlCheck);
  DDX_Control(pDX, IDC_MOTION_TESTER_EXECUTEMOTIONCONTROL_SLIDER, m_mcSlowMotionSlider);
  DDX_Control(pDX, IDC_MOTION_TESTER_EXECUTEMC_STATIC, m_motionControlStatic);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMotionTesterDlgBar, CDynamicBarDlg)
//{{AFX_MSG_MAP(CMotionTesterDlgBar)
ON_BN_CLICKED(IDC_MOTION_TESTER_SEND_BUTTON, OnSend)
ON_BN_CLICKED(IDC_MOTION_TESTER_RESET_BUTTON, OnReset)
ON_LBN_SELCHANGE(IDC_MOTION_TESTER_SPECIAL_ACTION_LIST, OnSelchangeSpecialActionList)
ON_WM_HSCROLL()
ON_LBN_DBLCLK(IDC_MOTION_TESTER_SPECIAL_ACTION_LIST, OnDblclkSpecialActionList)
ON_LBN_SELCHANGE(IDC_MOTION_TESTER_TYPE_LIST, OnSelchangeTypeList)
ON_LBN_DBLCLK(IDC_MOTION_TESTER_TYPE_LIST, OnDblclkTypeList)
ON_BN_CLICKED(IDC_MOTION_TESTER_STABILIZE_CHECK, OnStabilizeCheck)
ON_BN_CLICKED(IDC_MOTION_TESTER_UPDATEODOMETRYINMOTION_CHECK, OnUpdateRPCheck)
ON_BN_CLICKED(IDC_MOTION_TESTER_BREATHE_CHECK, OnBreatheCheck)
ON_BN_CLICKED(IDC_MOTION_TESTER_SMOOTHCONTROL_CHECK, OnSmoothControlCheck)
ON_CBN_SELCHANGE(IDC_MOTION_TESTER_WALK_TYPE, OnSelchangeWalkType)
ON_BN_CLICKED(IDC_MOTION_TESTER_BUTTON_A, OnButtonA)
ON_BN_CLICKED(IDC_MOTION_TESTER_BUTTON_D, OnButtonD)
ON_BN_CLICKED(IDC_MOTION_TESTER_BUTTON_E, OnButtonE)
ON_BN_CLICKED(IDC_MOTION_TESTER_BUTTON_Q, OnButtonQ)
ON_BN_CLICKED(IDC_MOTION_TESTER_BUTTON_S, OnButtonS)
ON_BN_CLICKED(IDC_MOTION_TESTER_BUTTON_W, OnButtonW)
ON_BN_CLICKED(IDC_MOTION_TESTER_BUTTON_X, OnButtonX)
ON_BN_CLICKED(IDC_MOTION_TESTER_BUTTON_X2, OnButtonX)
ON_CBN_SELCHANGE(IDC_MOTION_TESTER_TAIL_COMBO, OnSelchangeTailCombo)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CMotionTesterDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();
  
  AddSzControl(m_typeList, mdResize, mdNone);
  AddSzControl(m_walkTypeCombo, mdResize, mdNone);
  AddSzControl(m_walkSlider1, mdResize, mdRelative);
  AddSzControl(m_walkSlider2, mdResize, mdRelative);
  AddSzControl(m_walkSlider3, mdResize, mdRelative);
  AddSzControl(m_forwardStatic, mdRepos, mdRelative);
  AddSzControl(m_backwardStatic, mdNone, mdRelative);
  AddSzControl(m_leftStatic, mdNone, mdRelative);
  AddSzControl(m_rightStatic, mdRepos, mdRelative);
  AddSzControl(m_rotLeftStatic, mdNone, mdRelative);
  AddSzControl(m_rotRightStatic, mdRepos, mdRelative);
  AddSzControl(m_forwardBackwardStatic, mdRepos, mdRelative);
  AddSzControl(m_leftRightStatic, mdRepos, mdRelative);
  AddSzControl(m_rotLeftRightStatic, mdRepos, mdRelative);
  AddSzControl(m_specialActionList, mdResize, mdResize);
  AddSzControl(m_resetButton,mdRepos,mdRepos);
  AddSzControl(m_sendButton,mdRepos,mdRepos);
  AddSzControl(m_tailStatic,mdNone,mdRepos);
  AddSzControl(m_tailCombo,mdResize,mdRepos);
  AddSzControl(m_stabilizeCheck,mdNone,mdRepos);
  AddSzControl(m_updateRPCheck,mdNone,mdRepos);
  AddSzControl(m_breatheCheck,mdNone,mdRepos);
  AddSzControl(m_mcSlowMotionSlider,mdNone,mdRepos);
  AddSzControl(m_motionControlStatic,mdResize,mdRepos);
	AddSzControl(m_smoothControlCheck,mdNone,mdRepos);
	AddSzControl(m_stopButton, mdRepos, mdRelative);

  
  m_walkSlider1.SetRange(-(int)walkMaxBackwardSpeed,(int)walkMaxForwardSpeed);
  m_walkSlider1.SetTicFreq(25);
  m_walkSlider1.SetLineSize(10);
  
  m_walkSlider2.SetRange(-(int)walkMaxLeftRightSpeed,(int)walkMaxLeftRightSpeed);
  m_walkSlider2.SetTicFreq(25);
  m_walkSlider2.SetLineSize(10);
  
  m_walkSlider3.SetRange(-(int)(toDegrees(walkMaxRotationSpeed)),(int)(toDegrees(walkMaxRotationSpeed)));
  m_walkSlider3.SetTicFreq(10);
  m_walkSlider3.SetLineSize(5);
  
  int i;
  for (i=0; i<MotionRequest::numOfMotion;i++)
    m_typeList.AddString(MotionRequest::getMotionName(
    (MotionRequest::MotionID)i));
  for (i=0; i<WalkRequest::numOfWalkType;i++)
    m_walkTypeCombo.AddString(WalkRequest::getWalkTypeName(
    (WalkRequest::WalkType)i));
  for (i=0; i<SpecialActionRequest::numOfSpecialAction;i++)
    m_specialActionList.AddString(SpecialActionRequest::getSpecialActionIDName(
    (SpecialActionRequest::SpecialActionID)i));
  for (i=0; i<TailRequest::numOfTailRequests;i++)
    m_tailCombo.AddString(TailRequest::getTailRequestIDName(
    (TailRequest::TailRequestID)i));
  
  showCurrentMotion(SW_HIDE);

  m_typeList.SetCurSel(motionRequest.motionType);
  m_specialActionList.ShowWindow(motionRequest.motionType == MotionRequest::specialAction);

  m_walkSlider1.SetPos(0);
  m_walkSlider2.SetPos(0);
  m_walkSlider3.SetPos(0);

  char buf[30];
  sprintf(buf,"%i mm/s",m_walkSlider1.GetPos());
  m_forwardBackwardStatic.SetWindowText(buf);
  
  sprintf(buf,"%i mm/s",-1*m_walkSlider2.GetPos());
  m_leftRightStatic.SetWindowText(buf);
  
  sprintf(buf,"%i /s",-1*m_walkSlider3.GetPos());
  m_rotLeftRightStatic.SetWindowText(buf);
  
  m_breatheCheck.SetCheck(motionRequest.breathe);
  m_stabilizeCheck.SetCheck(motionRequest.stabilize);
  m_updateRPCheck.SetCheck(motionRequest.updateRP);
  m_walkTypeCombo.SetCurSel(motionRequest.walkRequest.walkType);
  m_tailCombo.SetCurSel(motionRequest.tailRequest.tailRequestID);
  m_specialActionList.SetCurSel(motionRequest.specialActionRequest.specialActionType);

  m_mcSlowMotionSlider.SetRange(1,50);
  m_mcSlowMotionSlider.SetPos(1);

  showCurrentMotion(SW_NORMAL);
  
  return TRUE;
}

void CMotionTesterDlgBar::OnUpdateControl(CCmdUI* pCmdUI)
{
}

void CMotionTesterDlgBar::OnButtonA() 
{
  m_walkSlider1.SetPos(0);
	if (smoothControlMode)
		m_walkSlider2.SetPos((int)-makeSmooth(walkMaxLeftRightSpeed) + m_walkSlider2.GetPos());
	else
		m_walkSlider2.SetPos((int)-walkMaxLeftRightSpeed);
  m_walkSlider3.SetPos(0);
  m_typeList.SetCurSel(MotionRequest::walk);
  OnSelchangeTypeList();
  OnHScroll();
}

void CMotionTesterDlgBar::OnButtonD() 
{
  
	m_walkSlider1.SetPos(0);
	if (smoothControlMode)
		m_walkSlider2.SetPos((int)makeSmooth(walkMaxLeftRightSpeed) + m_walkSlider2.GetPos());
	else
		m_walkSlider2.SetPos((int)walkMaxLeftRightSpeed);
  m_walkSlider3.SetPos(0);
  m_typeList.SetCurSel(MotionRequest::walk);
  OnSelchangeTypeList();
  OnHScroll();
}

void CMotionTesterDlgBar::OnButtonE() 
{
  m_walkSlider1.SetPos(0);
  m_walkSlider2.SetPos(0);
	if (smoothControlMode)
		m_walkSlider3.SetPos((int)makeSmooth(toDegrees(walkMaxRotationSpeed)) +  m_walkSlider3.GetPos());
  else 
		m_walkSlider3.SetPos((int)toDegrees(walkMaxRotationSpeed));
	m_typeList.SetCurSel(MotionRequest::walk);
  OnSelchangeTypeList();
  OnHScroll();
}

void CMotionTesterDlgBar::OnButtonQ() 
{
  m_walkSlider1.SetPos(0);
  m_walkSlider2.SetPos(0);
  m_walkSlider3.GetPos();
	if (smoothControlMode)
		m_walkSlider3.SetPos((int)-makeSmooth(toDegrees(walkMaxRotationSpeed)) + m_walkSlider3.GetPos());
	else
		m_walkSlider3.SetPos((int)-toDegrees(walkMaxRotationSpeed));
  m_typeList.SetCurSel(MotionRequest::walk);
  OnSelchangeTypeList();
  OnHScroll();
}

void CMotionTesterDlgBar::OnButtonS() 
{
	if (smoothControlMode)
		m_walkSlider1.SetPos((int)-makeSmooth(walkMaxBackwardSpeed) + m_walkSlider1.GetPos());
	else
		m_walkSlider1.SetPos((int)-walkMaxBackwardSpeed);
  m_walkSlider2.SetPos(0);
  m_walkSlider3.SetPos(0);
  m_typeList.SetCurSel(MotionRequest::walk);
  OnSelchangeTypeList();
  OnHScroll();
}

void CMotionTesterDlgBar::OnButtonW() 
{
	if (smoothControlMode)
		m_walkSlider1.SetPos((int)makeSmooth(walkMaxBackwardSpeed) + m_walkSlider1.GetPos());
	else
		m_walkSlider1.SetPos((int)walkMaxForwardSpeed);
  m_walkSlider2.SetPos(0);
  m_walkSlider3.SetPos(0);
  m_typeList.SetCurSel(MotionRequest::walk);
  OnSelchangeTypeList();
  OnHScroll();
}

void CMotionTesterDlgBar::OnButtonX() 
{
  m_walkSlider1.SetPos(0);
  m_walkSlider2.SetPos(0);
  m_walkSlider3.SetPos(0);
  m_typeList.SetCurSel(MotionRequest::walk);
  OnSelchangeTypeList();
  OnHScroll();
}


void CMotionTesterDlgBar::OnSend() 
{
  if (SystemCall::getTimeSince(lastSentTime) > 150)
  {
    if (lastSentTime != 0) 
    {
      getQueues().toGUI.out.text 
        << "MotionTester : last request was executed for " 
        << SystemCall::getTimeSince(lastSentTime) << " ms";
      getQueues().toGUI.out.finishMessage(idText);
    }
    // dont send on every OnHScroll
    getQueues().toPhysical.selectedRobot.out.bin << motionRequest;
    getQueues().toPhysical.selectedRobot.out.finishMessage(idMotionRequest);
    
    getQueues().toSimulated.selectedRobot.out.bin << motionRequest;
    getQueues().toSimulated.selectedRobot.out.finishMessage(idMotionRequest);

    getQueues().toSimulated.allRobots.out.bin << (double)motionControlExecuteSlowMotion;
    getQueues().toSimulated.allRobots.out.finishMessage(idMotionControlSlowMotion);

    getQueues().toPhysical.allRobots.out.bin << (double)motionControlExecuteSlowMotion;
    getQueues().toPhysical.allRobots.out.finishMessage(idMotionControlSlowMotion);
    
    lastSentTime = SystemCall::getCurrentSystemTime();
  }
}

void CMotionTesterDlgBar::OnReset()  
{
  showCurrentMotion(SW_HIDE);
  m_walkSlider1.SetPos(0);
  m_walkSlider2.SetPos(0);
  m_walkSlider3.SetPos(0);
  
  motionRequest.walkRequest.walkParams.translation.x = 0;
  motionRequest.walkRequest.walkParams.translation.y = 0;
  motionRequest.walkRequest.walkParams.rotation = 0;

  if (motionRequest.motionType == MotionRequest::walk)
  {
	  OnSend();
  }
  if (motionRequest.motionType == MotionRequest::specialAction)
  {
	  motionRequest.motionType=MotionRequest::stand;
	  OnSend();
	  motionRequest.motionType=MotionRequest::specialAction;
  }
  
  OnHScroll();
  m_breatheCheck.SetCheck(motionRequest.breathe);
  m_stabilizeCheck.SetCheck(motionRequest.stabilize);
  m_updateRPCheck.SetCheck(motionRequest.updateRP);
  m_walkTypeCombo.SetCurSel(motionRequest.walkRequest.walkType);
  m_tailCombo.SetCurSel(motionRequest.tailRequest.tailRequestID);
  m_specialActionList.SetCurSel(motionRequest.specialActionRequest.specialActionType);
  showCurrentMotion(SW_NORMAL);
}

void CMotionTesterDlgBar::showCurrentMotion(int mode)
{
  switch(motionRequest.motionType)
  {
  case MotionRequest::walk:
    m_walkTypeCombo.ShowWindow(mode);
    m_walkSlider1.ShowWindow(mode);
    m_walkSlider2.ShowWindow(mode);
    m_walkSlider3.ShowWindow(mode);
    m_forwardStatic.ShowWindow(mode);
    m_backwardStatic.ShowWindow(mode);
    m_leftStatic.ShowWindow(mode);
    m_rightStatic.ShowWindow(mode);
    m_rotLeftStatic.ShowWindow(mode);
    m_rotRightStatic.ShowWindow(mode);
    m_forwardBackwardStatic.ShowWindow(mode);
    m_leftRightStatic.ShowWindow(mode);
    m_rotLeftRightStatic.ShowWindow(mode);
    m_stopButton.ShowWindow(mode);
    break;
  case MotionRequest::specialAction:
    m_specialActionList.ShowWindow(mode);
    break;
  }
}

void CMotionTesterDlgBar::OnSelchangeTypeList() 
{
  showCurrentMotion(SW_HIDE);
  motionRequest.motionType = 
    (MotionRequest::MotionID)m_typeList.GetCurSel();
  showCurrentMotion(SW_NORMAL);
  switch(motionRequest.motionType)
  {
  case MotionRequest::walk:
    OnSelchangeWalkType();
    OnHScroll();
    break;
  case MotionRequest::specialAction:
    OnSelchangeSpecialActionList();
    break;
  }
}

void CMotionTesterDlgBar::OnSelchangeWalkType() 
{
  motionRequest.walkRequest.walkType = 
    (WalkRequest::WalkType)m_walkTypeCombo.GetCurSel();
}

void CMotionTesterDlgBar::OnSelchangeSpecialActionList() 
{
  motionRequest.specialActionRequest.specialActionType = 
    (SpecialActionRequest::SpecialActionID)m_specialActionList.GetCurSel();
}

void CMotionTesterDlgBar::OnSelchangeTailCombo() 
{
  motionRequest.tailRequest.tailRequestID =
    (TailRequest::TailRequestID)m_tailCombo.GetCurSel();
}

void CMotionTesterDlgBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  OnHScroll();
  
  CDynamicBarDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CMotionTesterDlgBar::OnHScroll()
{
  motionRequest.walkRequest.walkParams.translation.x = (double)m_walkSlider1.GetPos();
  motionRequest.walkRequest.walkParams.translation.y = -1*(double)m_walkSlider2.GetPos();
  motionRequest.walkRequest.walkParams.rotation = fromDegrees(-1*(double)m_walkSlider3.GetPos());

  motionControlExecuteSlowMotion = m_mcSlowMotionSlider.GetPos();
  
  char buf[30];
  sprintf(buf,"%i mm/s",m_walkSlider1.GetPos());
  m_forwardBackwardStatic.SetWindowText(buf);
  
  sprintf(buf,"%i mm/s",-1*m_walkSlider2.GetPos());
  m_leftRightStatic.SetWindowText(buf);
  
  sprintf(buf,"%i /s",-1*m_walkSlider3.GetPos());
  m_rotLeftRightStatic.SetWindowText(buf);
  
  OnSend();
}

void CMotionTesterDlgBar::OnDblclkSpecialActionList() 
{
  OnSend();
}

void CMotionTesterDlgBar::OnDblclkTypeList() 
{
  OnSend();
}

void CMotionTesterDlgBar::OnUpdateRPCheck() 
{
  motionRequest.updateRP = !motionRequest.updateRP;	
  getQueues().toGUI.out.text << "Update robot pose by odometry to " << motionRequest.stabilize;
  getQueues().toGUI.out.finishMessage(idText);
  OnSend();
}

void CMotionTesterDlgBar::OnStabilizeCheck() 
{
  motionRequest.stabilize = !motionRequest.stabilize;	
  getQueues().toGUI.out.text << "Stabilizer set to " << motionRequest.stabilize;
  getQueues().toGUI.out.finishMessage(idText);
  OnSend();
}

void CMotionTesterDlgBar::OnBreatheCheck() 
{
  motionRequest.breathe = !motionRequest.breathe;	
  getQueues().toGUI.out.text << "Breath set to " << motionRequest.breathe;
  getQueues().toGUI.out.finishMessage(idText);
  OnSend();
}

void CMotionTesterDlgBar::OnSmoothControlCheck() 
{
	smoothControlMode = !smoothControlMode;
  getQueues().toGUI.out.text << "Smooth Control set to " << smoothControlMode;
  getQueues().toGUI.out.finishMessage(idText);

}

double CMotionTesterDlgBar::makeSmooth(double value)
{
	return value * 0.1f;
}
/*
* Change log :
* 
* $Log: MotionTesterDlgBar.cpp,v $
* Revision 1.6  2004/06/10 15:54:13  spranger
* finally the newly inserted slider stays where it is supposed to, while resizing Dialog
*
* Revision 1.5  2004/06/09 18:58:31  spranger
* added MotionControl-slowmotion
*
* Revision 1.4  2004/06/02 17:24:08  spranger
* motionrequest cleanup
*
* Revision 1.3  2004/06/02 17:18:23  spranger
* MotionRequest cleanup
*
* Revision 1.2  2004/06/02 11:57:24  dueffert
* initial sending of MotionRequest removed
*
* Revision 1.1.1.1  2004/05/22 17:27:50  cvsadm
* created new repository GT2004_WM
*
* Revision 1.7  2004/04/07 13:00:46  risler
* ddd checkin after go04 - second part
*
* Revision 1.3  2004/04/02 20:52:23  risler
* keyboard control does not reset walk type
*
* Revision 1.2  2004/03/29 20:40:00  dthomas
* reenabled sending invKinParams to debug walkType
* modified stop-button in motionTester not to reset the walkType
*
* Revision 1.1.1.1  2004/03/29 08:28:44  Administrator
* initial transfer from tamara
*
* Revision 1.6  2004/03/28 14:09:51  jhoffman
* - added error member variables to ball model
* - minor improvement in handling of updateRP in motiontesterdialog
*
* Revision 1.6  2004/03/28 14:09:51  jhoffman
* - added error member variables to ball model
* - minor improvement in handling of updateRP in motiontesterdialog
*
* Revision 1.5  2004/03/19 18:58:24  jhoffman
* "update robot pose in motion" is now turned on by default
*
* Revision 1.4  2004/03/16 14:00:22  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.2  2004/03/15 17:11:40  hoffmann
* - added ATH2004HeadControl
* - added ATH2004LEDControl
* - headmotiontester shows "tilt2"
* - motion process updates odometry while no new robotPose is received, added to motion request
* - some ui adjustments
* - added member function to "field" to find out if robot is in own penalty area for use in the obstacles locator
*
* Revision 1.3  2004/01/29 12:21:48  jhoffman
* UI changes:
* - Main menu entries renamed, reordered, added some new icons
* - delete-confirmation in settings and WLAN dialog
* - settings dialog uses icons, radio buttons added
* - WLAN dialog restructured
* - motion tester and head motion tested layout improved, stop button added
* - check boxes replaced by radio buttons where appropriate
*
* Revision 1.2  2003/12/09 19:49:25  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.1  2003/10/07 10:09:38  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.8  2003/06/04 16:43:09  dassler
* Added a smooth robot movement. By using the Doom buttons the value of the movement is changed by 10% of the max value.
* A checkbox turns smooth feature on/off
*
* Revision 1.7  2003/05/11 23:46:34  dueffert
* Depend now works with RobotControl too
*
* Revision 1.6  2003/04/14 16:18:00  loetzsch
* ATH after GermanOpen CVS merge
* reset improved
*
* Revision 1.2  2003/04/10 19:12:34  dueffert
* context sensitive reset in MotionTester
*
* Revision 1.1.1.1  2003/04/09 14:22:44  loetzsch
* started Aibo Team Humboldt's GermanOpen CVS
*
* Revision 1.5  2003/03/23 19:11:06  loetzsch
* OUTPUT not allowed in the RobotControl thread anymore.
* Use getQueues().toGUI.out instead.
*
* Revision 1.4  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.3  2002/11/25 14:48:18  jhoffman
* "breath" check box added to motion tester
*
* Revision 1.2  2002/09/22 18:40:51  risler
* added new math functions, removed GTMath library
*
* Revision 1.1  2002/09/10 15:49:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.3  2002/07/23 13:43:37  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.2  2002/06/04 16:44:55  risler
* tailRequest added
*
* Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.23  2002/04/24 07:49:14  risler
* changed normalWalkMaxSpeed to walkMaxSpeed
*
* Revision 1.22  2002/04/23 17:45:16  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.21  2002/04/23 15:08:44  risler
* changed MotionRequest: walk instead of normalWalk,... and walkType added
*
* Revision 1.20  2002/04/17 17:04:40  risler
* Darmstadt GO
*
* Revision 1.19  2002/04/16 16:06:43  dueffert
* no message
*
* Revision 1.17  2002/04/08 13:34:14  dueffert
* PlayersToolBar added
*
* Revision 1.16  2002/04/04 17:15:28  jhoffman
* no message
*
* Revision 1.15  2002/04/04 16:34:29  jhoffman
* added stabilizer check box (continued)
*
* Revision 1.14  2002/04/04 16:19:06  jhoffman
* added stabilizer check box
*
* Revision 1.13  2002/04/04 15:07:59  rentmeister
* Walk with Ball hinzugefgt
*
* Revision 1.12  2002/04/03 16:44:28  dueffert
* cast warning removed
*
* Revision 1.11  2002/04/03 15:20:24  risler
* changed normalWalkMaxRotationSpeed to angle
*
* Revision 1.10  2002/02/27 19:53:46  loetzsch
* removed onUpdateCmdUI message maps
*
* Revision 1.9  2002/02/13 01:41:07  risler
* changed motion tester layout
*
* Revision 1.8  2002/02/12 16:34:49  risler
* finished MofTester
*
* Revision 1.7  2002/01/20 20:46:17  loetzsch
* increased usability
*
* Revision 1.6  2002/01/19 21:36:26  risler
* added HeadMotionTester, HeadControlSelector
*
* Revision 1.5  2002/01/19 13:39:10  risler
* changed OnReset
*
* Revision 1.4  2002/01/18 13:08:43  loetzsch
* lastSentTime updated on sending
*
* Revision 1.3  2002/01/18 02:17:39  loetzsch
* MotionTester dialog and distribution of MotionRequests
* to the processes programmed.
*
* Revision 1.2  2001/12/10 17:47:09  risler
* change log added
*
*/

