/**
* @file MofTesterDlgBar.h
* Declaration of class CMofTesterDlgBar.
* @author Max Risler
*/

#ifndef __MofTesterDlgBar_h_
#define __MofTesterDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Motion/JointDataSequence.h"
#include "Representations/Perception/SensorData.h"

/**
 * @class CMofTesterDlgBar
 * A dialog bar used to send mof data (sequences of joint values) to the DebugWalkingEngine
 */
class CMofTesterDlgBar : public CRobotControlDialogBar
{
public:
  /** Default constructor. */
  CMofTesterDlgBar();

	//{{AFX_DATA(CMofTesterDlgBar)
	enum { IDD = IDD_DIALOG_BAR_MOFTESTER };
	CStatic	m_lines;
	CStatic	m_static1;
	CButton	m_stopButton;
	CEdit	  m_mofEdit;
	CButton	m_readButton;
	CButton	m_loopCheck;
  CButton	m_executeButton;
  CButton m_mirrorButton;
  CButton m_rawdataButton;
  CButton m_slowMoButton;
  CEdit   m_slowMoEdit;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CMofTesterDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

  /** 
  * Enables the controls in the dialog bar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

protected:

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CMofTesterDlgBar)
	virtual BOOL OnInitDialog();
	afx_msg void OnExecuteButton();
	afx_msg void OnReadButton();
	afx_msg void OnStopButton();
  afx_msg void OnMirrorButton();
  afx_msg void OnRawDataButton();
  afx_msg void OnSlowMoButton();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();

public:

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);


  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

protected:

  JointDataSequence jointDataSequence;

  bool waitForSensorData;

  void generateJointDataSequence(int slowFactor = 1);
  void sendSequence();

};

//{{AFX_INSERT_LOCATION}}

#endif // __MofTesterDlgBar_h_

/*
 * Change log :
 * 
 * $Log: MofTesterDlgBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:27:49  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.7  2004/03/10 17:15:35  risler
 * added slow motion button
 *
 * Revision 1.6  2004/02/29 18:21:55  heinze
 * - added the RawData-Button which returns the joint-data-values
 *   for adding them to c-code
 *
 * Revision 1.5  2004/01/29 12:03:24  jhoffman
 * UI changes:
 * - Main menu entries renamed, reordered, added some new icons
 * - delete-confirmation in settings and WLAN dialog
 * - settings dialog uses icons, radio buttons added
 * - WLAN dialog restructured
 * - motion tester and head motion tested layout improved, stop button added
 * - check boxes replaced by radio buttons where appropriate
 *
 * Revision 1.4  2003/12/19 17:36:31  loetzsch
 * beautified the mof tester
 *
 * Revision 1.3  2003/12/16 19:02:46  loetzsch
 * The motion net file Config/spec_act.dat can be sent through WLAN to a robot.
 *
 * Revision 1.2  2003/12/09 18:14:44  loetzsch
 * changed comments
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:34  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2003/02/01 17:05:03  risler
 * added mirror function to MofTester
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.2  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2002/04/23 17:45:16  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.2  2002/02/12 16:34:49  risler
 * finished MofTester
 *
 * Revision 1.1  2002/02/12 01:02:31  risler
 * added MofTester
 *
 *
 */
