/**
* @file MessageViewerDlgBar.h
*
* Declaration of class CMessageViewerDlgBar
*
* @author Martin Ltzsch
*/ 
#ifndef __MessageViewerDlgBar_h_
#define __MessageViewerDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

/**
* @class CMessageViewerDlgBar 
*
* A dialog bar to view text messages
*/
class CMessageViewerDlgBar : public CRobotControlDialogBar
{
public:
	CMessageViewerDlgBar();   // Standardkonstruktor

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

  void printMessage(char* message);

  /** clear all messages */
  void clear();

	//{{AFX_DATA(CMessageViewerDlgBar)
	enum { IDD = IDD_DIALOG_BAR_MESSAGEVIEWER };
	CEdit	m_Edit;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CMessageViewerDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);  
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CMessageViewerDlgBar)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif // __MessageViewerDlgBar_h_

/*
 * Change log :
 * 
 * $Log: MessageViewerDlgBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:27:45  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:34  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2002/11/20 13:37:30  dueffert
 * missing or wrong doxygen file corrected
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.2  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.1  2002/08/29 15:05:14  dueffert
 * case corrected
 *
 * Revision 1.1  2002/08/29 14:39:36  dueffert
 * includes in correct case, system includes in <>
 *
 * Revision 1.2  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2002/01/14 22:37:39  loetzsch
 * Doxygen comment error fixed
 *
 * Revision 1.4  2001/12/12 18:08:56  loetzsch
 * Streaming- Operatoren fr Bilder eingebaut, DebugKeyTable nicht- statisch gemacht, Debuggin Mechanismen weitergemacht, Bilder aus Logfiles in RobotControl anzeigen, Logfiles in HU1/Debug auf den Stick schreiben
 *
 * Revision 1.3  2001/12/10 17:47:09  risler
 * change log added
 *
 */
