/**
* @file MessageViewerDlgBar.cpp
*
* Implementation of class CMessageViewerDlgBar
*
* @author Martin Ltzsch
*/ 

#include "StdAfx.h"
#include "MessageViewerDlgBar.h"



CMessageViewerDlgBar::CMessageViewerDlgBar()
	: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(CMessageViewerDlgBar)
	//}}AFX_DATA_INIT
}

void CMessageViewerDlgBar::clear()
{
  m_Edit.SetWindowText("");
}

bool CMessageViewerDlgBar::handleCommand(UINT command)
{
  if (command==IDC_MESSAGEVIEWER_CLEAR)
  {
    clear();
    return true;
  }
  return false;
}

bool CMessageViewerDlgBar::handleMessage(InMessage& message)
{
  if (message.getMessageID() == idText)
  {      
    ASSERT(message.getMessageSize());
    char* buf = (char*)malloc(message.getMessageSize()*2+1);
    message.text.readAll(buf);
    printMessage(buf);
    free(buf);
    return true;
  }
  else return false;
}

void CMessageViewerDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMessageViewerDlgBar)
	DDX_Control(pDX, IDC_MESSAGEVIEWER_EDIT, m_Edit);
	//}}AFX_DATA_MAP
}

BOOL CMessageViewerDlgBar::OnInitDialog() 
{
	CDynamicBarDlg::OnInitDialog();
 
	AddSzControl(m_Edit,mdResize,mdResize);
  m_Edit.SetLimitText(32000000);
  return TRUE;
}

BEGIN_MESSAGE_MAP(CMessageViewerDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CMessageViewerDlgBar)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CMessageViewerDlgBar::printMessage(char* message)
{
  m_Edit.SetSel(10000000,10000000);
  strcat(message,"\r\n");
  m_Edit.ReplaceSel(message);
  m_Edit.LineScroll(2);
}
/*
 * Change log :
 * 
 * $Log: MessageViewerDlgBar.cpp,v $
 * Revision 1.2  2004/06/20 14:19:40  kindler
 * malloc'd buffers should not be freed with delete.
 *
 * Revision 1.1.1.1  2004/05/22 17:27:45  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:34  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2003/01/13 10:53:34  loetzsch
 * now text messages up to 32000000 bytes fit into the message viewer
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.2  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2001/12/12 18:08:56  loetzsch
 * Streaming- Operatoren fr Bilder eingebaut, DebugKeyTable nicht- statisch gemacht, Debuggin Mechanismen weitergemacht, Bilder aus Logfiles in RobotControl anzeigen, Logfiles in HU1/Debug auf den Stick schreiben
 *
 * Revision 1.3  2001/12/10 17:47:09  risler
 * change log added
 *
 */
