/**
* @file LogPlayerToolBar.h
* 
* Definition of the log player toolbar.
*
* @author Matthias Jngel
* @author Martin Ltzsch
*/

#ifndef __LogPlayerToolBar_h_ 
#define __LogPlayerToolBar_h_ 

#include "StdAfx.h"
#include "RobotControlToolBar.h"
#include "Tools/MessageQueue/LogPlayer.h"

/**
* @class CLogPlayerToolBar
* A ToolBar for playing and recording log files
*/
class CLogPlayerToolBar : public CRobotControlToolBar
{
  DECLARE_DYNAMIC( CLogPlayerToolBar );
public:

  /** constructor */
  CLogPlayerToolBar();

  /** Initializes the tool bar */
  virtual void Init(); 

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

  /** 
  * Handles change events for edit controls. That function must be called from the main frame 
  * window for all edit controls of the toolbar. 
  * @param nID the command id of the edit control
  * @return if the message was handled
  */
  virtual bool handleEditChange(UINT nID);

  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

  /** 
  * Handles selection change events for combo boxes. That function must be called from the 
  * main frame window for all combo boxes of the toolbar. 
  * @param nID the command id of the combo box
  * @return if the message was handled
  */
  virtual bool handleSelChange(UINT nID);

  // update frame-number in edit-field on change by other controls
  virtual void updateFrameNumber();

protected:
  /** A reference to the log player queue in the RobotControl application */
  LogPlayer& logPlayer;

  /** The current log file for playing and recording*/
  CString fileName;
  
  /** Determines if the buttons have a text */
  virtual bool HasButtonText( UINT nID );

  /** A combo box for the play speed */
  CComboBox speedCombo;

  /** A control for editing the frame-number to jump to*/
  CEdit m_wndLogPlayerJumpFrameEdit;
  /** A dummy combo box for the edit control */
  CComboBox m_wndLogPlayerJumpFrameEditDummyCombo;
};


#endif //__LogPlayerToolBar_h_ 

/*
* Change log :
* 
* $Log: LogPlayerToolBar.h,v $
* Revision 1.1.1.1  2004/05/22 17:27:45  cvsadm
* created new repository GT2004_WM
*
* Revision 1.5  2004/03/26 16:33:57  thomas
* added field in logplayer to jump directly to a given frame-number
*
* Revision 1.4  2003/12/19 17:37:28  loetzsch
* removed access from the worldstateanalysisdlgbar to the logPlayerToolbar
*
* Revision 1.3  2003/12/19 11:09:28  hamerla
* Logplayer extension  Seek
*
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:38  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/05/11 23:46:34  dueffert
* Depend now works with RobotControl too
*
* Revision 1.2  2002/10/04 10:27:33  loetzsch
* Added functionality to adjust the speed of playing log files.
*
* Revision 1.1  2002/09/10 15:49:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.6  2002/08/30 17:13:56  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.5  2002/08/13 12:55:10  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
*
* Revision 1.4  2002/08/08 16:40:30  loetzsch
* added class LogPlayer and redesigned RobotControl's Logplayer GUI
*
* Revision 1.3  2002/07/23 13:43:37  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.2  2002/06/10 12:00:41  dueffert
* commentation bugs fixed
*
* Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.10  2002/04/23 17:45:16  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.9  2002/02/18 14:08:52  juengel
* Basic record features added.
*
* Revision 1.8  2002/02/05 21:09:19  loetzsch
* RobotControl StatusBar now displayes simulation step,
* team color, player role and log player play time
*
* Revision 1.7  2002/01/25 16:53:21  loetzsch
* OnTimer replaced by OnIdle()
*
* Revision 1.6  2001/12/14 16:08:23  juengel
* Laden von Dateien verbessert
*
* Revision 1.5  2001/12/13 17:20:39  loetzsch
* CameraParameters Toolbar weitergemacht
*
* Revision 1.4  2001/12/13 15:28:45  bach
* Toolbar for Camera Parameters added (very premature looking)
*
* Revision 1.3  2001/12/13 12:58:16  loetzsch
* MemoryStick ToolBar hinzugefgt und an anderen Toolbars herumgebastelt
*
* Revision 1.2  2001/12/12 15:21:09  juengel
* CDebugKeyToolBar in eigenes .cpp und .h File verlagert.
*
* Revision 1.1  2001/12/11 15:14:24  juengel
* CLogPlayerToolBar in eigenes .cpp und .h File verlagert. Abspielfunktionalitt des LogPlayers implementiert.
*
*
*/
