/**
* @file LargeImageViewerDlgBar.h
*
* Declaration of class CLargeImageViewerDlgBar
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/

#ifndef __LargeImageViewerDlgBar_h_
#define __LargeImageViewerDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Perception/Image.h"

/**
* @class CLargeImageViewerDlgBar 
* 
* The large image viewer dialog displays images and debug drawings from the queue-ToGUI.
* Thus images from the robot, the log player, or the simulator are displayed.
* The Large Image Viewer shows only one image at the same time and is sizeable.
* With the context menu different types of images and different debug drawings can be selected.
*
* @author Matthias Jngel
*/
class CLargeImageViewerDlgBar : public CRobotControlDialogBar
{
public:
	CLargeImageViewerDlgBar();   

	//{{AFX_DATA(CLargeImageViewerDlgBar)
	enum { IDD = IDD_DIALOG_BAR_LARGEIMAGEVIEWER };
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CLargeImageViewerDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CLargeImageViewerDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();

private:
  /** The rect where the image is painted*/
  CRect rect;
};

//{{AFX_INSERT_LOCATION}}

#endif //__LargeImageViewerDlgBar_h_

/*
 * Change log :
 * 
 * $Log: LargeImageViewerDlgBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:27:44  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:34  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2002/09/20 23:28:33  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.2  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.1  2002/08/30 14:35:55  juengel
 * Renamed BlobViewer to LargeImageViewer
 *
 * Revision 1.2  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 */
