/**
* @file LargeImageViewerDlgBar.cpp
*
* Implementation of class CLargeImageViewerDlgBar
*
* @author Matthias Jngel
*/

#include "StdAfx.h"
#include "LargeImageViewerDlgBar.h"
#include "Visualization/DebugDrawingManager/DebugDrawingManager.h"
#include "Visualization/DebugDrawingManager/DebugDrawingManagerUI.h"
#include "Visualization/ImageMethods.h"



CLargeImageViewerDlgBar::CLargeImageViewerDlgBar()
	: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(CLargeImageViewerDlgBar)
	//}}AFX_DATA_INIT
}


void CLargeImageViewerDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLargeImageViewerDlgBar)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLargeImageViewerDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CLargeImageViewerDlgBar)
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CLargeImageViewerDlgBar::OnInitDialog() 
{
	CDynamicBarDlg::OnInitDialog();
  registerDrawingPaper(DrawingPapers::largeImageViewer, this); 

  return TRUE;
}

void CLargeImageViewerDlgBar::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
  paintDrawingPaper(&rect, DrawingPapers::largeImageViewer);
}

void CLargeImageViewerDlgBar::OnSize(UINT nType, int cx, int cy) 
{
  rect.left = 0;
  rect.right = cx;
  rect.top = 0;
  rect.bottom = cy;
  RedrawWindow();
}

void CLargeImageViewerDlgBar::OnContextMenu(CWnd* pWnd, CPoint point) 
{
  DebugDrawingManagerUI::showContextMenu(
    DrawingPapers::largeImageViewer, point, GetParentFrame() );
}

/*
 * Change log :
 * 
 * $Log: LargeImageViewerDlgBar.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:27:44  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/01/29 12:03:24  jhoffman
 * UI changes:
 * - Main menu entries renamed, reordered, added some new icons
 * - delete-confirmation in settings and WLAN dialog
 * - settings dialog uses icons, radio buttons added
 * - WLAN dialog restructured
 * - motion tester and head motion tested layout improved, stop button added
 * - check boxes replaced by radio buttons where appropriate
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:34  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2002/09/20 23:28:33  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.2  2002/08/30 14:59:46  juengel
 * Renamed BlobViewer to LargeImageViewer
 *
 * Revision 1.2  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 */

