/**
* @file JoystickMotionTesterDlgBar.h
*
* Declaration of class CJoystickMotionTesterDlgBar.
*
* @author Uwe Dffert
*/

#ifndef __JoystickMotionTesterDlgBar_h_
#define __JoystickMotionTesterDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Motion/HeadMotionRequest.h"
#include "Representations/Motion/HeadControlMode.h"
#include "Representations/Motion/MotionRequest.h"
#include "Tools/Actorics/RobotDimensions.h"

#include <mmsystem.h>

/** 
* @class CJoystickMotionTesterDlgBar 
*
* A dialog bar for sending motion requests generated by a joystick
*
* @author Uwe Dffert
*/
class CJoystickMotionTesterDlgBar : public CRobotControlDialogBar, public RobotDimensionsERS210
{
public:
  /** the constructor. */
  CJoystickMotionTesterDlgBar();

  /** the destructor. */
  ~CJoystickMotionTesterDlgBar();

  /** a type storing all information from polling the joystick as well as all states and commands implicated by that (sequence of) data */
  typedef struct JoyInfo {
    /** coordinates of the joystick (-1000..1000) */
    int x,y,z;

    /** acceleration (-1000..1000), buttons (8Bit) and coolie (-1,0..7) of joystick */
    int a,astart,b,c;

  } JoyInfo;


	//{{AFX_DATA(CJoystickMotionTesterDlgBar)
  /** the ID of joystick motion tester dialog :*/
	enum { IDD = IDD_DIALOG_BAR_JOYSTICKMOTIONTESTER };

  /** the scheme change combo box in joystick motion tester dialog :*/
	CComboBox	m_scheme;

  /** the 'use joystick' check box in joystick motion tester dialog */
	CButton	m_useJoystick;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CJoystickMotionTesterDlgBar)
	protected:
  /** exchange data between member variables and dialog elements */
	virtual void DoDataExchange(CDataExchange* pDX);  

  /** the initialisation. */
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

  /** draw a simple robot and its assumed trajectory according to the current joystick position into the joystick motion tester dialog */
  void drawRobot(CDC* dc, double x, double y, double r, double scale);

protected:
  /** image for double buffering to avoid flicker */
  CBitmap* m_pBitmap;

  /** stores the size of the background image */
  CRect m_rect;

  /** information indicated by joystick */
  JoyInfo joy;

  /** size provided by onSize */
  int sizex, sizey;

	//{{AFX_MSG(CJoystickMotionTesterDlgBar)
  /** en/disable dialog (setting timer, painting...) */
	afx_msg void OnUseJoystick();

  /** needed to poll the joystick, because not all relevant data can be delivered by interrupt */
	afx_msg void OnTimer(UINT nIDEvent);

  /** paint the dialog, including resizing walk/look visualisation */
	afx_msg void OnPaint();

  /** for correct visualisation we need to know all dialog size changes */
	afx_msg void OnSize(UINT nType, int cx, int cy);

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif // __JoystickMotionTesterDlgBar_h_

/*
 * Change log :
 * 
 * $Log: JoystickMotionTesterDlgBar.h,v $
 * Revision 1.2  2004/05/27 13:10:47  goehring
 * clean up
 *
 * Revision 1.1.1.1  2004/05/22 17:27:39  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/01/01 10:58:51  roefer
 * RobotDimensions are in a class now
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2003/05/11 23:46:34  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.3  2003/02/27 16:12:10  dueffert
 * joystick raw mode added
 *
 * Revision 1.2  2002/09/22 18:40:51  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.8  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.7  2002/08/30 08:42:48  dueffert
 * docu added
 *
 * Revision 1.6  2002/08/29 13:57:06  dueffert
 * includes in correct case, system includes in <>
 *
 * Revision 1.5  2002/08/18 12:25:36  dueffert
 * beautifying for release
 *
 * Revision 1.4  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.3  2002/06/20 23:39:47  dueffert
 * double instead of double
 *
 * Revision 1.2  2002/05/31 14:57:08  dueffert
 * WalkType support added
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.9  2002/04/23 17:45:16  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.8  2002/03/29 16:04:42  dueffert
 * schemes added
 *
 * Revision 1.7  2002/03/12 17:29:56  dueffert
 * works fine now though response times could be better
 *
 * Revision 1.6  2002/03/11 18:32:19  dueffert
 * JoystickMotionTester nearly complete
 *
 * Revision 1.5  2002/03/07 15:50:37  dueffert
 * no message
 *
 * Revision 1.4  2002/03/06 16:13:41  dueffert
 * JoystickMotionTester state machine implemented
 *
 * Revision 1.3  2002/03/05 20:05:09  dueffert
 * joystick: polling instead of messages, sorry, but messages cant deal with all buttons/axes
 *
 * Revision 1.2  2002/03/04 14:29:24  dueffert
 * no message
 *
 * Revision 1.1  2002/03/04 11:54:13  dueffert
 * JoystickMotionTester added
 *
 *
 */
