/**
* @file JoystickMotionTesterDlgBar.cpp
* 
* Implementation of class CJoystickMotionTesterDlgBar.
*
* @author Uwe Dffert
*/

#include "StdAfx.h"
#include "JoystickMotionTesterDlgBar.h"

#include "Tools/Actorics/RobotDimensions.h"
#include "Platform/SystemCall.h"
#include "RobotControlQueues.h"

#include "Representations/JoystickData.h"

CJoystickMotionTesterDlgBar::CJoystickMotionTesterDlgBar()
: CRobotControlDialogBar(IDD),
m_pBitmap(0),
sizex(50),sizey(40)
{
  joy.x=0;
  joy.y=0;
  joy.z=0;
  joy.a=0;
  joy.b=0;
  joy.c=-1;
  joy.astart=joy.a;
  
  //{{AFX_DATA_INIT(CJoystickMotionTesterDlgBar)
  //}}AFX_DATA_INIT
}

CJoystickMotionTesterDlgBar::~CJoystickMotionTesterDlgBar()
{
  if(m_pBitmap)
  {
    delete m_pBitmap;
  }
}

void CJoystickMotionTesterDlgBar::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CJoystickMotionTesterDlgBar)
  DDX_Control(pDX, IDC_JOYSTICKMOTIONTESTER_SCHEME, m_scheme);
  DDX_Control(pDX, IDC_JOYSTICKMOTIONTESTER_USEJOYSTICK, m_useJoystick);
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CJoystickMotionTesterDlgBar, CDynamicBarDlg)
//{{AFX_MSG_MAP(CJoystickMotionTesterDlgBar)
ON_BN_CLICKED(IDC_JOYSTICKMOTIONTESTER_USEJOYSTICK, OnUseJoystick)
ON_WM_TIMER()
ON_WM_PAINT()
ON_WM_SIZE()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CJoystickMotionTesterDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();
  AddSzControl(m_useJoystick, mdNone, mdNone);
  m_useJoystick.SetCheck(FALSE);
  AddSzControl(m_scheme, mdNone, mdNone);
  return TRUE;
}


void CJoystickMotionTesterDlgBar::OnUseJoystick() 
{
  if (m_useJoystick.GetCheck())
  {
    joy.astart=2000;
    
    //I'm sorry, polling is neccessary, events dont handle button 5-8 and 3rd axis
    SetTimer(654,40,0);
  }
  else
  {
    KillTimer(654);
  }
  
  UpdateData();
  Invalidate(FALSE);
}

void CJoystickMotionTesterDlgBar::OnTimer(UINT nIDEvent) 
{
  JOYINFOEX ji;
  ji.dwSize = sizeof(ji);
  ji.dwFlags = JOY_RETURNALL;
  MMRESULT joyresult;
  char bu[9];
  bu[8]=0;
  joyresult=joyGetPosEx(JOYSTICKID1,&ji);
  if (joyresult!=0)
  {
    //there is no joystick attached -> JoystickMotionTester would be useless
    m_useJoystick.SetCheck(FALSE);
    OnUseJoystick();
    
  }
  else
  {
    joy.b=ji.dwButtons;
    joy.c=ji.dwPOV==65535?-1:ji.dwPOV/4500;
    for (int i=0;i<8;i++)
    {
      bu[i]=((joy.b>>i)&1)?'1':'0';
    }
    joy.x=(int)(((int)ji.dwXpos-32767)/32.768);
    joy.y=(int)(((int)ji.dwYpos-32767)/32.768);
    joy.z=(int)(((int)ji.dwRpos-32767)/32.768);
    joy.a=(int)(((int)ji.dwZpos-32767)/32.768);
    if (joy.astart==2000)
    {
      //after start initialize astart with first valid a-value
      if (ji.dwZpos == 32767)
      {
        joy.a=2000;
      }
      else
      {
        joy.astart=joy.a;
      }
    }
    
    static int sentTime=0;
    static JoystickData joystickData;
    joystickData.x = (-(double)joy.y)/1000;
    joystickData.y = (-(double)joy.x)/1000;
    joystickData.z = (-(double)joy.z)/1000;
    joystickData.accel = (1000.0-(double)joy.a)/2000;
    joystickData.button |= joy.b;
    joystickData.coolie = joy.c+1;
    if ((SystemCall::getTimeSince(sentTime) >= 300))
    {
      getQueues().toPhysical.selectedRobot.out.bin << joystickData;
      getQueues().toPhysical.selectedRobot.out.finishMessage(idJoystickData);
      
      getQueues().toSimulated.selectedRobot.out.bin << joystickData << endl;
      getQueues().toSimulated.selectedRobot.out.finishMessage(idJoystickData);
      
      joystickData.button = 0;
      sentTime=SystemCall::getCurrentSystemTime();
      
      UpdateData();
      Invalidate(FALSE);
    }
    
    CDynamicBarDlg::OnTimer(nIDEvent);
  }  
}

void CJoystickMotionTesterDlgBar::drawRobot(CDC* dc, double x, double y, double r, double scale)
{
  POINT p[4];
  p[0].x=(int)(x+cos(r)*(1+2*scale));
  p[0].y=(int)(y+sin(r)*(1+2*scale));
  p[1].x=(int)(x-cos(r)*(1+2*scale));
  p[1].y=(int)(y-sin(r)*(1+2*scale));
  p[2].x=(int)(x-cos(r)*(1+2*scale)+cos(r+pi_2)*(2+7*scale));
  p[2].y=(int)(y-sin(r)*(1+2*scale)+sin(r+pi_2)*(2+7*scale));
  p[3].x=(int)(x+cos(r)*(1+2*scale)+cos(r+pi_2)*(2+7*scale));
  p[3].y=(int)(y+sin(r)*(1+2*scale)+sin(r+pi_2)*(2+7*scale));
  dc->Polygon(p,4);
}

void CJoystickMotionTesterDlgBar::OnPaint() 
{
  CPaintDC dc(this);
  CRect rect;
  GetClientRect(&rect);
  
  if(!GetParent()->IsIconic() && rect.right && rect.bottom)
  {
    if(!m_pBitmap || rect != m_rect)
    {
      m_rect = rect;
      if(m_pBitmap)
        delete m_pBitmap;
      m_pBitmap = new CBitmap;
      m_pBitmap->CreateCompatibleBitmap(&dc,rect.right,rect.bottom);
    }
    CDC dcMem;
    dcMem.CreateCompatibleDC(&dc);
    CBitmap* pBitmap = dcMem.SelectObject(m_pBitmap);
    
    CBrush br(GetSysColor(COLOR_3DFACE));
    dcMem.FillRect(&rect,&br);
    dcMem.SetBkColor(GetSysColor(COLOR_3DFACE));
    
    dc.BitBlt(0,0,rect.right,rect.bottom,&dcMem,0,0,SRCCOPY);
    dcMem.SelectObject(pBitmap);
  }
}

void CJoystickMotionTesterDlgBar::OnSize(UINT nType, int cx, int cy) 
{
  CDynamicBarDlg::OnSize(nType, cx, cy);
  if ((sizex!=cx)||(sizey!=cy))
  {
    Invalidate(FALSE);
  }
  sizex=cx;
  sizey=cy;
}

/*
* Change log :
* 
* $Log: JoystickMotionTesterDlgBar.cpp,v $
* Revision 1.3  2004/06/21 18:06:03  dueffert
* missing initialization added
*
* Revision 1.2  2004/05/27 13:10:47  goehring
* clean up
*
* Revision 1.1.1.1  2004/05/22 17:27:38  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2003/12/09 19:49:25  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.3  2003/12/04 22:56:07  roefer
* Compatibility with VC2003.NET
*
* Revision 1.2  2003/11/30 01:53:19  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.1  2003/10/07 10:09:38  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/26 15:28:23  juengel
* Renamed DataTypes to representations.
*
* Revision 1.2  2003/09/26 11:40:12  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.7  2003/05/11 23:46:34  dueffert
* Depend now works with RobotControl too
*
* Revision 1.6  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.5  2003/03/03 18:08:35  dueffert
* first behavior on raw joystick data
*
* Revision 1.4  2003/02/27 16:12:10  dueffert
* joystick raw mode added
*
* Revision 1.3  2002/11/28 14:06:08  dueffert
* docu improved
*
* Revision 1.2  2002/09/22 18:40:51  risler
* added new math functions, removed GTMath library
*
* Revision 1.1  2002/09/10 15:49:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.5  2002/08/18 12:25:36  dueffert
* beautifying for release
*
* Revision 1.4  2002/07/23 13:43:36  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.3  2002/06/20 23:39:47  dueffert
* double instead of double
*
* Revision 1.2  2002/05/31 14:57:08  dueffert
* WalkType support added
*
* Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.16  2002/05/03 11:49:56  juengel
* Removed secretSpecialActionID.
*
* Revision 1.15  2002/05/02 12:12:33  kallnik
* GTMath
*
* Revision 1.14  2002/04/25 14:50:34  kallnik
* changed double/float to double
* added several #include GTMath
*
* PLEASE use double
*
* Revision 1.13  2002/04/24 07:49:14  risler
* changed normalWalkMaxSpeed to walkMaxSpeed
*
* Revision 1.12  2002/04/23 17:45:16  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.11  2002/04/23 15:08:44  risler
* changed MotionRequest: walk instead of normalWalk,... and walkType added
*
* Revision 1.10  2002/04/16 15:59:10  dueffert
* no message
*
* Revision 1.9  2002/04/09 13:13:05  dueffert
* no message
*
* Revision 1.4  2002/04/02 15:38:12  dueffert
* minor odometry enhancements
*
* Revision 1.3  2002/03/29 18:12:27  dueffert
* JoystickMotionTester improved
*
* Revision 1.8  2002/03/29 16:04:42  dueffert
* schemes added
*
* Revision 1.7  2002/03/12 17:29:56  dueffert
* works fine now though response times could be better
*
* Revision 1.6  2002/03/11 18:32:19  dueffert
* JoystickMotionTester nearly complete
*
* Revision 1.5  2002/03/07 15:50:37  dueffert
* no message
*
* Revision 1.4  2002/03/06 16:13:41  dueffert
* JoystickMotionTester state machine implemented
*
* Revision 1.3  2002/03/05 20:05:09  dueffert
* joystick: polling instead of messages, sorry, but messages cant deal with all buttons/axes
*
* Revision 1.2  2002/03/04 14:29:24  dueffert
* no message
*
* Revision 1.1  2002/03/04 11:54:13  dueffert
* JoystickMotionTester added
*
*
*/
