/**
* @file InvKinParametersDlgBar.h
*
* Declaration of class InvKinParametersDlgBar
*
* @author Arthur Cesarz
* @author Matthias Hebbel
*/

#ifndef __InvKinParametersDlgBar_h_
#define __InvKinParametersDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "Modules/WalkingEngine/InvKinWalkingEngine.h"
#include "Representations/Motion/HeadControlMode.h"
#include "Representations/Motion/HeadMotionRequest.h"

/**
* class CInvKinParametersDlgBar
*
* This dialog allows convenient setting of the walking parameters
* for the InvKinWalking engine.
* @author Arthur Cesarz
* @author Matthias Hebbel
*/
class CInvKinParametersDlgBar : public CRobotControlDialogBar
{
public:
	CInvKinParametersDlgBar(CWnd* pParent = NULL);
  bool sendOnChange, walking;
  bool handleMessage(InMessage& message);

	//{{AFX_DATA(CInvKinParametersDlgBar)
	enum { IDD = IDD_DIALOG_BAR_INVKINPARAMETERS };
	CButton	    m_ButtonSend;
	CButton	    m_Checkbox;
  CButton	    m_Parent;
  CButton	    m_Offspring;

  CComboBox	  m_ComboFootMode;
  CEdit     	m_Value_foreHeight;
	CEdit     	m_Value_foreWidth;
	CEdit     	m_Value_foreCenterX;
	CEdit     	m_Value_hindHeight;
  CEdit     	m_Value_hindWidth;
	CEdit     	m_Value_hindCenterX;
	CEdit     	m_Value_foreFootLift;
	CEdit     	m_Value_hindFootLift;
	CEdit	      m_Value_foreFootTilt;
	CEdit	      m_Value_hindFootTilt;
	CEdit	      m_Value_legSpeedFactorX;
	CEdit	      m_Value_legSpeedFactorY;
	CEdit	      m_Value_legSpeedFactorR;
	CEdit	      m_Value_maxStepSizeX;
	CEdit	      m_Value_maxStepSizeY;
	CEdit	      m_Value_maxSpeedXChange;
	CEdit	      m_Value_maxSpeedYChange;
	CEdit	      m_Value_maxRotationChange;
	CEdit	      m_Value_counterRotation;
  CEdit	      m_Value_stepLen;
	CEdit	      m_Value_groundPhase[2];
	CEdit	      m_Value_liftPhase[2];
	CEdit	      m_Value_loweringPhase[2];
	CEdit       m_Value_legPhase[4];
	CEdit       m_Value_bodyShiftX;
	CEdit       m_Value_bodyShiftY;
	CEdit       m_Value_bodyShiftOffset;
	CEdit       m_Value_bodyTiltOffset;
 
  CEdit       m_ValueDistance;
  CEdit       m_ValueMutationStrength;

 	CSliderCtrl	m_Slider_foreHeight;
	CSliderCtrl	m_Slider_foreWidth;
	CSliderCtrl	m_Slider_foreCenterX;
	CSliderCtrl	m_Slider_hindHeight;
	CSliderCtrl	m_Slider_hindWidth;
	CSliderCtrl	m_Slider_hindCenterX;
	CSliderCtrl	m_Slider_foreFootLift;
	CSliderCtrl	m_Slider_hindFootLift;
	CSliderCtrl	m_Slider_foreFootTilt;
	CSliderCtrl	m_Slider_hindFootTilt;
	CSliderCtrl	m_Slider_legSpeedFactorX;
	CSliderCtrl	m_Slider_legSpeedFactorY;
	CSliderCtrl	m_Slider_legSpeedFactorR;
	CSliderCtrl	m_Slider_maxStepSizeX;
	CSliderCtrl	m_Slider_maxStepSizeY;
	CSliderCtrl	m_Slider_maxSpeedXChange;
	CSliderCtrl	m_Slider_maxSpeedYChange;
  CSliderCtrl	m_Slider_maxRotationChange;
	CSliderCtrl	m_Slider_counterRotation;
  CSliderCtrl	m_Slider_stepLen;
  CSliderCtrl	m_Slider_groundPhase[2];
	CSliderCtrl	m_Slider_liftPhase[2];
	CSliderCtrl	m_Slider_loweringPhase[2];
  CSliderCtrl m_Slider_legPhase[4];
  CSliderCtrl m_Slider_bodyShiftX;
  CSliderCtrl m_Slider_bodyShiftY;
  CSliderCtrl m_Slider_bodyShiftOffset;
  CSliderCtrl m_Slider_bodyTiltOffset;

//}}AFX_DATA

  //{{AFX_VIRTUAL(CInvKinParametersDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

protected:

	//{{AFX_MSG(CInvKinParametersDlgBar)
	afx_msg void OnCustomdrawSlider_foreHeight(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_foreWidth(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_foreCenterX(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_hindHeight(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_hindWidth(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_hindCenterX(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_foreFootLift(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_hindFootLift(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_foreFootTilt(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_hindFootTilt(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_legSpeedFactorX(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_legSpeedFactorY(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_legSpeedFactorR(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_maxStepSizeX(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_maxStepSizeY(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_maxSpeedXChange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_maxSpeedYChange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_maxRotationChange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_counterRotation(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_stepLen(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_groundPhase0(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_liftPhase0(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_loweringPhase0(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_groundPhase1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_liftPhase1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_loweringPhase1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_legPhase0(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_legPhase1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_legPhase2(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_legPhase3(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_bodyShiftX(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_bodyShiftY(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_bodyShiftOffset(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomdrawSlider_bodyTiltOffset(NMHDR* pNMHDR, LRESULT* pResult);

  afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
  afx_msg void OnSelchangeInvKinParComboFootMode();
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg void OnKillFocusEditCtrls();
  afx_msg void OnInvKinParCheckbox();
	afx_msg void OnChangeDistance();
  afx_msg void OnWalkParamLoad();
	afx_msg void OnWalkParamSave();
  afx_msg void OnWalkParamWalk();
  afx_msg void OnWalkParamStop();
  afx_msg void OnSelectParent();
  afx_msg void OnSelectOffspring();
  afx_msg void OnButtonSend();
  afx_msg void OnButtonMutate();
  afx_msg void OnChangeMutationStrength();
  //}}AFX_MSG
	DECLARE_MESSAGE_MAP()

  void setRanges();
  void setDefaults();
  void setSpeed();
  void initControls();
  int valueToSliderPos(double min, double max, double value);
  double sliderPosToValue(int position, double min, double max);
  void setSlider(double min, double max, double value,
                 CSliderCtrl	&slider, CEdit	&textctrl);
  void OnCustomdrawSlider(double min, double max, double& value,
                          CSliderCtrl	&slider, CEdit	&textctrl);
  void updateControls();
  CString walkParamToTextBuffer(InvKinWalkingParameters& w);
  void copyToClipboard();
  void pasteFromClipboard();
  void startWalking();
  unsigned long getFitness();
  void saveContextMenu();
  void readContextMenu();
  void OnWriteLogFile();
  void WriteLogFile();
  void tFormat(CString & buffer, double & paramName);
  void adaptMutationStrength();
  int getNumberOfEvolveValues();


  InvKinWalkingParameters minParam, maxParam, evolveParam, parentParam;
  InvKinWalkingParameters* pIndividual;
  char tmp[6];
  CString buffer;
  int distance, numberOfMutations, numberOfSuccessfulMutations;
  bool writeLogFile, autoMutationStrength;
  unsigned long startTime, lastSentTimeA, lastSentTimeB;
  MotionRequest motionRequest;
  HeadMotionRequest headMotionRequest;
  HeadControlMode headControlMode;
  double mutationStrength, loggedMutStrength;
  CString logFilePathAndName;

  CFont smallFont;
};

//{{AFX_INSERT_LOCATION}}

#endif //__InvKinParametersDlgBar_h_

/*
 * Change log :
 *
 * $Log: InvKinParametersDlgBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:27:35  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.6  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.5  2003/09/11 15:20:59  dueffert
 * passing of InvKinParameters added
 *
 * Revision 1.4  2003/09/01 15:57:42  dueffert
 * Genom and Individual merged
 *
 * Revision 1.3  2003/08/06 15:58:49  cesarz
 * added new walking parameters to InvKinDlgBar
 *
 * Revision 1.2  2003/07/24 12:44:19  risler
 * new walking engine Parameters loweringPhase, Phase parameters for fore and hind legs now, leaveAnytime, new footmode freeFormQuad
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.14  2003/05/12 00:29:11  dueffert
 * Depend now works for RobotControl too
 *
 * Revision 1.13  2003/02/18 22:56:03  hebbel
 * Selfadaption of mutation strength implemented
 *
 * Revision 1.12  2003/02/18 00:47:08  cesarz
 * Robot is able to start and stop walking now.
 *
 * Revision 1.11  2003/02/10 23:33:02  cesarz
 * some small bugfixes and changes.
 *
 * Revision 1.10  2003/02/09 22:23:14  cesarz
 * extended logFile support.
 *
 * Revision 1.9  2003/02/03 09:50:33  hebbel
 * Fitness calculation and mutation strength added.
 *
 * Revision 1.8  2003/02/02 22:47:38  hebbel
 * Implemented mutation of walkingparameters.
 *
 * Revision 1.7  2003/01/23 14:24:21  cesarz
 * added logfile support and some improvements.
 *
 * Revision 1.6  2003/01/09 15:22:32  cesarz
 * added registry support for the 1+1ES context menu
 *
 * Revision 1.5  2002/12/18 12:59:09  cesarz
 * 1+1 ES-contextmenu implemented
 *
 * Revision 1.4  2002/12/18 10:19:46  hebbel
 * OnePlusOne ES continued
 *
 * Revision 1.3  2002/12/10 15:39:16  hebbel
 * some extensions for the InvKinWalkingParametersDlgBar
 *
 * Revision 1.2  2002/12/05 22:59:57  cesarz
 * Leg phases added.
 *
 * Revision 1.1  2002/12/03 15:03:05  cesarz
 * InvKinParametersDlgBar added.
 *
*/