/**
* @file ImageViewerDlgBar.h
*
* Declaration of class CImageViewerDlgBar
*
* @author Matthias Jngel
*/ 

#ifndef __ImageViewerDlgBar_h_ 
#define __ImageViewerDlgBar_h_ 

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

/**
* class CImageViewerDlgBar
*
* The image viewer dialog displays images and debug drawings from the queue-ToGUI.
* Thus images from the robot, the log player, or the simulator are displayed.
* The Image Viewer has space for four images with fixed resolution.
* With the context menu different types of images and different debug drawings can be selected.
*
* @author Matthias Jngel
*/
class CImageViewerDlgBar : public CRobotControlDialogBar
{
public:
	CImageViewerDlgBar();

  ~CImageViewerDlgBar();

	//{{AFX_DATA(CImageViewerDlgBar)
	enum { IDD = IDD_DIALOG_BAR_IMAGEVIEWER };
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CImageViewerDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CImageViewerDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();

private:
  void changeLayout();
  
  /* the width of the dialog */
  int dialogWidth;

  /* the height of the dialog */
  int dialogHeight;

  /** The rect where the first image is painted*/
  CRect rectImage1;
  
  /** The rect where the second image is painted*/
  CRect rectImage2;
  
  /** The rect where the third image is painted*/
  CRect rectImage3;
  
  /** The rect where the fourth image is painted*/
  CRect rectImage4;

  /** The rect where the 5th image is painted*/
  CRect rectImage5;

  /** The rect where the 6th image is painted*/
  CRect rectImage6;

  /** The rect where the 7th image is painted*/
  CRect rectImage7;

  /** The rect where the 8th image is painted*/
  CRect rectImage8;
};

//{{AFX_INSERT_LOCATION}}

#endif // __ImageViewerDlgBar_h_ 

/*
 * Change log :
 * 
 * $Log: ImageViewerDlgBar.h,v $
 * Revision 1.1.1.1  2004/05/22 17:27:26  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/01/04 12:08:28  juengel
 * adaptation for larger images
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/08/25 17:22:29  juengel
 * ImageViewer displays 8 images now.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/11 23:46:33  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2002/09/20 23:28:33  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.2  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 */
