/**
* @file HeadMotionTesterDlgBar.cpp
*
* Implementation of class CHeadMotionTesterDlgBar
*
* @author Martin Ltzsch
*/

#include "StdAfx.h"
#include "Platform/SystemCall.h"
#include "HeadMotionTesterDlgBar.h"
#include "Tools/Actorics/RobotDimensions.h"
#include "RobotControlQueues.h"
#include "Tools/Math/Common.h"

CHeadMotionTesterDlgBar::CHeadMotionTesterDlgBar()
: CRobotControlDialogBar(IDD),sendAllowed(true)
{
  //{{AFX_DATA_INIT(CHeadMotionTesterDlgBar)
  //}}AFX_DATA_INIT
}


void CHeadMotionTesterDlgBar::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CHeadMotionTesterDlgBar)
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_RADIO_MODE, m_RadioMode);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_RADIO_REQUEST, m_RadioRequest);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_MODE_LIST, m_ControlModeList);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_TILT_STATIC, m_TiltStatic);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_TILTVALUE_EDIT, m_TiltValueEdit);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_SEND_BUTTON, m_SendButton);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_ROLL_STATIC, m_RollStatic);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_ROLLVALUE_EDIT, m_RollValueEdit);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_MOUTH_STATIC, m_MouthStatic);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_MOUTHVALUE_EDIT, m_MouthValueEdit);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_RESET_BUTTON, m_ResetButton);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_PAN_STATIC, m_PanStatic);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_PANVALUE_EDIT, m_PanValueEdit);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_TILT_SLIDER, m_TiltSlider);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_ROLL_SLIDER, m_RollSlider);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_PAN_SLIDER, m_PanSlider);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_MOUTH_SLIDER, m_MouthSlider);
  DDX_Control(pDX, IDC_HEADMOTIONTESTER_CHECK_ERS7, m_ERS7Check);
 //}}AFX_DATA_MAP
}



BEGIN_MESSAGE_MAP(CHeadMotionTesterDlgBar, CDynamicBarDlg)
//{{AFX_MSG_MAP(CHeadMotionTesterDlgBar)
ON_BN_CLICKED(IDC_HEADMOTIONTESTER_SEND_BUTTON, OnSend)
ON_WM_HSCROLL()
ON_BN_CLICKED(IDC_HEADMOTIONTESTER_RADIO_MODE, OnRadioMode)
ON_BN_CLICKED(IDC_HEADMOTIONTESTER_RADIO_REQUEST, OnRadioRequest)
ON_BN_CLICKED(IDC_HEADMOTIONTESTER_RESET_BUTTON, OnReset)
ON_LBN_SELCHANGE(IDC_HEADMOTIONTESTER_MODE_LIST, OnSelchangeModeList)
ON_LBN_DBLCLK(IDC_HEADMOTIONTESTER_MODE_LIST, OnDblclkModeList)
ON_BN_CLICKED(IDC_HEADMOTIONTESTER_CHECK_ERS7, OnERS7Check)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CHeadMotionTesterDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();
  
  AddSzControl(m_ControlModeList,mdResize,mdResize);
  AddSzControl(m_RadioMode,mdResize,mdNone); 
  AddSzControl(m_zEdit,mdRelative,mdRepos);
  AddSzControl(m_RadioRequest,mdResize,mdRepos); 
  AddSzControl(m_TiltStatic,mdNone,mdRepos);
  AddSzControl(m_TiltValueEdit,mdRepos,mdRepos);
  AddSzControl(m_RollStatic,mdNone,mdRepos);
  AddSzControl(m_RollValueEdit,mdRepos,mdRepos);
  AddSzControl(m_PanStatic,mdNone,mdRepos);
  AddSzControl(m_PanValueEdit,mdRepos,mdRepos);
  AddSzControl(m_MouthStatic,mdNone,mdRepos);
  AddSzControl(m_MouthValueEdit,mdRepos,mdRepos);
  AddSzControl(m_TiltSlider,mdResize,mdRepos);
  AddSzControl(m_RollSlider,mdResize,mdRepos);
  AddSzControl(m_PanSlider,mdResize,mdRepos);
  AddSzControl(m_MouthSlider,mdResize,mdRepos);
  AddSzControl(m_SendButton,mdRepos,mdRepos);
  AddSzControl(m_ResetButton,mdRepos,mdRepos);
  AddSzControl(m_ERS7Check,mdNone,mdRepos);
   
  m_TiltSlider.SetRange(toMicroRad(jointLimitNeckTiltN),toMicroRad(jointLimitNeckTiltP));
  m_PanSlider.SetRange(toMicroRad(jointLimitHeadPanN),toMicroRad(jointLimitHeadPanP));
  m_RollSlider.SetRange(toMicroRad(jointLimitHeadTiltN),toMicroRad(jointLimitHeadTiltP));
  m_MouthSlider.SetRange(toMicroRad(-pi_2),toMicroRad(0.0));
  
  for(int i=0;i<HeadControlMode::numOfHeadControlModes;i++)
    m_ControlModeList.AddString(HeadControlMode::getHeadControlModeName((HeadControlMode::HeadControlModes)i));
  
  Reset();
  
  return TRUE;
}


void CHeadMotionTesterDlgBar::OnSend() 
{
  static bool lastSentWasHeadControlMode=true;
  if ((sendAllowed)&&(SystemCall::getTimeSince(lastSentTime) > 150))
  {
    if (m_RadioMode.GetCheck())
    {
      lastSentWasHeadControlMode=true;
      
      getQueues().toPhysical.selectedRobot.out.bin << headControlMode;
      getQueues().toPhysical.selectedRobot.out.finishMessage(idHeadControlMode);

      getQueues().toSimulated.selectedRobot.out.bin << headControlMode;
      getQueues().toSimulated.selectedRobot.out.finishMessage(idHeadControlMode);
    } 
    else 
    {
      if (lastSentWasHeadControlMode)
      {
        headControlMode.headControlMode = HeadControlMode::none;
        
        getQueues().toPhysical.selectedRobot.out.bin << headControlMode;
        getQueues().toPhysical.selectedRobot.out.finishMessage(idHeadControlMode);

        getQueues().toSimulated.selectedRobot.out.bin << headControlMode;
        getQueues().toSimulated.selectedRobot.out.finishMessage(idHeadControlMode);
        
        lastSentWasHeadControlMode=false;

        //it takes some time after HeadControlMode::none to Cognition before own HeadMotionRequests can be used
        //Sleep(50);
      }
      
      getQueues().toPhysical.selectedRobot.out.bin << headMotionRequest;
      getQueues().toPhysical.selectedRobot.out.finishMessage(idHeadMotionRequest);

      getQueues().toSimulated.selectedRobot.out.bin << headMotionRequest;
      getQueues().toSimulated.selectedRobot.out.finishMessage(idHeadMotionRequest);
    } 
    
    lastSentTime = SystemCall::getCurrentSystemTime();
  }
}

void CHeadMotionTesterDlgBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  m_RadioMode.SetCheck(0);
  m_RadioRequest.SetCheck(1);
  
  m_ControlModeList.SetCurSel(-1);
  
  headMotionRequest.tilt = m_TiltSlider.GetPos();
  headMotionRequest.pan = -m_PanSlider.GetPos();
  headMotionRequest.roll = m_RollSlider.GetPos();
  headMotionRequest.mouth = m_MouthSlider.GetPos();

  char tiltval[50];
  char panval[50];
  char rollval[50];
  char mouthval[50];

  sprintf(tiltval, "%d", headMotionRequest.tilt);
  sprintf(panval, "%d", headMotionRequest.pan);
  sprintf(rollval, "%d", headMotionRequest.roll);
  sprintf(mouthval, "%d", headMotionRequest.mouth);

  m_TiltValueEdit.SetWindowText(tiltval);
  m_PanValueEdit.SetWindowText(panval);
  m_RollValueEdit.SetWindowText(rollval);
  m_MouthValueEdit.SetWindowText(mouthval);
  
  OnSend();
  
  CDynamicBarDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CHeadMotionTesterDlgBar::OnRadioMode() 
{
  m_ControlModeList.SetCurSel(headControlMode.headControlMode);
  OnSend();
}

void CHeadMotionTesterDlgBar::OnRadioRequest() 
{
  m_ControlModeList.SetCurSel(-1);
  OnSend();
}

void CHeadMotionTesterDlgBar::Reset() 
{
  sendAllowed=false;
  
  m_RadioMode.SetCheck(0);
  m_RadioRequest.SetCheck(1);
  
  m_ControlModeList.SetCurSel(-1);
  
  m_TiltSlider.SetPos(0);
  m_PanSlider.SetPos(0);
  m_RollSlider.SetPos(0);
  m_MouthSlider.SetPos(0);
  headMotionRequest.tilt = 0;
  headMotionRequest.pan = 0;
  headMotionRequest.roll = 0;
  headMotionRequest.mouth = 0;
  m_TiltValueEdit.SetWindowText("0");
  m_PanValueEdit.SetWindowText("0");
  m_RollValueEdit.SetWindowText("0");
  m_MouthValueEdit.SetWindowText("0");

  m_ERS7Check.SetCheck(1);
  
  sendAllowed=true;
}

void CHeadMotionTesterDlgBar::OnReset() 
{
  Reset();
  OnSend();
}

void CHeadMotionTesterDlgBar::OnSelchangeModeList() 
{
  m_RadioMode.SetCheck(1);
  m_RadioRequest.SetCheck(0);
  
  headControlMode.headControlMode = (HeadControlMode::HeadControlModes) m_ControlModeList.GetCurSel();
}

void CHeadMotionTesterDlgBar::OnDblclkModeList() 
{
  OnSend();
}

void CHeadMotionTesterDlgBar::OnERS7Check() 
{
	if (m_ERS7Check.GetCheck()) 
	{
		RobotDimensionsERS7 ers7;
		memcpy(&(RobotDimensions&) *this, &ers7, sizeof(RobotDimensions));
    m_RollStatic.SetWindowText("tilt 2:");
	}
	else
	{
		RobotDimensionsERS210 ers210;
		memcpy(&(RobotDimensions&) *this, &ers210, sizeof(RobotDimensions));
    m_RollStatic.SetWindowText("roll:");
	}

	m_TiltSlider.SetRange(toMicroRad(jointLimitNeckTiltN),toMicroRad(jointLimitNeckTiltP));
	m_PanSlider.SetRange(toMicroRad(jointLimitHeadPanN),toMicroRad(jointLimitHeadPanP));
	m_RollSlider.SetRange(toMicroRad(jointLimitHeadTiltN),toMicroRad(jointLimitHeadTiltP));
	m_MouthSlider.SetRange(toMicroRad(-pi_2),toMicroRad(0.0));
}


/*
* Change log :
* 
* $Log: HeadMotionTesterDlgBar.cpp,v $
* Revision 1.5  2004/06/09 13:12:00  thomas
* modified default-value for robotmodel in headmotion-tester
*
* Revision 1.4  2004/06/02 12:22:46  dueffert
* initial sending of HeadMotionRequest/HeadControlMode removed
*
* Revision 1.3  2004/05/27 17:13:38  jhoffman
* - renaming: tilt1 -> neckTilt,  pan -> headPan,  tilt2 -> headTilt
* - clipping included for setJoints
* - removed some microrad/rad-bugs
* - bodyPosture constructor and "=" operator fixed
*
* Revision 1.2  2004/05/23 12:08:26  loetzsch
* clean up in class HeadControlMode
*
* Revision 1.1.1.1  2004/05/22 17:27:15  cvsadm
* created new repository GT2004_WM
*
* Revision 1.11  2004/04/07 13:00:46  risler
* ddd checkin after go04 - second part
*
* Revision 1.2  2004/04/02 22:15:13  dthomas
* added mouth-slider to head-motion-tester
*
* Revision 1.1.1.1  2004/03/29 08:28:44  Administrator
* initial transfer from tamara
*
* Revision 1.10  2004/03/17 10:26:07  jhoffman
* - removed display problems in dialogs
* - brushed up ugly dialogs
*
* Revision 1.9  2004/03/16 14:00:22  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.8  2004/03/15 14:53:50  kerdels
* enabled reset for the "view"-edits too
*
* Revision 1.7  2004/03/15 14:48:10  kerdels
* modified Head Motion Tester Dialog to view the joint-values sent
*
* Revision 1.2  2004/03/15 17:11:40  hoffmann
* - added ATH2004HeadControl
* - added ATH2004LEDControl
* - headmotiontester shows "tilt2"
* - motion process updates odometry while no new robotPose is received, added to motion request
* - some ui adjustments
* - added member function to "field" to find out if robot is in own penalty area for use in the obstacles locator
*
* Revision 1.6  2004/01/30 15:28:50  fritsche
* ERS7-Chechbox re-added in HeadMotionTester
*
* Revision 1.5  2004/01/29 12:03:24  jhoffman
* UI changes:
* - Main menu entries renamed, reordered, added some new icons
* - delete-confirmation in settings and WLAN dialog
* - settings dialog uses icons, radio buttons added
* - WLAN dialog restructured
* - motion tester and head motion tested layout improved, stop button added
* - check boxes replaced by radio buttons where appropriate
*
* Revision 1.4  2004/01/28 18:22:59  fritsche
* ERS7-Chechbox added in HeadMotionTester
*
* Revision 1.3  2003/12/09 19:49:25  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.2  2003/12/05 14:20:06  jhoffman
* removed unused headcontrolmodes
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 11:40:12  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/27 15:50:59  dueffert
* dialog became smarter
*
* Revision 1.4  2003/05/11 23:46:33  dueffert
* Depend now works with RobotControl too
*
* Revision 1.3  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.2  2002/09/22 18:40:51  risler
* added new math functions, removed GTMath library
*
* Revision 1.1  2002/09/10 15:49:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.9  2002/08/29 13:25:10  loetzsch
* HeadMotionRequests can be sent again
*
* Revision 1.8  2002/07/23 13:43:36  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.7  2002/06/12 19:09:42  dueffert
* exactLookAtPoint added
*
* Revision 1.6  2002/06/08 18:11:28  jhoffman
* added "simple-look-at-point" head control
*
* Revision 1.5  2002/05/25 17:37:03  juengel
* 3D and offset for lookAtPoint
*
* Revision 1.4  2002/05/16 09:34:26  kosen
* no message
*
* Revision 1.3  2002/05/15 15:20:03  kosen
* xOffset and yOffset exchanged.
*
* Revision 1.2  2002/05/15 08:01:37  kosen
* offset in lookAtPoint added
*
* Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.11  2002/04/26 12:27:15  loetzsch
* removed the "default .... " radio from the head motion tester dialog bar
*
* Revision 1.10  2002/04/23 17:45:17  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.9  2002/03/20 15:15:29  kosen
* lookAtPoint added
*
* Revision 1.8  2002/02/12 16:34:49  risler
* finished MofTester
*
* Revision 1.7  2002/01/24 11:44:35  risler
* added WLAN Toolbar
*
* Revision 1.6  2002/01/23 14:18:18  risler
* send on dblclick
*
* Revision 1.5  2002/01/20 13:00:18  risler
* changed implementation of selecting default solution
*
* Revision 1.4  2002/01/19 21:36:26  risler
* added HeadMotionTester, HeadControlSelector
*
* Revision 1.3  2002/01/18 23:28:48  loetzsch
* provided access to queueToRobot and to queueToRobotControl,
* OnSend() added
*
* Revision 1.2  2001/12/10 17:47:09  risler
* change log added
*
*/


