/**
* @file GameToolBar.h
* 
* Definition of class CGameToolBar
*
* @author Martin Loetzsch
*/

#ifndef __GameToolBar_h_ 
#define __GameToolBar_h_ 

#include "StdAfx.h"
#include "RobotControlToolBar.h"
#include "Representations/RoboCup/GameControlData.h"


/**
* @class CGameToolBar
* A toolbar that simulates the RoboCupGameManager by Sony.
*/
class CGameToolBar: public CRobotControlToolBar
{
  DECLARE_DYNAMIC( CGameToolBar );
public:
  /** Constructor */
  CGameToolBar();

  /** Initializes the tool bar */
  virtual void Init(); 

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

  /** 
  * Handles selection change events for combo boxes. That function must be called from the 
  * main frame window for all combo boxes of the toolbar. 
  * @param nID the command id of the combo box
  * @return if the message was handled
  */
  virtual bool handleSelChange(UINT nID);

  /** Determines if the buttons have a text */
  virtual bool HasButtonText( UINT nID );

  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

  /** Should be called when the application is idle to check the position of the slider */
  virtual void OnIdle();

private:
  /** A combo box for the red score */
  CComboBox redScoreCombo;

  /** A combo box for the blue score */
  CComboBox blueScoreCombo;
    
  /** A slider for the game speed */
  CSliderCtrl gameSpeedSlider;

  /** Sends gameControlData to the queues */
  void send();

  /** The GlobalGameControlData to be sent */
  GlobalGameControlData globalGameControlData;

  /** The last position of the game speed slider */
  int lastGameSpeedSliderPosition;
};


#endif //__GameToolBar_h_ 

/*
* Change log :
* 
* $Log: GameToolBar.h,v $
* Revision 1.1.1.1  2004/05/22 17:27:12  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/03/25 17:37:05  loetzsch
* adopted game toolbar to new game controller
*
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:28:23  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2003/05/11 23:46:33  dueffert
* Depend now works with RobotControl too
*
* Revision 1.3  2003/03/20 20:34:21  loetzsch
* Game Toolbar now can adjust the game speed
*
* Revision 1.2  2003/03/05 11:09:49  loetzsch
* added class GlobalGameControlData
* the Game Toolbar now sents GlobalGameControlData
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.6  2002/08/30 17:13:56  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.5  2002/08/13 12:55:10  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
*
* Revision 1.4  2002/08/07 10:50:21  loetzsch
* - removed direct access to the dialogs
* - faster starting of RobotControl application and main window
* - general clean up
*
* Revision 1.3  2002/07/23 13:43:36  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.2  2002/06/10 12:00:41  dueffert
* commentation bugs fixed
*
* Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.2  2002/05/05 22:12:42  loetzsch
* GameControlData can now be sent from the Game toolbar to BehaviorControl
*
* Revision 1.1  2002/05/05 18:53:02  loetzsch
* removed Modules toolbar
* added Game toolbar
*
*/
