/**
* @file GameToolBar.cpp
* 
* Implementation of class CGameToolBar
*
* @author Martin Loetzsch
*/

#include "StdAfx.h"
#include "resource.h"
#include "GameToolBar.h"
#include "RobotControlQueues.h"

IMPLEMENT_DYNAMIC( CGameToolBar, CToolBarEx )

CGameToolBar::CGameToolBar()
{
  for (int i=0; i<4; i++)
  {
    globalGameControlData.penaltiesBlueTeam[i] = GlobalGameControlData::notPenalized;
    globalGameControlData.penaltiesRedTeam[i] = GlobalGameControlData::notPenalized;
  }
}

void CGameToolBar::Init()
{
  static TBBUTTONEX tbButtons[] =
  {
    { {  0, IDC_GAME_INITIAL, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  1, IDC_GAME_READY, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  2, IDC_GAME_SET, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  3, IDC_GAME_PLAYING, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  4, IDC_GAME_FINISHED, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  5, IDC_GAME_PENALIZED, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { {  6, IDC_GAME_KICKOFF_RED, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  7, IDC_GAME_KICKOFF_BLUE, TBSTATE_ENABLED | TBSTATE_CHECKED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { { 10, IDC_GAME_RED_GOAL, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0 , 0 }, true},
    { {  8, IDC_GAME_RED_SCORE, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { {  9, IDC_GAME_BLUE_SCORE, TBSTATE_ENABLED , TBSTYLE_BUTTON,    0, 0 }, true },
    { { 11, IDC_GAME_BLUE_GOAL, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0 , 0 }, true},
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { { 12, IDC_GAME_SPEED, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0 , 0 }, true},
  };
  
  SetBitmaps( IDB_GAME, IDB_GAME_COLD);
  SetButtons( sizeof( tbButtons ) / sizeof( tbButtons[ 0 ] ), tbButtons);
  
  AddCombo(&redScoreCombo,IDC_GAME_RED_SCORE,37);
  AddCombo(&blueScoreCombo,IDC_GAME_BLUE_SCORE,37);
  
  for (int i=0;i<20;i++)
  {
    char str[20];
    itoa(i,str,10);
    redScoreCombo.AddString(str);
    blueScoreCombo.AddString(str);
  }
  
  redScoreCombo.SetCurSel(0);
  blueScoreCombo.SetCurSel(0);

  AddSlider(&gameSpeedSlider,IDC_GAME_SPEED,90);
  gameSpeedSlider.SetRange(10,100);
  gameSpeedSlider.SetPos(100);
  lastGameSpeedSliderPosition = 100;
}

bool CGameToolBar::HasButtonText( UINT nID )
{
  switch (nID)
  {
  case IDC_GAME_SPEED: return true;
  default: return false;
  }
}

void CGameToolBar::send()
{
  getQueues().toPhysical.allRobots.out.bin << globalGameControlData;
  getQueues().toPhysical.allRobots.out.finishMessage(idGlobalGameControlData);
  
  getQueues().toSimulated.allRobots.out.bin << globalGameControlData;
  getQueues().toSimulated.allRobots.out.finishMessage(idGlobalGameControlData);
}

void CGameToolBar::updateUI(CCmdUI* pCmdUI)
{
  pCmdUI->Enable(TRUE);

  switch(pCmdUI->m_nID)
  {
  case IDC_GAME_READY:
    pCmdUI->SetCheck(globalGameControlData.state == GlobalGameControlData::ready?TRUE:FALSE);
    break;
  case IDC_GAME_PLAYING:
    pCmdUI->SetCheck(globalGameControlData.state == GlobalGameControlData::playing?TRUE:FALSE);
    break;
  case IDC_GAME_FINISHED:
    pCmdUI->SetCheck(globalGameControlData.state == GlobalGameControlData::finished?TRUE:FALSE);
    break;
  case IDC_GAME_SET:
    pCmdUI->SetCheck(globalGameControlData.state == GlobalGameControlData::set?TRUE:FALSE);
    break;
  case IDC_GAME_PENALIZED:
    pCmdUI->SetCheck(globalGameControlData.state == GlobalGameControlData::penalized?TRUE:FALSE);
    break;
  case IDC_GAME_INITIAL:
    pCmdUI->SetCheck(globalGameControlData.state == GlobalGameControlData::initial?TRUE:FALSE);
    break;
  case IDC_GAME_KICKOFF_RED:
    pCmdUI->SetCheck(globalGameControlData.kickoff == GlobalGameControlData::kickoffRedTeam?TRUE:FALSE);
    break;
  case IDC_GAME_KICKOFF_BLUE:
    pCmdUI->SetCheck(globalGameControlData.kickoff == GlobalGameControlData::kickoffBlueTeam?TRUE:FALSE);
    break;
  default:
    return;
  }
}

bool CGameToolBar::handleCommand(UINT command)
{
  switch(command)
  {
  case IDC_GAME_READY:
    globalGameControlData.state = GlobalGameControlData::ready;
    send();
    return true;
  case IDC_GAME_PLAYING:
    globalGameControlData.state = GlobalGameControlData::playing;
    send();
    return true;
  case IDC_GAME_FINISHED:
    globalGameControlData.state = GlobalGameControlData::finished;
    send();
    return true;
  case IDC_GAME_INITIAL:
    globalGameControlData.state = GlobalGameControlData::initial;
    send();
    return true;
  case IDC_GAME_SET:
    globalGameControlData.state = GlobalGameControlData::set;
    send();
    return true;
  case IDC_GAME_PENALIZED:
    globalGameControlData.state = GlobalGameControlData::penalized;
    send();
    return true;
  case IDC_GAME_KICKOFF_RED:
    globalGameControlData.kickoff = GlobalGameControlData::kickoffRedTeam;
    send();
    return true;
  case IDC_GAME_KICKOFF_BLUE:
    globalGameControlData.kickoff = GlobalGameControlData::kickoffBlueTeam;
    send();
    return true;
  case IDC_GAME_BLUE_GOAL:
    globalGameControlData.kickoff = GlobalGameControlData::kickoffRedTeam;
    globalGameControlData.blueScore++;
    blueScoreCombo.SetCurSel(globalGameControlData.blueScore);
    globalGameControlData.state = GlobalGameControlData::ready;
    send();
    return true;
  case IDC_GAME_RED_GOAL:
    globalGameControlData.kickoff = GlobalGameControlData::kickoffBlueTeam;
    globalGameControlData.redScore++;
    redScoreCombo.SetCurSel(globalGameControlData.redScore);
    globalGameControlData.state = GlobalGameControlData::ready;
    send();
    return true;
  default:
    return false;
  }
}

bool CGameToolBar::handleSelChange(UINT nID)
{
  switch (nID)
  {
  case IDC_GAME_RED_SCORE:
    globalGameControlData.redScore = redScoreCombo.GetCurSel();
    send();
    return true;
  case IDC_GAME_BLUE_SCORE:
    globalGameControlData.blueScore = blueScoreCombo.GetCurSel();
    send();
    return true;
  default:
    return false;
  }
}

void CGameToolBar::OnIdle()
{
  int newGameSpeedSliderPosition = gameSpeedSlider.GetPos();
  if (lastGameSpeedSliderPosition != newGameSpeedSliderPosition)
  {
    lastGameSpeedSliderPosition = newGameSpeedSliderPosition;
    getQueues().toSimulated.allRobots.out.bin << (double)lastGameSpeedSliderPosition / 100.0;
    getQueues().toSimulated.allRobots.out.finishMessage(idGameSpeed);

    getQueues().toPhysical.allRobots.out.bin << (double)lastGameSpeedSliderPosition / 100.0;
    getQueues().toPhysical.allRobots.out.finishMessage(idGameSpeed);
  }
}

/*
* Change log :
* 
* $Log: GameToolBar.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:27:12  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/03/25 17:37:05  loetzsch
* adopted game toolbar to new game controller
*
* Revision 1.3  2003/12/09 19:49:25  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.6  2003/05/11 23:46:33  dueffert
* Depend now works with RobotControl too
*
* Revision 1.5  2003/03/20 20:34:21  loetzsch
* Game Toolbar now can adjust the game speed
*
* Revision 1.4  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.3  2003/03/05 11:09:49  loetzsch
* added class GlobalGameControlData
* the Game Toolbar now sents GlobalGameControlData
*
* Revision 1.2  2003/01/18 21:46:38  loetzsch
* beatified the game toolbar
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.5  2002/08/30 19:37:52  loetzsch
* changed comment
*
* Revision 1.4  2002/08/13 12:55:10  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
*
* Revision 1.3  2002/08/07 10:50:21  loetzsch
* - removed direct access to the dialogs
* - faster starting of RobotControl application and main window
* - general clean up
*
* Revision 1.2  2002/07/23 13:43:36  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.2  2002/05/05 22:12:42  loetzsch
* GameControlData can now be sent from the Game toolbar to BehaviorControl
*
* Revision 1.1  2002/05/05 18:53:02  loetzsch
* removed Modules toolbar
* added Game toolbar
*
*
*/
