/**
* @file DebugMessageGeneratorDlgBar.cpp
*
* Dialog to create debug messages by a text input that are not
* generated by other dialogs.
*
* @author Max Risler
*
*/

#include "StdAfx.h"
#include "DebugMessageGeneratorDlgBar.h"

#include "Modules/WalkingEngine/InvKinWalkingEngine.h"
#include "Representations/Sound/SoundRequest.h"
#include "Representations/Motion/PIDData.h"
#include "RobotControlQueues.h"
#include "Tools/Streams/InStreams.h"
#include "Tools/Debugging/GenericDebugData.h"

CDebugMessageGeneratorDlgBar::CDebugMessageGeneratorDlgBar()

	: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(CDebugMessageGeneratorDlgBar)
	//}}AFX_DATA_INIT
}


void CDebugMessageGeneratorDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDebugMessageGeneratorDlgBar)
	DDX_Control(pDX, IDC_DEBUGMESSAGEGENERATOR_ERROR, m_error);
	DDX_Control(pDX, IDC_DEBUGMESSAGEGENERATOR_SEND, m_sendButton);
	DDX_Control(pDX, IDC_DEBUGMESSAGEGENERATOR_EDIT, m_edit);
	DDX_Control(pDX, IDC_DEBUGMESSAGEGENERATOR_COMBO, m_combo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDebugMessageGeneratorDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CDebugMessageGeneratorDlgBar)
	ON_BN_CLICKED(IDC_DEBUGMESSAGEGENERATOR_SEND, OnSend)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CDebugMessageGeneratorDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();

  AddSzControl(m_combo,mdResize,mdNone);
  AddSzControl(m_edit,mdResize,mdResize);
  AddSzControl(m_sendButton,mdRepos,mdRepos);
  AddSzControl(m_error,mdNone,mdRepos);

  m_combo.AddString("Generic Debug Data");
  m_combo.AddString("InvKinWalkingParameters");
  m_combo.AddString("AcousticMessage");
  m_combo.AddString("PIDData");
  m_combo.AddString("Body Offsets");

  m_combo.SetCurSel(0);

  return TRUE;

}

void CDebugMessageGeneratorDlgBar::OnSend() 
{
  CString input;
  m_edit.GetWindowText(input);

  InConfigMemory inputStream(input.GetBuffer(input.GetLength()),input.GetLength());

  switch (m_combo.GetCurSel())
  {
    case 0: // Generic Debugging Data
      {
        GenericDebugData d;

        int z;
        inputStream >> z;
        d.id = (GenericDebugData::GenericDebugDataID )z;
        for(int i = 0; i < 10; i++)
        {
          if (inputStream.eof()) 
            d.data[i] = -1;
          else
            inputStream >> d.data[i];
        }

        if (inputStream.eof() && i > 0)
        {
          getQueues().toPhysical.selectedRobot.out.bin << d;
          getQueues().toPhysical.selectedRobot.out.finishMessage(idGenericDebugData);

          getQueues().toSimulated.selectedRobot.out.bin << d;
          getQueues().toSimulated.selectedRobot.out.finishMessage(idGenericDebugData);

          m_error.ShowWindow(SW_HIDE);
        } 
        else 
        {
          m_error.ShowWindow(SW_NORMAL);
        }
      }
      break;


    case 1: //InvKinWalkingParameters
      {
        InvKinWalkingParameters p;
        int footMode;
        if (
          (!(inputStream >> footMode).eof()) &&
          footMode >= 0 &&
          footMode < InvKinWalkingParameters::numOfFootModes &&
          (!(inputStream >> p.foreHeight).eof()) &&
          (!(inputStream >> p.foreWidth).eof()) &&
          (!(inputStream >> p.foreCenterX).eof()) &&
          (!(inputStream >> p.hindHeight).eof()) &&
          (!(inputStream >> p.hindWidth).eof()) &&
          (!(inputStream >> p.hindCenterX).eof()) &&
          (!(inputStream >> p.foreFootLift).eof()) &&
          (!(inputStream >> p.hindFootLift).eof()) &&
          (!(inputStream >> p.foreFootTilt).eof()) &&
          (!(inputStream >> p.hindFootTilt).eof()) &&
          (!(inputStream >> p.legSpeedFactorX).eof()) &&
          (!(inputStream >> p.legSpeedFactorY).eof()) &&
          (!(inputStream >> p.legSpeedFactorR).eof()) &&
          (!(inputStream >> p.maxStepSizeX).eof()) &&
          (!(inputStream >> p.maxStepSizeY).eof()) &&
          (!(inputStream >> p.maxSpeedXChange).eof()) &&
          (!(inputStream >> p.maxSpeedYChange).eof()) &&
          (!(inputStream >> p.maxRotationChange).eof()) &&
          (!(inputStream >> p.counterRotation).eof()) &&
          (!(inputStream >> p.stepLen).eof()) &&
          (!(inputStream >> p.groundPhase[0]).eof()) &&
          (!(inputStream >> p.liftPhase[0]).eof()) &&
          (!(inputStream >> p.loweringPhase[0]).eof()) &&
          (!(inputStream >> p.groundPhase[1]).eof()) &&
          (!(inputStream >> p.liftPhase[1]).eof()) &&
          (!(inputStream >> p.loweringPhase[1]).eof()) &&
          (!(inputStream >> p.legPhase[0]).eof()) &&
          (!(inputStream >> p.legPhase[1]).eof()) &&
          (!(inputStream >> p.legPhase[2]).eof()) &&
          (!(inputStream >> p.legPhase[3]).eof()) &&
          (!(inputStream >> p.bodyShiftX).eof()) &&
          (!(inputStream >> p.bodyShiftY).eof()) &&
          (inputStream >> p.bodyShiftOffset).eof()
          )
        {
          p.footMode = (InvKinWalkingParameters::FootMode)footMode;
          p.headTilt = p.headPan = p.headRoll = p.mouth = jointDataInvalidValue;

          getQueues().toPhysical.selectedRobot.out.bin << p;
          getQueues().toPhysical.selectedRobot.out.finishMessage(idInvKinWalkingParameters);

          getQueues().toSimulated.selectedRobot.out.bin << p;
          getQueues().toSimulated.selectedRobot.out.finishMessage(idInvKinWalkingParameters);

          m_error.ShowWindow(SW_HIDE);
        } else
          m_error.ShowWindow(SW_NORMAL);
      }

      break;

    case 2: // Acoustic message
      {
        int soundID;

        if (
          input.GetLength() > 0 &&
          (inputStream >> soundID).eof() &&
          soundID >= 0 &&
          soundID < SoundRequest::numOfSoundIDs
          )
        {
          SoundRequest sr;
          sr.soundID = (SoundRequest::SoundID)soundID;

          getQueues().toPhysical.selectedRobot.out.bin << sr;
          getQueues().toPhysical.selectedRobot.out.finishMessage(idSoundRequest);

          getQueues().toSimulated.selectedRobot.out.bin << sr;
          getQueues().toSimulated.selectedRobot.out.finishMessage(idSoundRequest);

          m_error.ShowWindow(SW_HIDE);
        } else 
          m_error.ShowWindow(SW_NORMAL);
      }

      break;
    case 3: // PIDData
      {
        PIDData pidData;

        for(int i=0;i<JointData::numOfJoint;i++)
        {
          if (inputStream.eof()) break;
          inputStream >> pidData.p[i];
          if (inputStream.eof()) break;
          inputStream >> pidData.i[i];
          if (inputStream.eof()) break;
          inputStream >> pidData.d[i];
        }
        if (inputStream.eof() && i==JointData::numOfJoint)
        {
          getQueues().toPhysical.selectedRobot.out.bin << pidData;
          getQueues().toPhysical.selectedRobot.out.finishMessage(idPIDData);

          getQueues().toSimulated.selectedRobot.out.bin << pidData;
          getQueues().toSimulated.selectedRobot.out.finishMessage(idPIDData);

          m_error.ShowWindow(SW_HIDE);
        } else 
          m_error.ShowWindow(SW_NORMAL);
      }
      break;

    case 4: // Body Offsets
      {
        GenericDebugData d;
        d.id = GenericDebugData::bodyOffsets;
        inputStream >> d.data[0] >> d.data[1];
        getQueues().toPhysical.selectedRobot.out.bin << d;
        getQueues().toPhysical.selectedRobot.out.finishMessage(idBodyOffsets);
        getQueues().toSimulated.selectedRobot.out.bin << d;
        getQueues().toSimulated.selectedRobot.out.finishMessage(idBodyOffsets);
        m_error.ShowWindow(SW_HIDE);
      }
      break;
  }
}

/*
 * Change log :
 * 
 * $Log: DebugMessageGeneratorDlgBar.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:27:12  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/09 19:49:25  loetzsch
 * Renamed some of the main queues of RobotControl.
 *
 * Added possibility to send messages to specific simulated or physical robots.
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.4  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.3  2003/09/26 11:40:12  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.2  2003/07/24 12:44:19  risler
 * new walking engine Parameters loweringPhase, Phase parameters for fore and hind legs now, leaveAnytime, new footmode freeFormQuad
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.11  2003/05/11 23:46:32  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.10  2003/05/03 16:20:43  roefer
 * bodyOffsets generic debug data
 *
 * Revision 1.9  2003/03/05 17:09:27  loetzsch
 * redesign of the queues and debug key tables in RobotControl
 *
 * Revision 1.8  2003/01/22 22:16:58  jhoffman
 * no message
 *
 * Revision 1.7  2003/01/17 12:48:18  jhoffman
 * added GenericDebugData
 * changes to the TestDataGenerator towards using sliders, min/max, and other cool stuff
 *
 * Revision 1.6  2003/01/16 09:54:49  jhoffman
 * Added "Generic Debug Data" data type. This can be used
 * for quick and dirty optimization and debugging, e.g. to send
 * parameters to a module through WLAN to adjust it's settings.
 * The DebugMessageGenerator is used to for parsing and
 * sendig the data
 *
 * Revision 1.5  2002/12/11 14:58:46  risler
 * InvKinWalkingEngine:
 * added body shift parameters,
 * and rotation center correction value
 *
 * Revision 1.4  2002/11/28 16:57:34  risler
 * added leg phase parameters for variable gaits
 *
 * Revision 1.3  2002/11/19 17:10:54  risler
 * DebugMessageGenerator uses InConfigMemory
 * Can handle comments now
 *
 * Revision 1.2  2002/09/22 18:40:51  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.1  2002/09/10 15:49:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.6  2002/08/21 11:50:44  cesarz
 * GT2001PlayersPerceptor, BerlinSelfLocator, GT2001WalkingEngine,
 * DoWalkingEngine, FuzzyBehaviorControl, BremenGOBehaviorControl,
 * FuzzyBehaviortesterdlgbar and Behaviortesterdlgbar removed.
 *
 * Revision 1.5  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.4  2002/05/31 15:20:33  risler
 * InvKin and GT2001 parameters were exchanged
 *
 * Revision 1.3  2002/05/15 15:47:29  risler
 * added debug message AcousticMessage, DebugMessageGenerator generates AcousticMessage
 *
 * Revision 1.2  2002/05/11 08:07:43  risler
 * added head and mouth joints to InvKinWalkingParameters
 *
 * Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.10  2002/05/02 18:17:03  risler
 * added InvKin Parameters fore/hindFootTilt
 *
 * Revision 1.9  2002/04/30 16:22:34  risler
 * added InvKin Parameters footMode, footTilt
 *
 * Revision 1.8  2002/04/26 13:35:33  risler
 * DarmstadtGOWalkingEngine renamed to InvKinWalkingEngine
 * added InvKinParameterSets
 *
 * Revision 1.7  2002/04/25 14:50:34  kallnik
 * changed double/float to double
 * added several #include GTMath
 *
 * PLEASE use double
 *
 * Revision 1.6  2002/04/23 17:45:17  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.5  2002/04/23 15:07:20  jhoffman
 * added some pre GO fourier stuff
 *
 * Revision 1.4  2002/04/17 17:04:40  risler
 * Darmstadt GO
 *
 * Revision 1.3  2002/04/09 16:46:01  risler
 * added DarmstadtGOWalkingEngine
 *
 * Revision 1.2  2002/04/04 14:48:45  risler
 * added DebugMessageGenerator
 *
 * Revision 1.1  2002/04/04 11:04:00  risler
 * added DebugMessageGenerator
 *
 *
 */

