/**
* @file DebugKeysToolBar.h
* 
* Definition of class CDebugKeysToolbar
*
* @author Martin Ltzsch
*/

#ifndef __DebugKeysToolBar_h_ 
#define __DebugKeysToolBar_h_ 

#include "StdAfx.h"
#include "RobotControlToolBar.h"
#include "Tools/Debugging/QueueFillRequest.h"

/**
* @class CDebugKeysToolBar
* A ToolBar for debug keys
*/
class CDebugKeysToolBar: public CRobotControlToolBar
{
  DECLARE_DYNAMIC( CDebugKeysToolBar );
public:
  /** Initializes the tool bar */
  virtual void Init(); 

  /** 
  * Handles control notifications which arrived in the main frame 
  * @param command The id of the control, menu, accelerator etc.
  * @return If the command was handled.
  */
  virtual bool handleCommand(UINT command);

  /** 
  * Handles selection change events for combo boxes. That function must be called from the 
  * main frame window for all combo boxes of the toolbar. 
  * @param nID the command id of the combo box
  * @return if the message was handled
  */
  virtual bool handleSelChange(UINT nID);

  /** 
  * Handles change events for edit controls. That function must be called from the main frame 
  * window for all edit controls of the toolbar. 
  * @param nID the command id of the edit control
  * @return if the message was handled
  */
  virtual bool handleEditChange(UINT nID);

  /** Determines if the buttons have a text */
  virtual bool HasButtonText( UINT nID );

  /** 
  * Enables the controls in the toolbar. 
  * This function is called from the main window for all controls. 
  * @param pCmdUI An interface to the control that allows enabling/disabling, checking etc.
  */
  virtual void updateUI(CCmdUI* pCmdUI);

protected:
  /** determines if the debug table for the robot or for the local processes is edited */
  bool editForRobot;

  /** A combo box for the debug keys */
  CComboBox m_wndDebugKeysCombo;
  /** A edit control for the parameter n of a debug key */
  CEdit m_wndDebugKeysNEdit;
  /** A dummy combo box for the edit control */
  CComboBox m_wndDebugKeysNEditDummyCombo;

  /** A control for editing the duration of the debug sender blocking*/
  CEdit m_wndDebugKeysSecondsEdit;
  /** A dummy combo box for the edit control */
  CComboBox m_wndDebugKeysSecondsEditDummyCombo;

  /** Handles a selchange of the debug keys combo */
  void OnDebugKeyComboSelChange();
public:
  /** QueueFillRequest to be used */
  QueueFillRequest queueFillRequest;
};

#endif //__DebugKeysToolBar_h_ 

/*
* Change log :
* 
* $Log: DebugKeysToolBar.h,v $
* Revision 1.1.1.1  2004/05/22 17:27:11  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 11:40:12  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/11 23:46:32  dueffert
* Depend now works with RobotControl too
*
* Revision 1.4  2003/04/14 16:17:33  loetzsch
* ATH after GermanOpen CVS merge
*
* Revision 1.2  2003/04/10 12:08:32  juengel
* queueFillRequest is public now.
*
* Revision 1.1.1.1  2003/04/09 14:22:43  loetzsch
* started Aibo Team Humboldt's GermanOpen CVS
*
* Revision 1.3  2002/11/19 12:57:55  dueffert
* queuefillrequest added, debugkey toolbar extended, memorystick toolbar removed
*
* Revision 1.2  2002/11/18 10:35:05  juengel
* Added "block debug sender" mechanism
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.5  2002/08/30 17:13:56  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.4  2002/08/13 12:55:10  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
*
* Revision 1.3  2002/07/23 13:43:36  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.2  2002/06/10 12:00:41  dueffert
* commentation bugs fixed
*
* Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.10  2002/04/23 17:45:17  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.9  2002/02/18 12:05:18  loetzsch
* Percept visualization continued
*
* Revision 1.8  2002/02/12 16:34:49  risler
* finished MofTester
*
* Revision 1.7  2002/01/30 17:32:00  loetzsch
* Absturz wenn kleingeschoben ausgebaut
*
* Revision 1.6  2002/01/09 18:35:06  juengel
* Hack eingebaut, damit OUTPUT im RobotControl funktioniert.
*
* Revision 1.5  2001/12/16 17:18:55  loetzsch
* DebugKeyToolBar wieder groe Member Funktionsnamen eingebaut, Technote zu Toolbars
*
* Revision 1.4  2001/12/14 12:26:12  loetzsch
* CameraParameters Toolbar weitergemacht
*
* Revision 1.3  2001/12/13 15:03:02  loetzsch
* DebugKeyToolBar fertig
*
* Revision 1.2  2001/12/13 12:58:16  loetzsch
* MemoryStick ToolBar hinzugefgt und an anderen Toolbars herumgebastelt
*
* Revision 1.1  2001/12/12 15:21:09  juengel
* CDebugKeyToolBar in eigenes .cpp und .h File verlagert.
*
*
*/
