/**
* @file ColorSpaceDlgBar.h
*
* Declaration of class CColorSpaceDlgBar.
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/
#ifndef __ColorSpaceDlgBar_h_
#define __ColorSpaceDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Perception/Image.h"
#include "Representations/Perception/ColorTable64.h"
#include "Modules/ImageProcessor/ImageProcessorTools/ColorTableCuboids.h"
#include "Modules/ImageProcessor/ImageProcessorTools/ColorTableReferenceColor.h"

/**
* A docking window for the color space viewer
*
* @author Matthias Jngel
*/
class CColorSpaceDlgBar : public CRobotControlDialogBar
{
// Construction
public:
	CColorSpaceDlgBar();	// standard constructor

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);

  /** renders the scene with the current rotation parameters*/
  void renderScene();
  HDC m_hDC;

// Dialog Data
	//{{AFX_DATA(CColorSpaceDlgBar)
	enum { IDD = IDD_DIALOG_BAR_COLOR_SPACE };
	CStatic	m_static4;
	CStatic	m_static3;
	CStatic	m_static2;
	CStatic	m_static1;
	CSliderCtrl	m_slider4;
	CSliderCtrl	m_slider3;
	CSliderCtrl	m_slider2;
	CSliderCtrl	m_slider1;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CColorSpaceDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CColorSpaceDlgBar)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
private:
  void setSliders();

  void paintColorTable();
  void paintBoundingCube();

  /** 
  * Is called when a configuration is loaded. Can be used by the dialogs and 
  * bars to load configuration dependand settings.
  * @param sectionName The registry section for the current configuration
  */
  virtual void OnConfigurationLoad(CString sectionName);

  /** 
  * Is called when a configuration is saved. Can be used by the dialogs and 
  * bars to save configuration dependand settings.
  * @param sectionName The registry section for the current configuration
  */
  virtual void OnConfigurationSave(CString sectionName);

  /** the image*/
  Image image;

	// Mouse
	CPoint m_LeftDownPos;
	BOOL m_LeftButtonDown;

	// Interaction
	double m_xRotate;
	double m_yRotate;
	double m_zRotate;

  HGLRC m_hGLContext;

  /** stores the current display mode*/
  enum ColorModel {yuv, rgb, tsl, hsi} colorModel;
  enum Selection {yuvUsage, yUsage, uUsage, vUsage} selection;
  enum DisplayMode {pixels, polygons, nothing} displayMode;
  enum BackGroundColor {gray, white} backGroundColor;

  bool paintFullCube;
  bool showColorTable;
  bool showColorTableCuboids;
  bool showColorTableReferenceColor;
  bool initialized;


  int y1;
  int width_y;
  int x1;
  int width_x;

  ColorTable64 colorTable64;
  ColorTableCuboids colorTableCuboids;
  ColorTableReferenceColor colorTableReferenceColor;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined ColorSpaceDlgBar

/*
 * Change log :
 * $Log: ColorSpaceDlgBar.h,v $
 * Revision 1.2  2004/05/22 20:47:26  juengel
 * Removed gridImageProcessor2 specific stuff.
 *
 * Revision 1.1.1.1  2004/05/22 17:27:09  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.5  2004/01/31 00:07:45  dueffert
 * dialog now works with nvidia cards too
 *
 * Revision 1.4  2004/01/10 12:39:57  juengel
 * Selections are stored dependent on configuration.
 *
 * Revision 1.3  2003/12/15 11:46:14  juengel
 * Introduced CameraInfo
 *
 * Revision 1.2  2003/10/23 07:21:20  juengel
 * Renamed ColorTableAuto to ColorTableReferenceColor.
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.4  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.3  2003/08/18 11:52:31  juengel
 * Improved display of colorTableReferenceColor.
 *
 * Revision 1.2  2003/07/21 13:43:16  juengel
 * Moved ColorTableReferenceColor and GoalRecognizer to ImageProcessorTools.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.14  2003/05/11 23:46:32  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.13  2003/05/05 12:18:08  juengel
 * Changes in GIP2Parameters and ColorTableReferenceColor.
 *
 * Revision 1.12  2003/04/03 18:50:09  juengel
 * Improved AutoCalibration.
 *
 * Revision 1.11  2003/04/01 19:28:12  juengel
 * Added displayMode nothing
 *
 * Revision 1.10  2003/04/01 14:00:25  juengel
 * Added visualization of color tables.
 *
 * Revision 1.9  2003/02/27 12:56:56  juengel
 * Added sub cube functionality.
 *
 * Revision 1.8  2003/02/24 22:33:04  juengel
 * ColorSpace Dialog can convert images to RGB, HSI and TSL.
 *
 * Revision 1.7  2002/10/10 13:09:50  loetzsch
 * First experiments with the PSD Sensor
 * - SensorDataProcessor now calculates PSDPercept
 * - Added the PerceptBehaviorControl solution PSDTest
 * - Added the RadarViewer3D to RobotControl, which can display the Points3D structure
 *
 * Revision 1.6  2002/09/22 18:40:51  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.5  2002/09/20 23:28:34  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.4  2002/09/19 12:05:49  loetzsch
 * MathLib -> Mathlib
 *
 * Revision 1.3  2002/09/17 23:55:23  loetzsch
 * - unraveled several datatypes
 * - changed the WATCH macro
 * - completed the process restructuring
 *
 * Revision 1.2  2002/09/15 07:52:27  juengel
 * Added some sliders in ColorSpaceDlgBar.
 *
 * Revision 1.1  2002/09/10 15:49:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/08/30 17:13:55  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.2  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2002/04/25 14:50:34  kallnik
 * changed double/float to double
 * added several #include GTMath
 *
 * PLEASE use double
 *
 * Revision 1.3  2002/02/12 13:05:34  juengel
 * Added OpenGLMethods to project.
 *
 * Revision 1.2  2002/02/10 12:19:35  juengel
 * Polygon surface added.
 *
 * Revision 1.1  2002/02/09 15:13:37  juengel
 * ColorSpaceDlgBar added.
 *
 *
 */
