/**
* @file BehaviorTeamMessage.h
*
* Declaration of class BehaviorTeamMessage
*
* @author Martin Ltzsch
*/ 

#ifndef __BehaviorTeamMessage_h_
#define __BehaviorTeamMessage_h_

#include "Tools/Streams/InOut.h"
#include "Tools/Player.h"




/** 
* @class BehaviorTeamMessage
*
* Represents a message that is exchanged between the behaviors of different robots.
*
* @author Martin Loetzsch
*/
class BehaviorTeamMessage
{
public:
/**
* Constructor.
  */
  BehaviorTeamMessage();

  /** The time that the sender of the message estimates for reaching the ball */
  double estimatedTimeToReachBall;

  /**
  * Different discrete messages that can be exchanged.
  * Used by XabslBehaviorControl.
  */
  enum Message
  {
    none, /*!< no message */

      justPerformedAKick, /*!< The player performed a kick. Used by GT2003BehaviorControl */
      performingAKick, /*!< The player performes a kick. Used by GT2003BehaviorControl */
      preparingAKick, /*!< The player prepares a kick. Used by GT2003BehaviorControl */
      sync            /*!< The player sends a sync signal. Used to synchronise behavior */
  };
  
  /** the message */
  Message message;

  /** 
  * The game state of the sender.
  * Used by Humboldt2003BehaviorControl and GT2003BehaviorControl.
  */
  enum GameState { sleep, initial, ready, set, playing, penalized, finished } gameState;

  /** 
  * The dynamic role of the sender.
  * Used by DDD2003BehaviorControl and GT2003BehaviorControl.
  */
  enum DynamicRole { goalie, striker, offensiveSupporter, defensiveSupporter } dynamicRole;

  typedef struct WalkR
  {
    double type;
    double x;
    double y;
    double rotation;
  } WalkRequest;

  /**
	* the MothionRequest from the Dog at the bridge.
	* Used by OpenChallange04
	*/
  WalkR walkRequest;

  /** the status of the open challenge */
  int ocStatus;
};



/**
* Streaming operator that reads a BehaviorTeamMessage from a stream.
* @param stream The stream from which is read.
* @param behaviorTeamMessage The BehaviorTeamMessage object.
* @return The stream.
*/ 
In& operator>>(In& stream,BehaviorTeamMessage& behaviorTeamMessage);

/**
* Streaming operator that writes a BehaviorTeamMessage to a stream.
* @param stream The stream to write on.
* @param behaviorTeamMessage The BehaviorTeamMessage object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const BehaviorTeamMessage& behaviorTeamMessage);

#endif //__BehaviorTeamMessage_h_

/*
* Change log :
*
* $Log: BehaviorTeamMessage.h,v $
* Revision 1.2  2004/05/22 22:31:16  loetzsch
* removed
*
* Revision 1.1.1.1  2004/05/22 17:26:04  cvsadm
* created new repository GT2004_WM
*
* Revision 1.8  2004/05/17 17:17:50  kerdels
* added symbols for the sequence control of the open challenge,
* fixed a bug concerning 5-dog-mode and distribution of option-ratings,
* set one = 0 in enum Player::playerNumber --> just to be sure ;-)
*
* Revision 1.7  2004/05/08 16:18:13  hamerla
* Open Challenge
*
* Revision 1.6  2004/05/03 22:23:36  risler
* added goal and final stuff
*
* Revision 1.5  2004/03/25 17:37:42  loetzsch
* added a few elements in sent-game-state
*
* Revision 1.4  2004/03/24 14:02:33  tim
* added "set" state
*
* Revision 1.3  2004/01/25 16:17:12  kerdels
* fixed a bug and reduced network traffic
*
* Revision 1.2  2003/12/17 20:09:59  kerdels
* BehaviorTeamMessage um eine Eigenschaft ratedOptions erweitert,
* CollectedBeliefs.update() und .broadcast() implementiert.
*
* Revision 1.1  2003/10/07 10:09:36  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/07/02 20:43:34  dueffert
* warning removed
*
* Revision 1.2  2003/07/02 19:14:23  loetzsch
* bug fixes, removed unused functions
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.8  2003/05/31 14:37:47  loetzsch
* removed conflicts
*
* Revision 1.7  2003/05/30 13:17:26  timrie
* added symbols:
*   performingAKick
*   preparingAKick
*
* Revision 1.6  2003/05/27 16:52:53  loetzsch
* first passing experiments
*
* Revision 1.5  2003/05/08 00:23:44  risler
* added strategy symbols
*
* Revision 1.4  2003/04/15 15:52:12  risler
* DDD GO 2003 code integrated
*
* Revision 1.5  2003/04/11 04:14:52  max
* added symbol all players sync
*
* Revision 1.4  2003/04/06 18:52:03  dthomas
* modified: dynamicRole added to BehaviorTeamMessage, moved functions to DDD-behavior-control and updated all calls
*
* Revision 1.3  2003/03/28 14:43:57  max
* tamara update
*
* Revision 1.3  2003/03/28 14:14:25  loetzsch
* removed bar challenge related messages,
* added gameState
*
* Revision 1.2  2002/09/22 18:40:51  risler
* added new math functions, removed GTMath library
*
* Revision 1.1  2002/09/10 15:26:41  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed Challenge Code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.6  2002/08/29 14:41:13  dueffert
* includes in correct case, system includes in <>
*
* Revision 1.5  2002/07/23 13:32:57  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.4  2002/06/12 13:24:22  loetzsch
* added behavior team messages for the strikers
* pattern challenge behavior
*
* Revision 1.3  2002/06/12 10:28:34  risler
* behavior team messages added as xabsl symbols
*
* Revision 1.2  2002/06/09 15:24:51  loetzsch
* Added TeamMessageCollection and BehaviorTeamMessage to the execute of BehaviorControl
*
* Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.1  2002/05/05 14:05:39  loetzsch
* first draft
*
*/

