/**
* @file BehaviorTeamMessage.cpp
*
* Implementation of class BehaviorTeamMessage.
*
* @author Martin Loetzsch
*/

#include "BehaviorTeamMessage.h"

BehaviorTeamMessage::BehaviorTeamMessage() : 
estimatedTimeToReachBall(1000),
message(none),
gameState(sleep),
dynamicRole(striker)
{
  walkRequest.type = 0;
  walkRequest.x = 0;
  walkRequest.y = 0;
  walkRequest.rotation = 0;
  ocStatus = 0;
}

In& operator>>(In& stream,BehaviorTeamMessage& behaviorTeamMessage)
{
  stream >> behaviorTeamMessage.estimatedTimeToReachBall;
  char a;
  stream >> a;
  behaviorTeamMessage.message = (BehaviorTeamMessage::Message)a;
  stream >> a;
  behaviorTeamMessage.gameState = (BehaviorTeamMessage::GameState)a;
  stream >> a;
  behaviorTeamMessage.dynamicRole = (BehaviorTeamMessage::DynamicRole)a;

  stream >> behaviorTeamMessage.walkRequest.type;
  stream >> behaviorTeamMessage.walkRequest.x;
  stream >> behaviorTeamMessage.walkRequest.y;
  stream >> behaviorTeamMessage.walkRequest.rotation;
  
  stream >> behaviorTeamMessage.ocStatus;
	return stream;
}

Out& operator<<(Out& stream, const BehaviorTeamMessage& behaviorTeamMessage)
{
  stream << behaviorTeamMessage.estimatedTimeToReachBall
    << (char)behaviorTeamMessage.message 
    << (char)behaviorTeamMessage.gameState
    << (char)behaviorTeamMessage.dynamicRole;

  stream << behaviorTeamMessage.walkRequest.type;
  stream << behaviorTeamMessage.walkRequest.x;
  stream << behaviorTeamMessage.walkRequest.y;
  stream << behaviorTeamMessage.walkRequest.rotation;

  stream << behaviorTeamMessage.ocStatus;
	return stream;
}

/*
* Change log :
* 
* $Log: BehaviorTeamMessage.cpp,v $
* Revision 1.2  2004/05/22 22:31:16  loetzsch
* removed
*
* Revision 1.1.1.1  2004/05/22 17:26:04  cvsadm
* created new repository GT2004_WM
*
* Revision 1.5  2004/05/17 17:17:50  kerdels
* added symbols for the sequence control of the open challenge,
* fixed a bug concerning 5-dog-mode and distribution of option-ratings,
* set one = 0 in enum Player::playerNumber --> just to be sure ;-)
*
* Revision 1.4  2004/05/08 16:18:13  hamerla
* Open Challenge
*
* Revision 1.3  2004/03/25 17:37:42  loetzsch
* added a few elements in sent-game-state
*
* Revision 1.2  2003/12/17 20:09:58  kerdels
* BehaviorTeamMessage um eine Eigenschaft ratedOptions erweitert,
* CollectedBeliefs.update() und .broadcast() implementiert.
*
* Revision 1.1  2003/10/07 10:09:36  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2003/04/15 15:52:12  risler
* DDD GO 2003 code integrated
*
* Revision 1.4  2003/04/06 18:52:03  dthomas
* modified: dynamicRole added to BehaviorTeamMessage, moved functions to DDD-behavior-control and updated all calls
*
* Revision 1.3  2003/03/28 14:14:25  loetzsch
* removed bar challenge related messages,
* added gameState
*
* Revision 1.2  2003/03/06 11:07:01  dueffert
* re-order warning removed
*
* Revision 1.1  2002/09/10 15:26:41  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed Challenge Code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.6  2002/06/20 00:40:19  Thomas Rfer
* WLan crash removed
*
* Revision 1.5  2002/06/18 11:58:33  loetzsch
* Game against UPenn
*
* Revision 1.4  2002/06/18 04:07:56  loetzsch
* temporarily removed negotiate for who is closer to the ball
*
* Revision 1.3  2002/06/13 21:51:38  loetzsch
* smarter streaming operators
*
* Revision 1.2  2002/06/09 15:24:51  loetzsch
* Added TeamMessageCollection and BehaviorTeamMessage to the execute of BehaviorControl
*
* Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.1  2002/05/05 14:05:39  loetzsch
* first draft
*
* Revision 1.1  2002/05/04 17:41:49  loetzsch
* added BehaviorTeamMessage to the Project
*
*/
