/**
 * @file SoundData.h
 *
 * Definition of SoundData.
 *
 * @author <a href="mailto:Oliver.Giese@uni-dortmund.de">Oliver Giese</a>
 * @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
 *
 */

#ifndef __SoundData_h_
#define __SoundData_h_

#include "Tools/Streams/InOut.h"

/**
 * The SoundData is a non NDA violating description of Sound Vector data.
 */
class SoundData
{
public:
  char pcmBuffer[256];
  bool isInUse;

 /**
  * constructs a SoundData.
  */ 
  SoundData();
  
  /**
   * deconstructs a SoundData.
   */
  ~SoundData();
};

/**
 * Streaming operator that reads the SoundData from a stream.
 * @param stream The stream from which is read.
 * @param soundData The SoundSendData object.
 * @return The stream.
 */ 
In& operator>>(In& stream,SoundData& soundData);
 
#endif //__SoundData_h_

/*
 * Change log :
 * 
 * $Log: SoundData.h,v $
 * Revision 1.1.1.1  2004/05/22 17:26:04  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/11/28 23:04:28  hebbel
 * added variable isInUse
 *
 * Revision 1.1  2002/09/10 15:26:41  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/08/22 14:41:03  risler
 * added some doxygen comments
 *
 * Revision 1.2  2002/07/23 13:32:57  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/04/28 19:09:25  giese
 * SoundPlay added...
 *
 *
 *
 */
