/**
 * @file SoundData.cpp
 *
 * Implementation of class SoundData
 *
 * @author <a href="mailto:Oliver.Giese@uni-dortmund.de">Oliver Giese</a>
 * @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
 *
 */ 
#include "SoundData.h"
#include <string.h>

SoundData::SoundData()
{
  isInUse = false;
  memset(pcmBuffer, 0, 256);
}

SoundData::~SoundData()
{
}

In& operator>>(In& stream,SoundData& soundData)
{
  stream.read(&soundData,sizeof(SoundData));
  return stream;
}

/*
 * Change log :
 * 
 * $Log: SoundData.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:26:04  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/11/28 23:04:28  hebbel
 * added variable isInUse
 *
 * Revision 1.1  2002/09/10 15:26:41  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/04/28 19:09:25  giese
 * SoundPlay added...
 *
 *
 *
 */
