/**
 * @file SensorData.cpp
 *
 * Implementation of class SensorData.
 */

#include "SensorData.h"

SensorData::SensorData()
{
  init();
}

SensorData::~SensorData()
{
}

void SensorData::init()
{
  for(int i = 0; i < numOfSensor_ERS7; ++i)
  {
    data[i] = 0;
    refValue[i] = 0;
  }
  data[accelerationZ] = -9810000;
  frameNumber = 0;
}

Out& operator<<(Out& stream, const SensorData& sensorData)
{
  stream.write(&sensorData,sizeof(SensorData));
  return stream;
}

In& operator>>(In& stream, SensorData& sensorData)
{
  stream.read(&sensorData,sizeof(SensorData));
  return stream;
}

/*
 * Change log :
 * 
 * $Log: SensorData.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:25:59  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/31 20:16:14  roefer
 * SensorData for ERS-7
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/03 15:26:29  risler
 * added refValue to SensorData
 *
 * Revision 1.2  2003/05/02 18:26:18  risler
 * SensorDataBuffer added
 * replaced SensorData with SensorDataBuffer
 * full SensorData resolution now accessible
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/03/29 23:09:53  roefer
 * SensorData initialized to avoid detection of falling down state
 *
 * Revision 1.5  2001/12/28 09:00:02  roefer
 * Streaming operator and frameNumber inserted
 *
 * Revision 1.4  2001/12/23 23:38:04  petters
 * method init added
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
