/**
* @file PSDPercept.cpp
*
* Implementation of class PSDPercept
*
* @author Martin Ltzsch
*/

#include "PSDPercept.h"

PSDPercept::PSDPercept()
: numOfPercepts(0)
{
}

PSDPercept::~PSDPercept()
{
}

SinglePSDPercept::SinglePSDPercept()
: Vector3<double>(0,0,0),
tooFarAway(false),
neckTilt(0.0),
body(0)
{
}

SinglePSDPercept::~SinglePSDPercept()
{
}


In& operator>>(In& stream,SinglePSDPercept& psdPercept)
{
  stream.read(&psdPercept, sizeof(SinglePSDPercept));
  return stream;
}

Out& operator<<(Out& stream, const SinglePSDPercept& psdPercept)
{
  stream.write(&psdPercept, sizeof(SinglePSDPercept));
  return stream;
}

In& operator>>(In& stream,PSDPercept& psdPercept)
{
  stream >> psdPercept.numOfPercepts;
  for (int i=0; i<psdPercept.numOfPercepts; i++)
    stream >> psdPercept[i];
  return stream;
}

Out& operator<<(Out& stream, const PSDPercept& psdPercept)
{
  stream << psdPercept.numOfPercepts;
  for (int i=0; i<psdPercept.numOfPercepts; i++)
    stream << psdPercept[i];
  return stream;
}

/*
* Change Log:
*
* $Log: PSDPercept.cpp,v $
* Revision 1.2  2004/05/27 17:13:38  jhoffman
* - renaming: tilt1 -> neckTilt,  pan -> headPan,  tilt2 -> headTilt
* - clipping included for setJoints
* - removed some microrad/rad-bugs
* - bodyPosture constructor and "=" operator fixed
*
* Revision 1.1.1.1  2004/05/22 17:25:59  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/03/10 14:16:33  risler
* body psd value added to PSDPercept and ObstaclesModel
*
* Revision 1.3  2004/01/19 14:54:14  dueffert
* useless double streaming removed
*
* Revision 1.2  2003/11/14 19:02:25  goehring
* frameNumber added
*
* Revision 1.1  2003/10/07 10:09:36  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/05/14 19:54:42  risler
* PSDPercept contains all points from one frame
*
* Revision 1.2  2003/04/06 17:14:37  jhoffman
* added headTilt to PSDpercept and added debugging capabilities to microsectors
*
* Revision 1.1  2002/10/10 13:09:50  loetzsch
* First experiments with the PSD Sensor
* - SensorDataProcessor now calculates PSDPercept
* - Added the PerceptBehaviorControl solution PSDTest
* - Added the RadarViewer3D to RobotControl, which can display the Points3D structure
*
*/

