/**
 * @file LowResImage.cpp
 *
 * @author Max Risler
 * 
 * Implementation of class LowResImage
 */ 

#include "LowResImage.h"

Out& operator<<(Out& stream,const LowResImage& lrImage)
{
  stream << lrImage.image.cameraInfo.resolutionWidth << lrImage.image.cameraInfo.resolutionHeight << lrImage.image.frameNumber;
  for(int y = 0; y < lrImage.image.cameraInfo.resolutionHeight; ++y)
    for(int c = 0; c < 3; ++c)
      stream.write(&lrImage.image.image[y][c][0], lrImage.image.cameraInfo.resolutionWidth);

  return stream;
}

In& operator>>(In& stream,LowResImage& lrImage)
{
  stream >> lrImage.image.cameraInfo.resolutionWidth 
         >> lrImage.image.cameraInfo.resolutionHeight 
         >> lrImage.image.frameNumber;

  lrImage.image.setCameraInfo();
	
  for(int y = 0; y < lrImage.image.cameraInfo.resolutionHeight; ++y)
  {
    int c;
    for(c = 0; c < 3; ++c)
      stream.read(&lrImage.image.image[y][c][0], lrImage.image.cameraInfo.resolutionWidth);
    for(c = 3; c < 6; ++c)
      memset(&lrImage.image.image[y][c][0], 128, lrImage.image.cameraInfo.resolutionWidth);
  }

	return stream;
}


/*
 * Change log :
 * 
 * $Log: LowResImage.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:25:51  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2004/04/07 13:00:44  risler
 * ddd checkin after go04 - second part
 *
 * Revision 1.1  2004/04/07 11:45:13  risler
 * added sending low res images
 * added Image::setCameraInfo
 *
 *
 */
